/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task.ui;

import javax.swing.DefaultListModel;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.users.User;
import org.openconcerto.sql.users.UserManager;

public class UserListModel
extends DefaultListModel<User> {
    private final UserManager uMngr;
    private final SQLTableModifiedListener l;
    private SQLTable t;

    public UserListModel(UserManager uMngr) {
        this.uMngr = uMngr;
        this.l = new SQLTableModifiedListener(){

            @Override
            public void tableModified(SQLTableEvent evt) {
                UserListModel.this.clearAndReload();
            }
        };
        this.t = null;
    }

    public final void start() {
        if (this.t == null) {
            this.t = this.uMngr.getTable();
            this.t.addTableModifiedListener(this.l);
            this.l.tableModified(null);
        }
    }

    public final void stop() {
        if (this.t != null) {
            this.t.removeTableModifiedListener(this.l);
            this.t = null;
        }
    }

    private void reload() {
        for (User u : this.uMngr.getUsers().values()) {
            this.addElement(u);
        }
    }

    public final void clearAndReload() {
        this.clear();
        this.reload();
    }
}

