/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.core.common.element.StyleSQLElement;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.generationDoc.MetaDataSheet;
import org.openconcerto.erp.generationDoc.OOXMLCache;
import org.openconcerto.erp.generationDoc.OOXMLElement;
import org.openconcerto.erp.generationDoc.OOXMLTableElement;
import org.openconcerto.erp.generationDoc.OOXMLTableField;
import org.openconcerto.erp.generationDoc.OOXMLTableImage;
import org.openconcerto.erp.generationDoc.SheetUtils;
import org.openconcerto.erp.generationDoc.TemplateManager;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.openoffice.LengthUnit;
import org.openconcerto.openoffice.ODFrame;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.spreadsheet.BytesProducer;
import org.openconcerto.openoffice.spreadsheet.MutableCell;
import org.openconcerto.openoffice.spreadsheet.Sheet;
import org.openconcerto.openoffice.spreadsheet.SpreadSheet;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBackgroundTableCacheItem;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.io.BOMSkipper;

public class OOgenerationXML {
    private static int answer = 1;
    private DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private Map<Sheet, Map<String, Map<Integer, String>>> cacheStyle = new HashMap<Sheet, Map<String, Map<Integer, String>>>();
    private Map<SQLRowAccessor, Map<String, Object>> taxe = new HashMap<SQLRowAccessor, Map<String, Object>>();
    private Map<String, Map<Integer, SQLRowAccessor>> cacheForeign = new HashMap<String, Map<Integer, SQLRowAccessor>>();
    private Map<String, List<? extends SQLRowAccessor>> rowsEltCache = new HashMap<String, List<? extends SQLRowAccessor>>();
    private final OOXMLCache rowRefCache = new OOXMLCache();
    private final SQLRow row;

    public OOgenerationXML(SQLRow row) {
        this.row = row;
    }

    public void setPostProcess(ITransformer<List<SQLRowAccessor>, List<SQLRowAccessor>> postProcess) {
        this.rowRefCache.setPostProcess(postProcess);
    }

    public synchronized File createDocument(String templateId, String typeTemplate, File outputDirectory, String expectedFileName, SQLRow rowLanguage) {
        return this.createDocument(templateId, typeTemplate, outputDirectory, expectedFileName, rowLanguage, null);
    }

    public synchronized File createDocument(String templateId, String typeTemplate, File outputDirectory, final String expectedFileName, SQLRow rowLanguage, MetaDataSheet meta) {
        SpreadSheet spreadSheet;
        InputStream templateStream;
        List<Element> listElts;
        Element racine;
        block20: {
            InputStream xmlConfiguration;
            SAXBuilder builder;
            String langage;
            block19: {
                langage = rowLanguage != null ? rowLanguage.getString("CHEMIN") : null;
                this.cacheStyle.clear();
                this.rowRefCache.clearCache();
                this.rowsEltCache.clear();
                this.taxe.clear();
                this.cacheForeign.clear();
                File fDest = new File(outputDirectory, expectedFileName);
                if (fDest.exists()) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        answer = JOptionPane.showConfirmDialog(null, "Voulez vous reg\u00e9n\u00e9rer et \u00e9craser l'ancien document?", "G\u00e9n\u00e9ration du document", 0);
                        Thread.dumpStack();
                    } else {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    answer = JOptionPane.showConfirmDialog(null, "Voulez vous reg\u00e9n\u00e9rer et \u00e9craser l'ancien document?", "G\u00e9n\u00e9ration du document", 0);
                                }
                            });
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                    if (answer != 0) {
                        return fDest;
                    }
                }
                builder = new SAXBuilder();
                if (this.needAnnexe(templateId, typeTemplate, this.row, rowLanguage)) {
                    String annexeTemplateId = String.valueOf(templateId) + "_annexe";
                    InputStream annexeStream = TemplateManager.getInstance().getTemplate(annexeTemplateId, langage, typeTemplate);
                    if (annexeStream != null) {
                        templateId = annexeTemplateId;
                        annexeStream.close();
                        System.err.println("OOgenerationXML.createDocument() : modele With annexe " + templateId);
                    }
                }
                System.err.println("OOgenerationXML.createDocument() : using template id : " + templateId);
                xmlConfiguration = TemplateManager.getInstance().getTemplateConfiguration(templateId, langage, typeTemplate);
                if (xmlConfiguration != null) break block19;
                JOptionPane.showMessageDialog(null, "Fichier de configuration manquant pour " + templateId + " " + (rowLanguage == null ? "" : rowLanguage.getString("CHEMIN")) + " " + (typeTemplate == null ? "" : typeTemplate));
                return null;
            }
            BufferedReader xmlConfigurationReader = new BufferedReader(new InputStreamReader(xmlConfiguration, Charset.forName("UTF8")));
            BOMSkipper.skip(xmlConfigurationReader);
            Document doc = builder.build(xmlConfigurationReader);
            xmlConfigurationReader.close();
            xmlConfiguration.close();
            racine = doc.getRootElement();
            listElts = racine.getChildren("element");
            templateStream = TemplateManager.getInstance().getTemplate(templateId, langage, typeTemplate);
            if (templateStream != null) break block20;
            JOptionPane.showMessageDialog(null, "Mod\u00e8le manquant pour " + templateId + " " + (rowLanguage == null ? "" : rowLanguage.getString("CHEMIN")) + " " + (typeTemplate == null ? "" : typeTemplate));
            return null;
        }
        try {
            spreadSheet = new ODPackage(templateStream).getSpreadSheet();
            templateStream.close();
            this.parseElementsXML(listElts, this.row, spreadSheet);
            List<Element> listTable = racine.getChildren("table");
            for (Element tableChild : listTable) {
                this.parseTableauXML(tableChild, spreadSheet, rowLanguage);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de remplir le document " + templateId + " " + (rowLanguage == null ? "" : rowLanguage.getString("CHEMIN")), e);
            e.printStackTrace();
            return null;
        }
        try {
            if (meta != null) {
                meta.applyTo(spreadSheet.getPackage().getMeta(true));
            }
            return OOgenerationXML.saveSpreadSheet(spreadSheet, outputDirectory, expectedFileName, templateId, rowLanguage);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration du fichier " + expectedFileName, e);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExceptionHandler.handle("Erreur lors de la cr\u00e9ation du fichier " + expectedFileName, e);
                }
            });
        }
        return null;
    }

    private void parseTableauXML(Element tableau, SpreadSheet spreadsheet, SQLRow rowLanguage) {
        if (tableau == null) {
            return;
        }
        String o = tableau.getAttributeValue("sheet");
        int idSheet = o == null ? 0 : Integer.valueOf(o.toString().trim());
        Sheet sheet = spreadsheet.getSheet(idSheet);
        String oLastColTmp = tableau.getAttributeValue("lastColumn");
        int lastColumn = -1;
        int endPageLine = Integer.parseInt(tableau.getAttributeValue("endPageLine"));
        if (oLastColTmp != null) {
            lastColumn = sheet.resolveHint((String)new StringBuilder((String)String.valueOf((Object)oLastColTmp.toString())).append((int)1).toString()).x + 1;
        }
        Map<String, Map<Integer, String>> mapStyle = this.searchStyle(sheet, lastColumn, endPageLine);
        if (tableau.getAttributeValue("table").equalsIgnoreCase("TVA")) {
            this.fillTaxeDocumentMap(tableau, sheet, mapStyle, false);
            return;
        }
        int nbPage = this.fillTable(tableau, this.row, sheet, mapStyle, true, rowLanguage);
        int firstLine = Integer.parseInt(tableau.getAttributeValue("firstLine"));
        int endLine = Integer.parseInt(tableau.getAttributeValue("endLine"));
        Object printRangeObj = sheet.getPrintRanges();
        System.err.println("Nombre de page == " + nbPage);
        if (nbPage == 1) {
            this.fillTable(tableau, this.row, sheet, mapStyle, false, rowLanguage);
        } else {
            String pageRef;
            if (printRangeObj != null) {
                String s = printRangeObj.toString();
                String[] range = s.split(":");
                int i = 0;
                while (i < range.length) {
                    String string = range[i];
                    range[i] = string.subSequence(string.indexOf(46) + 1, string.length()).toString();
                    ++i;
                }
                int rowEnd = -1;
                if (range.length > 1) {
                    rowEnd = sheet.resolveHint((String)range[1]).y + 1;
                    int rowEndNew = rowEnd * nbPage;
                    String sNew = s.replaceAll(String.valueOf(rowEnd), String.valueOf(rowEndNew));
                    sheet.setPrintRanges(sNew);
                    System.err.println(" ******  Replace print ranges; Old:" + rowEnd + "--" + s + " New:" + rowEndNew + "--" + sNew);
                }
            }
            sheet.duplicateFirstRows(endLine, 1);
            int lineToAdd = endPageLine - endLine;
            String repeatedCount = tableau.getAttributeValue("repeatedCount");
            if (repeatedCount != null && repeatedCount.trim().length() > 0) {
                int count = Integer.parseInt(repeatedCount);
                sheet.duplicateRows(firstLine, lineToAdd / count, count);
                int rest = lineToAdd % count;
                if (rest != 0) {
                    sheet.insertDuplicatedRows(firstLine + lineToAdd - rest, rest);
                }
            } else {
                sheet.insertDuplicatedRows(firstLine, lineToAdd);
            }
            System.err.println("nbPage == " + nbPage);
            if (nbPage > 2) {
                sheet.duplicateFirstRows(endPageLine, nbPage - 2);
            }
            if ((pageRef = tableau.getAttributeValue("pageRef")) != null && pageRef.trim().length() > 0) {
                int nbPageRef = nbPage;
                String pageAdd = tableau.getAttributeValue("pageRefAdditional");
                if (pageAdd != null && pageAdd.trim().length() > 0) {
                    nbPageRef += Integer.valueOf(pageAdd).intValue();
                }
                MutableCell cell = sheet.getCellAt(pageRef);
                String pageStart = tableau.getAttributeValue("pageRefStart");
                int start = 1;
                if (pageStart != null && pageStart.trim().length() > 0) {
                    cell.setValue((Object)("Page " + pageStart + "/" + nbPageRef));
                    start = Integer.valueOf(pageStart);
                } else {
                    cell.setValue((Object)("Page 1/" + nbPageRef));
                }
                int i = 1;
                while (i < nbPageRef) {
                    MutableCell cell2 = sheet.getCellAt(cell.getX(), cell.getY() + endPageLine * i);
                    cell2.setValue((Object)("Page " + (i + start) + "/" + nbPageRef));
                    ++i;
                }
                if (pageAdd != null && pageAdd.trim().length() > 0) {
                    int pAdd = Integer.parseInt(pageAdd);
                    int i2 = 0;
                    while (i2 < pAdd) {
                        Sheet s = sheet.getSpreadSheet().getSheet(idSheet + i2 + 1);
                        MutableCell cell2 = s.getCellAt(pageRef);
                        cell2.setValue((Object)("Page " + (nbPageRef - (pAdd - i2) + 1) + "/" + nbPageRef));
                        ++i2;
                    }
                }
            }
            this.fillTable(tableau, this.row, sheet, mapStyle, false, rowLanguage);
        }
    }

    protected SQLRowAccessor getForeignRow(SQLRowAccessor row, SQLField field) {
        Map<Integer, SQLRowAccessor> c = this.cacheForeign.get(field.getName());
        int i = row.getInt(field.getName());
        if (c != null && c.get(i) != null) {
            return c.get(i);
        }
        SQLRowAccessor foreign = row.getForeign(field.getName());
        if (c == null) {
            HashMap<Integer, SQLRowAccessor> map = new HashMap<Integer, SQLRowAccessor>();
            map.put(i, foreign);
            this.cacheForeign.put(field.getName(), map);
        } else {
            c.put(i, foreign);
        }
        return foreign;
    }

    private void fillTaxe(Element tableau, List<? extends SQLRowAccessor> rows) {
        SQLTable tableElt = Configuration.getInstance().getRoot().findTable(tableau.getAttributeValue("table"));
        SQLBackgroundTableCacheItem cacheItem = SQLBackgroundTableCache.getInstance().getCacheForTable(tableElt.getTable("COMPTE_PCE"));
        SQLBackgroundTableCacheItem prefsCpt = SQLBackgroundTableCache.getInstance().getCacheForTable(tableElt.getTable("PREFS_COMPTE"));
        if (tableElt.contains("ID_TAXE") && tableElt.contains("T_PA_HT")) {
            SQLRow produitCompte;
            SQLRow serviceCompte;
            boolean achat = tableElt.contains("T_PA_TTC");
            TotalCalculator calc = new TotalCalculator("T_PA_HT", achat ? "T_PA_HT" : "T_PV_HT", null, achat, null, null);
            String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
            Boolean bServiceActive = Boolean.valueOf(val);
            calc.setServiceActive(bServiceActive != null && bServiceActive != false);
            if (this.row.getTable().contains("ID_COMPTE_PCE_SERVICE") && !this.row.isForeignEmpty("ID_COMPTE_PCE_SERVICE") && !(serviceCompte = cacheItem.getRowFromId(this.row.getForeignID("ID_COMPTE_PCE_SERVICE"))).isUndefined()) {
                calc.setRowDefaultCptService(serviceCompte);
            }
            if (this.row.getTable().contains("ID_COMPTE_PCE_VENTE") && !this.row.isForeignEmpty("ID_COMPTE_PCE_VENTE") && !(produitCompte = cacheItem.getRowFromId(this.row.getForeignID("ID_COMPTE_PCE_VENTE"))).isUndefined()) {
                calc.setRowDefaultCptProduit(produitCompte);
            }
            long remise = 0L;
            BigDecimal totalAvtRemise = BigDecimal.ZERO;
            SQLTable tableEchantillon = null;
            if (this.row.getTable().contains("REMISE_HT") && (remise = this.row.getLong("REMISE_HT")) != 0L) {
                for (SQLRowAccessor sQLRowAccessor : rows) {
                    calc.addLine(sQLRowAccessor, sQLRowAccessor.getForeign("ID_ARTICLE"), 1, false);
                }
                if (tableEchantillon != null) {
                    Collection collection = this.row.getReferentRows(tableEchantillon);
                    for (SQLRow sqlRow : collection) {
                        calc.addEchantillon((BigDecimal)sqlRow.getObject("T_PV_HT"), TaxeCache.getCache().getRowFromId(sqlRow.getForeignID("ID_TAXE")));
                    }
                }
                calc.checkResult();
                totalAvtRemise = calc.getTotalHT();
            }
            calc.initValues();
            long l = remise;
            if (this.row.getFields().contains("POURCENT_FACTURABLE") && this.row.getFields().contains("MONTANT_FACTURABLE")) {
                BigDecimal montantFact = this.row.getBigDecimal("MONTANT_FACTURABLE");
                BigDecimal percentFact = this.row.getBigDecimal("POURCENT_FACTURABLE");
                if (montantFact != null && montantFact.signum() > 0) {
                    l = 0L;
                } else if (percentFact != null && percentFact.signum() > 0) {
                    l = percentFact.movePointLeft(2).multiply(new BigDecimal(remise)).setScale(0, RoundingMode.HALF_UP).longValue();
                }
            }
            calc.setRemise(l, totalAvtRemise);
            if (this.row.getTable().contains("TVA_ADJUSTMENT")) {
                BigDecimal tvaFix = this.row.getBigDecimal("TVA_ADJUSTMENT");
                calc.addTVAAdjust(tvaFix);
            }
            int i = 0;
            while (i < rows.size()) {
                SQLRowAccessor sqlRow = rows.get(i);
                calc.addLine(sqlRow, sqlRow.getForeign("ID_ARTICLE"), i, i == rows.size() - 1);
                ++i;
            }
            if (tableEchantillon != null) {
                Collection rowsEch = this.row.getReferentRows(tableEchantillon);
                for (SQLRowAccessor sqlRow : rowsEch) {
                    calc.addEchantillon((BigDecimal)((SQLRow)sqlRow).getObject("T_PV_HT"), TaxeCache.getCache().getRowFromId(sqlRow.getForeignID("ID_TAXE")));
                }
            }
            SQLRowAccessor rowTVAPort = null;
            if (this.row.getTable().contains("ID_TAXE_PORT")) {
                rowTVAPort = TaxeCache.getCache().getRowFromId(this.row.getForeignID("ID_TAXE_PORT"));
            }
            if (rowTVAPort != null && !rowTVAPort.isUndefined()) {
                SQLRow rowDefaultCptPort;
                SQLRowValues rowValsPort = new SQLRowValues(tableElt);
                rowValsPort.put("T_PV_HT", BigDecimal.valueOf(this.row.getLong("PORT_HT")).movePointLeft(2));
                rowValsPort.put("QTE", 1);
                rowValsPort.put("ID_TAXE", rowTVAPort.getIDNumber());
                SQLRow rowPrefsCompte = prefsCpt.getRowFromId(2);
                if (rowTVAPort.getFloat("TAUX") > 0.0f) {
                    rowDefaultCptPort = cacheItem.getRowFromId(rowPrefsCompte.getForeignID("ID_COMPTE_PCE_PORT_SOUMIS"));
                    if (rowDefaultCptPort == null || rowDefaultCptPort.isUndefined()) {
                        try {
                            rowDefaultCptPort = ComptePCESQLElement.getRowComptePceDefault("PortVenteSoumisTVA");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    rowDefaultCptPort = cacheItem.getRowFromId(rowPrefsCompte.getForeignID("ID_COMPTE_PCE_PORT_NON_SOUMIS"));
                    if (rowDefaultCptPort == null || rowDefaultCptPort.isUndefined()) {
                        try {
                            rowDefaultCptPort = ComptePCESQLElement.getRowComptePceDefault("PortVenteNonSoumisTVA");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                rowValsPort.putRowValues("ID_ARTICLE").put("ID_COMPTE_PCE", rowDefaultCptPort.getID()).put("ID_COMPTE_PCE_ACHAT", rowDefaultCptPort.getID());
                calc.addLine(rowValsPort, rowValsPort.getForeign("ID_ARTICLE"), 1, false);
            }
            if (this.row.getTable().contains("FRAIS_DOCUMENT_HT") && this.row.getTable().contains("ID_TAXE_FRAIS_DOCUMENT")) {
                BigDecimal fraisDoc = BigDecimal.valueOf(this.row.getLong("FRAIS_DOCUMENT_HT")).movePointLeft(2);
                SQLRow tvafraisDoc = this.row.getForeign("ID_TAXE_FRAIS_DOCUMENT");
                if (tvafraisDoc != null && fraisDoc.signum() != 0 && !tvafraisDoc.isUndefined()) {
                    SQLRowValues rowValsfraisDoc = new SQLRowValues(tableElt);
                    rowValsfraisDoc.put("T_PV_HT", fraisDoc);
                    rowValsfraisDoc.put("QTE", 1);
                    rowValsfraisDoc.put("ID_TAXE", ((SQLRowAccessor)tvafraisDoc).getIDNumber());
                    rowValsfraisDoc.put("SERVICE", Boolean.TRUE);
                    rowValsfraisDoc.put("ID_FAMILLE_ARTICLE", null);
                    calc.addLine(rowValsfraisDoc, null, 1, false);
                }
            }
            calc.checkResult();
            Map<SQLRowAccessor, Tuple2<BigDecimal, BigDecimal>> taxeCalc = calc.getMapHtTVARowTaux();
            for (SQLRowAccessor sqlRow : taxeCalc.keySet()) {
                Tuple2<BigDecimal, BigDecimal> v = taxeCalc.get(sqlRow);
                HashMap<String, BigDecimal> m = new HashMap<String, BigDecimal>();
                m.put("MONTANT_HT", v.get0());
                m.put("MONTANT_TVA", v.get1());
                this.taxe.put(sqlRow, m);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private int fillTable(Element tableau, SQLRow row, Sheet sheet, Map<String, Map<Integer, String>> mapStyle, boolean test, SQLRow rowLanguage) {
        void var16_24;
        if (tableau == null) {
            return 1;
        }
        int nbPage = 1;
        int nbCellules = 0;
        OOXMLTableElement tableElement = new OOXMLTableElement(tableau, row, this.rowRefCache);
        int currentLineTmp = tableElement.getFirstLine();
        int currentLine = tableElement.getFirstLine();
        StyleSQLElement styleElt = Configuration.getInstance().getDirectory().getElement(StyleSQLElement.class);
        String ref = String.valueOf(tableau.getAttributeValue("table")) + "_" + row.getTable().getName() + row.getID();
        if (this.rowsEltCache.get(ref) == null) {
            this.rowsEltCache.put(ref, tableElement.getRows());
        }
        List<Element> listElts = tableau.getChildren("element");
        this.fillTaxe(tableau, this.rowsEltCache.get(ref));
        int numeroRef = 0;
        for (SQLRowAccessor sQLRowAccessor : this.rowsEltCache.get(ref)) {
            boolean included = OOgenerationXML.isIncluded(tableElement.getFilterId(), tableElement.getForeignTableWhere(), tableElement.getFilterId(), tableElement.getFieldWhere(), sQLRowAccessor);
            String styleName = null;
            if (tableElement.getSQLElement().getTable().contains("ID_STYLE")) {
                styleName = styleElt.getAllStyleByIds().get(sQLRowAccessor.getForeignID("ID_STYLE"));
            }
            if (!included && !tableElement.getTypeStyleWhere() || styleName != null && styleName.equalsIgnoreCase("Invisible")) continue;
            ++numeroRef;
            if (included && tableElement.getTypeStyleWhere()) {
                styleName = "Titre 1";
            }
            if (!included) {
                styleName = "Normal";
            }
            boolean first = true;
            int toAdd = 0;
            if (styleName != null && tableElement.getListBlankLineStyle().contains(styleName) && first) {
                ++toAdd;
                ++currentLine;
                first = false;
            }
            HashMap<Element, Object> mapValues = new HashMap<Element, Object>();
            HashMap<String, Integer> tmpMapNbCel = new HashMap<String, Integer>();
            int tmpNbCellule = this.fillTableLine(sheet, mapStyle, true, rowLanguage, tableElement, currentLine, listElts, numeroRef, sQLRowAccessor, tmpMapNbCel, styleName, mapValues);
            for (String s : tmpMapNbCel.keySet()) {
                tmpNbCellule = Math.max(tmpNbCellule, (Integer)tmpMapNbCel.get(s));
            }
            if (currentLine + tmpNbCellule > tableElement.getEndPageLine() * nbPage) {
                toAdd += tableElement.getEndPageLine() * nbPage - currentLine;
                currentLineTmp = currentLine = currentLineTmp + tableElement.getEndPageLine();
                ++nbPage;
            }
            HashMap<String, Integer> mapNbCel = new HashMap<String, Integer>();
            int nbCellule = this.fillTableLine(sheet, mapStyle, test, rowLanguage, tableElement, currentLine, listElts, numeroRef, sQLRowAccessor, mapNbCel, styleName, mapValues);
            for (String s : mapNbCel.keySet()) {
                nbCellule = Math.max(nbCellule, (Integer)mapNbCel.get(s));
            }
            currentLine += nbCellule;
            nbCellules += nbCellule + toAdd;
        }
        int n = nbCellules / (tableElement.getEndPageLine() - tableElement.getFirstLine());
        int r = nbCellules % (tableElement.getEndPageLine() - tableElement.getFirstLine());
        if (n == 0) {
            void var16_20;
            ++var16_20;
            if (nbCellules > tableElement.getEndLine() - tableElement.getFirstLine() + 1) {
                void var16_21;
                ++var16_21;
            }
        } else if (r > tableElement.getEndLine() - tableElement.getFirstLine() + 1) {
            var16_22 += 2;
        } else {
            void var16_23;
            ++var16_23;
        }
        return (int)var16_24;
    }

    private int fillTableLine(Sheet sheet, Map<String, Map<Integer, String>> mapStyle, boolean test, SQLRow rowLanguage, OOXMLTableElement tableElement, int currentLine, List<Element> listElts, int numeroRef, SQLRowAccessor rowElt, Map<String, Integer> mapNbCel, String styleName, Map<Element, Object> mapValues) {
        Map<Integer, String> mapLineStyle;
        int nbCellule = 1;
        int tableLine = 1;
        if (styleName != null && styleName.trim().length() > 0 && mapStyle != null && mapStyle.containsKey(styleName) && (mapLineStyle = mapStyle.get(styleName)) != null) {
            for (Integer col : mapLineStyle.keySet()) {
                if (test || !sheet.isCellValid(col.intValue(), currentLine - 1)) continue;
                sheet.getCellAt(col.intValue(), currentLine - 1).setStyleName(mapLineStyle.get(col));
            }
        }
        for (Element e : listElts) {
            block21: {
                OOXMLTableField tableField = new OOXMLTableField(e, rowElt, tableElement.getSQLElement(), rowElt.getID(), tableElement.getTypeStyleWhere() ? -1 : tableElement.getFilterId(), rowLanguage, numeroRef, this.rowRefCache);
                nbCellule = mapNbCel.get(e.getAttributeValue("location").trim()) != null ? mapNbCel.get(e.getAttributeValue("location").trim()) : 1;
                int line = tableField.getLine();
                if (tableField.getLine() > 1) {
                    line = Math.max(nbCellule + (tableLine == tableField.getLine() ? 0 : 1), tableField.getLine());
                }
                tableLine = tableField.getLine();
                String loc = String.valueOf(e.getAttributeValue("location").trim()) + (currentLine + (line - 1));
                List<String> listBlankStyle = tableField.getBlankStyle();
                if (styleName == null || !listBlankStyle.contains(styleName)) {
                    try {
                        Object value = mapValues.get(e);
                        if (value == null) {
                            value = tableField.getValue();
                            mapValues.put(e, value);
                        }
                        if (tableField.isNeeding2Lines() && tableField.getLine() == 1) {
                            loc = String.valueOf(e.getAttributeValue("location").trim()) + (currentLine + 1);
                            styleName = null;
                        }
                        Point resolveHint = sheet.resolveHint(loc);
                        if (test || sheet.isCellValid(resolveHint.x, resolveHint.y)) {
                            int tmpCelluleAffect;
                            String styleNameTmp = styleName;
                            if (tableField.getStyle().trim().length() > 0) {
                                styleNameTmp = tableField.getStyle();
                            }
                            Map<Integer, String> mTmp = styleName == null ? null : mapStyle.get(styleNameTmp);
                            String styleOO = null;
                            if (mTmp != null) {
                                String oTmp = mTmp.get(resolveHint.x);
                                String string = styleOO = oTmp == null ? null : oTmp.toString();
                            }
                            if (tableField.isLineOption() && value != null && value.toString().trim().length() == 0) {
                                value = null;
                                styleOO = null;
                            }
                            if (tableField.isImage()) {
                                OOXMLTableImage tableImage = this.rowRefCache.getOOXMLTableImage(tableField, e, rowElt);
                                tmpCelluleAffect = 1;
                                try {
                                    if (tableImage.getImgBytes() != null) {
                                        MutableCell cell = sheet.getCellAt(test ? "A1" : loc);
                                        if (!test) {
                                            ODFrame frame = cell.addFrame((Number)Float.valueOf(tableImage.getX()), (Number)Float.valueOf(tableImage.getY()), (Number)Float.valueOf(tableImage.getWidth()), (Number)Float.valueOf(tableImage.getHeight()), LengthUnit.MM);
                                            frame.addImage(UUID.randomUUID() + ".png", (BytesProducer)new BytesProducer.ByteArrayProducer(tableImage.getImgBytes(), false));
                                        }
                                        tmpCelluleAffect = tableImage.getRowCount();
                                    }
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                            } else {
                                tmpCelluleAffect = this.fill(test ? "A1" : loc, value, sheet, tableField.isTypeReplace(), null, styleOO, test, tableField.isMultilineAuto(), tableField.isKeepingEmptyLines());
                            }
                            if (tableField.getLine() != 1 && (!tableField.isLineOption() || value != null && value.toString().trim().length() > 0)) {
                                tmpCelluleAffect = nbCellule >= tableField.getLine() ? (tmpCelluleAffect += nbCellule) : (tmpCelluleAffect += tableField.getLine() - 1);
                            }
                            nbCellule = tableField.isNeeding2Lines() ? Math.max(nbCellule, 2) : Math.max(nbCellule, tmpCelluleAffect);
                            break block21;
                        }
                        System.err.println("Cell not valid at " + loc);
                    }
                    catch (IndexOutOfBoundsException indexOut) {
                        System.err.println("Cell not valid at " + loc);
                    }
                }
            }
            mapNbCel.put(e.getAttributeValue("location").trim(), nbCellule);
        }
        return nbCellule;
    }

    private void fillTaxeDocumentMap(Element tableau, Sheet sheet, Map<String, Map<Integer, String>> mapStyle, boolean test) {
        int line = Integer.parseInt(tableau.getAttributeValue("firstLine"));
        List<Element> listElts = tableau.getChildren("element");
        for (SQLRowAccessor rowTaxe : this.taxe.keySet()) {
            Map<String, Object> m = this.taxe.get(rowTaxe);
            for (Element e : listElts) {
                String loc = String.valueOf(e.getAttributeValue("location").trim()) + line;
                String name = e.getAttributeValue("name");
                String typeComp = e.getAttributeValue("type");
                if (name == null) {
                    System.err.println("OOgenerationXML.fillTaxe() --> name == null");
                    continue;
                }
                Object value = m.get(name);
                if (name.equalsIgnoreCase("MONTANT_HT")) {
                    value = (BigDecimal)m.get("MONTANT_HT");
                } else if (name.equalsIgnoreCase("MONTANT_TVA")) {
                    value = (BigDecimal)m.get("MONTANT_TVA");
                } else if (name.equalsIgnoreCase("NOM")) {
                    String suffix;
                    value = TaxeCache.getCache().getRowFromId(rowTaxe.getID()).getString("NOM");
                    String prefix = e.getAttributeValue("prefix");
                    if (prefix != null) {
                        value = String.valueOf(prefix) + value;
                    }
                    if ((suffix = e.getAttributeValue("suffix")) != null) {
                        value = String.valueOf(value) + suffix;
                    }
                }
                this.fill(test ? "A1" : loc, value, sheet, false, null, null, test, false, false);
            }
            ++line;
        }
    }

    private void parseElementsXML(List<Element> elts, SQLRow row, SpreadSheet spreadSheet) {
        SQLElement sqlElt = Configuration.getInstance().getDirectory().getElement(row.getTable());
        for (Element elt : elts) {
            int sheet;
            OOXMLElement OOElt = new OOXMLElement(elt, sqlElt, row.getID(), row, null, this.rowRefCache);
            Object result = OOElt.getValue();
            if (result == null) continue;
            String o = elt.getAttributeValue("sheet");
            int n = sheet = o == null ? 0 : Integer.valueOf(o.toString().trim());
            if (OOElt.isImage()) {
                OOXMLTableImage tableImage = new OOXMLTableImage(OOElt, elt, row);
                try {
                    if (tableImage.getImgBytes() == null) continue;
                    MutableCell cell = spreadSheet.getSheet(sheet).getCellAt(elt.getAttributeValue("location"));
                    ODFrame frame = cell.addFrame((Number)Float.valueOf(tableImage.getX()), (Number)Float.valueOf(tableImage.getY()), (Number)Float.valueOf(tableImage.getWidth()), (Number)Float.valueOf(tableImage.getHeight()), LengthUnit.MM);
                    frame.addImage(UUID.randomUUID() + ".png", (BytesProducer)new BytesProducer.ByteArrayProducer(tableImage.getImgBytes(), false));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                continue;
            }
            this.fill(elt.getAttributeValue("location"), result, spreadSheet.getSheet(sheet), OOElt.isTypeReplace(), OOElt.getReplacePattern(), null, false, OOElt.isMultilineAuto(), OOElt.isKeepingEmptyLines());
        }
    }

    private static boolean isIncluded(int filterID, String foreignTable, int id, String fieldWhere, SQLRowAccessor rowElt) {
        if (rowElt.getTable().getName().equals("FICHE_PAYE_ELEMENT")) {
            if (!rowElt.getBoolean("IMPRESSION").booleanValue()) {
                return false;
            }
            if (!rowElt.getBoolean("IN_PERIODE").booleanValue()) {
                return false;
            }
        }
        if (fieldWhere != null && fieldWhere.trim().length() > 0 && rowElt.getTable().contains(fieldWhere) && rowElt.getTable().getField(fieldWhere).getType().getJavaType() == Boolean.class) {
            return rowElt.getBoolean(fieldWhere);
        }
        if (filterID <= 1) {
            return true;
        }
        if (foreignTable != null) {
            boolean b = false;
            SQLTable table = Configuration.getInstance().getRoot().findTable(foreignTable);
            Collection<? extends SQLRowAccessor> set = rowElt.getReferentRows(table);
            for (SQLRowAccessor sQLRowAccessor : set) {
                boolean bl = b = b || sQLRowAccessor.getInt(fieldWhere) == filterID;
            }
            return b;
        }
        return filterID == id;
    }

    private int fill(String location, Object value, Sheet sheet, boolean replace, String replacePattern, String styleOO, boolean test, boolean controleMultiline, boolean keepEmptyLines) {
        int nbCellule;
        int n = nbCellule = test && styleOO == null ? 2 : 1;
        if (test || sheet.isCellValid(sheet.resolveHint((String)location).x, sheet.resolveHint((String)location).y)) {
            MutableCell cell = sheet.getCellAt(location);
            if (controleMultiline && value != null && value.toString().indexOf(10) >= 0) {
                String[] values = value.toString().split("\n");
                Point p = sheet.resolveHint(location);
                int y = 0;
                String[] stringArray = values;
                int n2 = values.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string = stringArray[n3];
                    if (string != null && (keepEmptyLines || string.trim().length() != 0)) {
                        try {
                            if (!test) {
                                MutableCell c = sheet.getCellAt(p.x, p.y + y);
                                this.setCellValue(c, string, replace, replacePattern);
                                if (styleOO != null) {
                                    c.setStyleName(styleOO);
                                }
                            }
                            ++y;
                        }
                        catch (IllegalArgumentException e) {
                            ExceptionHandler.handle("La cellule " + location + " n'existe pas ou est fusionn\u00e9e.", e);
                        }
                    }
                    ++n3;
                }
                nbCellule = y;
            } else {
                nbCellule = 1;
                if (!test) {
                    this.setCellValue(cell, value, replace, replacePattern);
                    if (styleOO != null) {
                        cell.setStyleName(styleOO);
                    }
                }
            }
        }
        return nbCellule;
    }

    private void setCellValue(MutableCell cell, Object value, boolean replace, String replacePattern) {
        if (value == null) {
            return;
        }
        if (replace) {
            if (replacePattern != null) {
                cell.replaceBy(replacePattern, value.toString());
            } else {
                cell.replaceBy("_", value.toString());
            }
        } else {
            cell.setValue(value);
        }
    }

    private static File saveSpreadSheet(SpreadSheet ssheet, File pathDest, String fileName, String templateId, SQLRow rowLanguage) throws IOException {
        Serializable file;
        String langage;
        String string = langage = rowLanguage != null ? rowLanguage.getString("CHEMIN") : null;
        if (ssheet == null || pathDest == null || fileName.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        File fDest = new File(pathDest, String.valueOf(fileName) + ".ods");
        if (!pathDest.exists()) {
            pathDest.mkdirs();
        }
        fDest = SheetUtils.convertToOldFile(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete(), fileName, pathDest, fDest);
        try {
            ssheet.saveAs(fDest);
        }
        catch (FileNotFoundException e) {
            file = fDest;
            SwingUtilities.invokeLater(new Runnable((File)file){
                private final /* synthetic */ File val$file;
                {
                    this.val$file = file;
                }

                @Override
                public void run() {
                    try {
                        JOptionPane.showMessageDialog(null, "Le fichier " + this.val$file.getCanonicalPath() + " n'a pu \u00eatre cr\u00e9\u00e9. \n V\u00e9rifiez qu'il n'est pas d\u00e9j\u00e0 ouvert.");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            e.printStackTrace();
        }
        File odspOut = new File(pathDest, String.valueOf(fileName) + ".odsp");
        try {
            file = null;
            Object var9_12 = null;
            try (InputStream odspIn = TemplateManager.getInstance().getTemplatePrintConfiguration(templateId, langage, null);){
                if (odspIn != null) {
                    StreamUtils.copy(odspIn, odspOut);
                }
            }
            catch (Throwable throwable) {
                if (file == null) {
                    file = throwable;
                } else if (file != throwable) {
                    ((Throwable)file).addSuppressed(throwable);
                }
                throw file;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("OOgenerationXML.saveSpreadSheet() : Le fichier odsp n'existe pas.");
        }
        return fDest;
    }

    private Map<String, Map<Integer, String>> searchStyle(Sheet sheet, int colEnd, int rowEnd) {
        if (this.cacheStyle.get(sheet) != null) {
            return this.cacheStyle.get(sheet);
        }
        Map<String, Map<Integer, String>> mapStyleDef = StyleSQLElement.getMapAllStyle();
        int columnCount = colEnd == -1 ? sheet.getColumnCount() : colEnd + 1;
        System.err.println("End column search : " + columnCount);
        int rowCount = rowEnd > 0 ? rowEnd : sheet.getRowCount();
        System.err.println("End row search : " + rowCount);
        int i = 0;
        while (i < rowCount) {
            int x = 0;
            HashMap<Integer, String> mapCellStyle = new HashMap<Integer, String>();
            String style = "";
            int j = 0;
            while (j < columnCount) {
                block11: {
                    try {
                        if (!sheet.isCellValid(j, i)) break block11;
                        MutableCell c = sheet.getCellAt(j, i);
                        String cellStyle = c.getStyleName();
                        try {
                            if (mapStyleDef.containsKey(c.getValue().toString())) {
                                style = c.getValue().toString();
                            }
                        }
                        catch (IllegalStateException e) {
                            e.printStackTrace();
                        }
                        mapCellStyle.put(x, cellStyle);
                        if (style.trim().length() != 0) {
                            String styleCell;
                            c.clearValue();
                            if (!style.trim().equalsIgnoreCase("Normal") && mapStyleDef.get("Normal") != null && (styleCell = mapStyleDef.get("Normal").get(x)) != null && styleCell.length() != 0) {
                                c.setStyleName(styleCell);
                            }
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.err.println("Index out of bounds Exception");
                    }
                }
                ++x;
                ++j;
            }
            if (style.length() > 0) {
                mapStyleDef.put(style, mapCellStyle);
            }
            ++i;
        }
        this.cacheStyle.put(sheet, mapStyleDef);
        return mapStyleDef;
    }

    public boolean needAnnexe(String templateId, String typeTemplate, SQLRow row, SQLRow rowLanguage) {
        Map<String, Map<Integer, String>> mapStyle;
        int nbPage;
        List<Element> listTable;
        SpreadSheet spreadSheet;
        block4: {
            String langage = rowLanguage != null ? rowLanguage.getString("CHEMIN") : null;
            SAXBuilder builder = new SAXBuilder();
            try {
                InputStream xmlConfiguration = TemplateManager.getInstance().getTemplateConfiguration(templateId, langage, typeTemplate);
                Document doc = builder.build(xmlConfiguration);
                xmlConfiguration.close();
                InputStream template = TemplateManager.getInstance().getTemplate(templateId, langage, typeTemplate);
                spreadSheet = new ODPackage(template).getSpreadSheet();
                template.close();
                Element racine = doc.getRootElement();
                listTable = racine.getChildren("table");
                if (!listTable.isEmpty()) break block4;
                return false;
            }
            catch (Throwable e) {
                Log.get().severe(e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
        Element tableau = listTable.get(0).getAttributeValue("table").equalsIgnoreCase("TVA") ? listTable.get(1) : listTable.get(0);
        Sheet sheet = spreadSheet.getSheet(0);
        String oLastColTmp = tableau.getAttributeValue("lastColumn");
        int lastColumn = -1;
        int endPageLine = Integer.parseInt(tableau.getAttributeValue("endPageLine"));
        if (oLastColTmp != null) {
            lastColumn = sheet.resolveHint((String)new StringBuilder((String)String.valueOf((Object)oLastColTmp.toString())).append((int)1).toString()).x + 1;
        }
        return (nbPage = this.fillTable(tableau, row, sheet, mapStyle = this.searchStyle(sheet, lastColumn, endPageLine), true, rowLanguage)) > 1;
    }

    protected String getStringProposition(SQLRow rowProp) {
        return "Notre proposition " + rowProp.getString("NUMERO") + " du " + this.dateFormat.format(rowProp.getObject("DATE"));
    }

    public static void main(String[] args) {
        ComptaPropsConfiguration conf = ComptaPropsConfiguration.create();
        System.err.println("Conf created");
        Configuration.setInstance(conf);
        conf.setUpSocieteDataBaseConnexion(36);
        System.err.println("Connection Set up");
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("DEVIS");
        System.err.println("Start Genere");
        System.err.println("Stop genere");
    }
}

