/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.action;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.ui.table.TableCellRendererDecorator;
import org.openconcerto.ui.table.TableCellRendererUtils;

public class ProductObsoleteRenderer
extends TableCellRendererDecorator {
    public static final ProductObsoleteUtils<ProductObsoleteRenderer> UTILS = new ProductObsoleteUtils<ProductObsoleteRenderer>(ProductObsoleteRenderer.class);

    public ProductObsoleteRenderer(TableCellRenderer r) {
        super(r);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        SQLRowValues ecritureRow;
        Component res = this.getRenderer(table, column).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableCellRendererUtils.setBackgroundColor(res, table, isSelected);
        if (!isSelected && (ecritureRow = ITableModel.getLine(table.getModel(), row).getRow()).getBoolean("OBSOLETE").booleanValue()) {
            res.setBackground(Color.red);
        }
        return res;
    }

    public static final class ProductObsoleteUtils<R extends ProductObsoleteRenderer>
    extends TableCellRendererDecorator.TableCellRendererDecoratorUtils<R> {
        protected ProductObsoleteUtils(Class<R> clazz) {
            super(clazz);
        }

        @Override
        protected boolean replaces(TableCellRenderer r) {
            return ProductObsoleteRenderer.class.isAssignableFrom(r.getClass());
        }
    }
}

