/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import org.openconcerto.erp.core.common.ui.NumericTextField;
import org.openconcerto.erp.core.sales.pos.ui.CaissePanel;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;

public class NumericKeypadPanel
extends JPanel {
    private NumericTextField numericTextField;
    private Map<String, POSButton> buttonMap = new HashMap<String, POSButton>();
    private transient NumericKeyListener evt = new NumericKeyListener();
    private int maxDecimalDigits;
    private static final int INSET = 2;
    private static final int PANEL_HEIGHT = 348;
    private static final int PANEL_WIDTH = 208;
    private static final int BUTTON_SIZE = 64;

    public NumericKeypadPanel() {
        this(null, 2);
    }

    public NumericKeypadPanel(NumericTextField dataSource) {
        this(dataSource, 2);
    }

    public NumericKeypadPanel(NumericTextField dataSource, int maxDecimalDigits) {
        this.setLayout(new GridBagLayout());
        this.drawCalculator();
        this.setNumericTextField(dataSource);
        this.setMaxDecimalDigits(maxDecimalDigits);
    }

    public final int getMaxDecimalDigits() {
        return this.maxDecimalDigits;
    }

    public final void setMaxDecimalDigits(int maxDecimalDigits) {
        this.maxDecimalDigits = maxDecimalDigits;
        this.updateButtonsValidity();
    }

    public final NumericTextField getNumericTextField() {
        return this.numericTextField;
    }

    public final void setNumericTextField(NumericTextField dataSource) {
        if (dataSource != null) {
            this.numericTextField = dataSource;
            BigDecimal value = dataSource.getValue();
            if (value == null || Math.abs(value.longValue()) <= 0L) {
                this.numericTextField.setText("");
            }
            this.updateButtonsValidity();
        }
    }

    private void drawCalculator() {
        this.setForeground(new Color(250, 250, 250));
        this.addKey("C", 0, 0, 3, 1).setBackground(CaissePanel.LIGHT_BLUE);
        this.addKey("7", 0, 1, 1, 1);
        this.addKey("8", 1, 1, 1, 1);
        this.addKey("9", 2, 1, 1, 1);
        this.addKey("4", 0, 2, 1, 1);
        this.addKey("5", 1, 2, 1, 1);
        this.addKey("6", 2, 2, 1, 1);
        this.addKey("1", 0, 3, 1, 1);
        this.addKey("2", 1, 3, 1, 1);
        this.addKey("3", 2, 3, 1, 1);
        this.addKey("0", 0, 4, 2, 1);
        this.addKey(".", 2, 4, 1, 1);
    }

    private POSButton addKey(String buttonTitle, int col, int row, int colSpawn, int rowSpawn) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = colSpawn;
        c.gridheight = rowSpawn;
        c.gridx = col;
        c.gridy = row;
        c.insets = new Insets(2, 2, 2, 2);
        POSButton button = new POSButton(buttonTitle);
        button.setPreferredSize(new Dimension(64 * colSpawn, 64 * rowSpawn));
        button.addActionListener(this.evt);
        this.buttonMap.put(buttonTitle, button);
        this.add((Component)button, c);
        return button;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(208, 348);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private void updateButtonsValidity() {
        block32: {
            if (this.numericTextField == null) break block32;
            String currentTextValue = this.numericTextField.getText();
            int length = currentTextValue.length();
            int posDecimalSeparator = currentTextValue.indexOf(46);
            boolean hasDecimalSeparator = this.maxDecimalDigits == 0 || posDecimalSeparator >= 0;
            boolean hasEnoughtDecimals = posDecimalSeparator > 0 && posDecimalSeparator < length - this.maxDecimalDigits;
            for (Map.Entry<String, POSButton> entry : this.buttonMap.entrySet()) {
                String k = entry.getKey();
                POSButton button = entry.getValue();
                switch (k) {
                    case "C": {
                        button.setEnabled(length > 0);
                        break;
                    }
                    case ".": {
                        button.setEnabled(!hasDecimalSeparator && !currentTextValue.isEmpty());
                        break;
                    }
                    case "0": 
                    case "1": 
                    case "2": 
                    case "3": 
                    case "4": 
                    case "5": 
                    case "6": 
                    case "7": 
                    case "8": 
                    case "9": {
                        button.setEnabled(!hasEnoughtDecimals);
                        break;
                    }
                }
            }
        }
    }

    private class NumericKeyListener
    implements ActionListener {
        private NumericKeyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String digit = e.getActionCommand();
            String currentTextValue = NumericKeypadPanel.this.numericTextField.getText();
            switch (digit) {
                case "C": {
                    int length = currentTextValue.length();
                    if (length <= 0) break;
                    NumericKeypadPanel.this.numericTextField.setText(currentTextValue.substring(0, length - 1));
                    break;
                }
                case ".": 
                case "0": 
                case "1": 
                case "2": 
                case "3": 
                case "4": 
                case "5": 
                case "6": 
                case "7": 
                case "8": 
                case "9": {
                    NumericKeypadPanel.this.numericTextField.setText(String.valueOf(currentTextValue) + digit);
                    break;
                }
            }
            NumericKeypadPanel.this.updateButtonsValidity();
        }
    }
}

