/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;

public class DOTExporter<V, E> {
    private VertexNameProvider<V> vertexIDProvider;
    private VertexNameProvider<V> vertexLabelProvider;
    private EdgeNameProvider<E> edgeLabelProvider;

    public DOTExporter() {
        this(new IntegerNameProvider(), null, null);
    }

    public DOTExporter(VertexNameProvider<V> vertexIDProvider, VertexNameProvider<V> vertexLabelProvider, EdgeNameProvider<E> edgeLabelProvider) {
        this.vertexIDProvider = vertexIDProvider;
        this.vertexLabelProvider = vertexLabelProvider;
        this.edgeLabelProvider = edgeLabelProvider;
    }

    public void export(Writer writer, Graph<V, E> g) {
        String connector;
        PrintWriter out = new PrintWriter(writer);
        String indent = "  ";
        if (g instanceof DirectedGraph) {
            out.println("digraph G {");
            connector = " -> ";
        } else {
            out.println("graph G {");
            connector = " -- ";
        }
        for (V v : g.vertexSet()) {
            out.print(String.valueOf(indent) + this.vertexIDProvider.getVertexName(v));
            if (this.vertexLabelProvider != null) {
                out.print(" [label = \"" + this.vertexLabelProvider.getVertexName(v) + "\"]");
            }
            out.println(";");
        }
        for (Object e : g.edgeSet()) {
            String source = this.vertexIDProvider.getVertexName(g.getEdgeSource(e));
            String target = this.vertexIDProvider.getVertexName(g.getEdgeTarget(e));
            out.print(String.valueOf(indent) + source + connector + target);
            if (this.edgeLabelProvider != null) {
                out.print(" [label = \"" + this.edgeLabelProvider.getEdgeName(e) + "\"]");
            }
            out.println(";");
        }
        out.println("}");
        out.flush();
    }
}

