/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.Timer;
import org.openconcerto.ui.IMenuWithArrows;

class IWindowWithArrow
extends JWindow
implements MouseListener,
ActionListener {
    IMenuWithArrows menu;
    JList list;
    JViewport viewport;
    Vector items;
    Font font;
    int fontSize = 12;
    JButton up = null;
    JButton down = null;
    int index;
    Timer timer = null;
    int initialDelay = 300;
    int repeatDelay = 50;
    int increment = 0;
    Image image;
    URL resource;

    public IWindowWithArrow(IMenuWithArrows arrowmenu) {
        this.menu = arrowmenu;
        this.items = new Vector();
        this.viewport = new JViewport();
        this.list = new JList();
        this.font = new Font(null, 0, this.fontSize);
        this.list.setFont(this.font);
        this.list.setBackground(new Color(207, 207, 207));
        this.list.setForeground(Color.BLACK);
        this.list.setSelectionBackground(new Color(144, 151, 207));
        this.list.setSelectionForeground(Color.BLACK);
        this.list.addMouseListener(this);
        this.viewport.setView(this.list);
        this.resource = this.getClass().getResource("arrow-up.gif");
        this.up = new JButton(new ImageIcon(this.resource));
        this.up.setBackground(new Color(207, 207, 207));
        this.up.setBorder(null);
        this.up.addMouseListener(this);
        this.resource = this.getClass().getResource("arrow-down.gif");
        this.down = new JButton(new ImageIcon(this.resource));
        this.down.setBackground(new Color(207, 207, 207));
        this.down.setBorder(null);
        this.down.addMouseListener(this);
        Container container = this.getContentPane();
        JPanel jpanel = new JPanel();
        jpanel.setBorder(BorderFactory.createBevelBorder(0));
        jpanel.setLayout(new BorderLayout());
        jpanel.add((Component)this.up, "North");
        jpanel.add((Component)this.viewport, "Center");
        jpanel.add((Component)this.down, "South");
        container.add(jpanel);
        this.timer = new Timer(this.repeatDelay, this);
        this.timer.setInitialDelay(this.initialDelay);
    }

    public void add(JMenuItem jmenuitem) {
        AItem aitem = new AItem(jmenuitem);
        this.items.addElement(aitem);
        this.list.setListData(this.items);
    }

    @Override
    public void setVisible(boolean flag) {
        int i = 0;
        int j = 0;
        FontRenderContext fontrendercontext = new FontRenderContext(null, false, false);
        int k = 0;
        while (k < this.items.size()) {
            float f = (float)this.font.getStringBounds(((AItem)this.items.elementAt((int)k)).label, fontrendercontext).getWidth();
            if (f > (float)i) {
                i = (int)f;
            }
            ++k;
        }
        Point point = this.getLocation();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        j = dimension.height - point.y - 30;
        this.index = 0;
        this.viewport.setViewPosition(this.list.indexToLocation(0));
        this.list.setSelectedIndex(0);
        this.setSize(i, j);
        super.setVisible(flag);
    }

    @Override
    public void mousePressed(MouseEvent mouseevent) {
        this.increment = 0;
        if (mouseevent.getSource() == this.up) {
            if (this.index > 0) {
                this.increment = -1;
                this.timer.start();
            }
        } else if (mouseevent.getSource() == this.down && this.list.getLastVisibleIndex() < this.items.size() - 1) {
            this.increment = 1;
            this.timer.start();
        }
        this.index += this.increment;
        this.viewport.setViewPosition(this.list.indexToLocation(this.index));
    }

    @Override
    public void mouseReleased(MouseEvent mouseevent) {
        if (this.timer != null) {
            this.timer.stop();
        }
        if (mouseevent.getSource() == this.list) {
            ((AItem)this.items.elementAt((int)this.list.getSelectedIndex())).menuItem.doClick();
            this.menu.fireMenuCanceled();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseevent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseevent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseevent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionevent) {
        if (this.increment == 1) {
            if (this.list.getLastVisibleIndex() < this.items.size() - 1) {
                ++this.index;
            }
        } else if (this.increment == -1 && this.index > 0) {
            --this.index;
        }
        this.viewport.setViewPosition(this.list.indexToLocation(this.index));
    }

    class AItem {
        JMenuItem menuItem;
        String label;

        public AItem(JMenuItem jmenuitem) {
            this.menuItem = jmenuitem;
            this.label = jmenuitem.getText();
        }

        public String toString() {
            return this.label;
        }
    }
}

