/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInsert;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.User;

public class Journal {
    private final Long id;
    private final String code;
    private final String nom;

    public Journal(Long id, String code, String nom) {
        this.id = id;
        this.code = code;
        this.nom = nom;
    }

    public Long getId() {
        return this.id;
    }

    public String getNom() {
        return this.nom;
    }

    public String getCode() {
        return this.code;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ((Journal)obj).code.equalsIgnoreCase(this.code);
    }

    SQLInsert createInsert(DBRoot root, User user) {
        SQLInsert insert = new SQLInsert();
        SQLTable table = root.getTable("JOURNAL");
        insert.add(table.getField("CODE"), this.code);
        insert.add(table.getField("NOM"), this.nom);
        insert.addCreationTrackedField(user, table);
        return insert;
    }

    public String toString() {
        return "Journal code:" + this.code + " " + this.nom + " (id:" + this.id + ")";
    }
}

