/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import com.ibm.icu.util.Calendar;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.finance.accounting.ui.SaisieJournalItemTable;
import org.openconcerto.erp.utils.TM;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.ISpinnerIntegerModel;
import org.openconcerto.ui.coreanimation.Animator;
import org.openconcerto.utils.cc.ITransformer;

public class SaisieJournalPanel
extends JPanel {
    final SQLRequestComboBox boxMois = new SQLRequestComboBox();
    final SQLRequestComboBox boxJournal = new SQLRequestComboBox();
    final Calendar cal = Calendar.getInstance();
    final JSpinner spin = new JSpinner(new ISpinnerIntegerModel(2000, this.cal.get(1) + 3, this.cal.get(1)));

    public SaisieJournalPanel(final SQLElement ecrElt) {
        super(new GridBagLayout());
        this.boxMois.uiInit(ecrElt.getDirectory().getElement("MOIS").createComboRequest());
        this.boxJournal.uiInit(ecrElt.getDirectory().getElement("JOURNAL").createComboRequest());
        this.animate();
        final IListe listeEcr = new IListe(ecrElt.createTableSource());
        listeEcr.getSource().getReq().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                input.setWhere(Where.FALSE);
                return input;
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 2L) != 0L) {
                    if (SaisieJournalPanel.this.isDisplayable()) {
                        listeEcr.addIListeActions(ecrElt.getRowActions());
                    } else {
                        listeEcr.removeIListeActions(ecrElt.getRowActions());
                    }
                }
            }
        });
        DefaultGridBagConstraints cListe = new DefaultGridBagConstraints();
        cListe.fill = 1;
        cListe.gridwidth = 1;
        cListe.weightx = 1.0;
        cListe.weighty = 1.0;
        JPanel panelEcr = new JPanel(new GridBagLayout());
        panelEcr.add((Component)listeEcr, cListe);
        cListe.weighty = 0.0;
        cListe.weightx = 0.0;
        cListe.gridy = 4;
        cListe.gridx = 0;
        cListe.fill = 0;
        cListe.anchor = 13;
        ArrayList<SQLField> lFields = new ArrayList<SQLField>();
        lFields.add(ecrElt.getTable().getField("DEBIT"));
        lFields.add(ecrElt.getTable().getField("CREDIT"));
        IListTotalPanel comp2 = new IListTotalPanel(listeEcr, lFields);
        panelEcr.add((Component)comp2, cListe);
        final PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int wantedID = SaisieJournalPanel.this.boxMois.getWantedID();
                int journalID = SaisieJournalPanel.this.boxJournal.getSelectedId();
                Integer year = (Integer)SaisieJournalPanel.this.spin.getValue();
                SaisieJournalPanel.this.setFilter(listeEcr, wantedID, journalID, year);
                SaisieJournalPanel.this.animate();
            }
        };
        this.boxMois.addModelListener("wantedID", l);
        this.boxJournal.addModelListener("wantedID", l);
        this.spin.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                l.propertyChange(null);
            }
        });
        JPanel headerPanel = new JPanel(new FlowLayout(1, 6, 4));
        headerPanel.add(new JLabel("Journal"));
        headerPanel.add(this.boxJournal);
        headerPanel.add(new JLabel("Mois"));
        headerPanel.add(this.boxMois);
        headerPanel.add(new JLabel("Ann\u00e9e"));
        headerPanel.add(this.spin);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 1;
        this.add((Component)headerPanel, c);
        JSplitPane split = new JSplitPane(0);
        c.gridwidth = 0;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        split.setTopComponent(panelEcr);
        final SQLRowValues defaultRowVals = new SQLRowValues(ecrElt.getTable().getTable("SAISIE_KM_ELEMENT"));
        defaultRowVals.put("DEBIT", 0L);
        defaultRowVals.put("CREDIT", 0L);
        final JCheckBox boxAutoInsert = new JCheckBox("Insertion automatique");
        JPanel panelBottom = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cB = new DefaultGridBagConstraints();
        panelBottom.add((Component)new JLabel(TM.tr("accounting.editing.piece.label", new Object[0])), cB);
        ++cB.gridx;
        final JTextField textPiece = new JTextField();
        panelBottom.add((Component)textPiece, cB);
        final SaisieJournalItemTable table = new SaisieJournalItemTable(defaultRowVals, boxAutoInsert, textPiece);
        table.setPanel(this);
        cB.gridwidth = 0;
        cB.weightx = 1.0;
        cB.weighty = 1.0;
        cB.fill = 1;
        ++cB.gridy;
        cB.gridx = 0;
        panelBottom.add((Component)table, cB);
        split.setBottomComponent(panelBottom);
        this.add((Component)split, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel footerPanel = new JPanel(new FlowLayout(2, 6, 4));
        boxAutoInsert.setSelected(true);
        footerPanel.add(boxAutoInsert);
        final JButton buttonAdd = new JButton("Ajouter");
        buttonAdd.setEnabled(false);
        buttonAdd.setVisible(false);
        boxAutoInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                buttonAdd.setVisible(!boxAutoInsert.isSelected());
                buttonAdd.setEnabled(!boxAutoInsert.isSelected() && table.isSaisieValid());
            }
        });
        footerPanel.add(buttonAdd);
        final JButton buttonClose = new JButton("Fermer");
        footerPanel.add(buttonClose);
        c.gridwidth = 0;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.add((Component)footerPanel, c);
        buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.createSaisie(defaultRowVals, textPiece);
            }
        });
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Window)SwingUtilities.getRoot(buttonClose)).dispose();
            }
        });
        table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                buttonAdd.setEnabled(!boxAutoInsert.isSelected() && table.isSaisieValid());
            }
        });
    }

    public SQLRequestComboBox getBoxMois() {
        return this.boxMois;
    }

    public SQLRequestComboBox getBoxJournal() {
        return this.boxJournal;
    }

    private void animate() {
        Animator.getInstance().animate(this.boxJournal, this.boxJournal.isEmpty());
        Animator.getInstance().animate(this.boxMois, this.boxMois.isEmpty());
    }

    public int getSelectedYear() {
        return (Integer)this.spin.getValue();
    }

    public int getSelectedMonth() {
        return this.boxMois.getSelectedId() - 2;
    }

    public int getSelectedJournal() {
        return this.boxJournal.getSelectedId();
    }

    public void setFilter(IListe listeEcr, final int wantedID, final int journalID, final Integer year) {
        if (wantedID != -1 && wantedID >= 0 && journalID > 1) {
            listeEcr.getSource().getReq().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    Calendar c = Calendar.getInstance();
                    c.set(1, year);
                    c.set(2, wantedID - 2);
                    c.set(5, 1);
                    c.set(10, 0);
                    c.set(12, 0);
                    Date d1 = c.getTime();
                    c.set(5, c.getActualMaximum(5));
                    c.set(10, 23);
                    c.set(12, 59);
                    Date d2 = c.getTime();
                    input.setWhere(new Where((FieldRef)input.getTable("ECRITURE").getField("ID_JOURNAL"), "=", journalID).and(new Where((FieldRef)input.getTable("ECRITURE").getField("DATE"), d1, (Object)d2)));
                    return input;
                }
            });
        } else {
            listeEcr.getSource().getReq().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    input.setWhere(Where.FALSE);
                    return input;
                }
            });
        }
    }
}

