/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.openconcerto.erp.config.ServerFinderPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.NetUtils;

public class CloudPanel
extends JPanel {
    private static final String CLOUD_URL = "https://cloud.openconcerto.org";

    CloudPanel(ServerFinderPanel serverFinderPanel) {
        if (CLOUD_URL.contains("127.0.0.1")) {
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.uiInit(serverFinderPanel);
    }

    private void uiInit(final ServerFinderPanel serverFinderPanel) {
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        final String token = serverFinderPanel.getToken();
        if (token == null) {
            c.gridwidth = 2;
            this.add((Component)new JLabel("Connexion de ce poste au cloud "), c);
            c.gridwidth = 1;
            c.gridx = 0;
            ++c.gridy;
            JLabel labelEmail = new JLabel("Email", 4);
            this.add((Component)labelEmail, c);
            ++c.gridx;
            c.weightx = 1.0;
            final JTextField textEmail = new JTextField();
            this.add((Component)textEmail, c);
            c.weightx = 0.0;
            c.gridx = 0;
            ++c.gridy;
            JLabel labelPassword = new JLabel("Mot de passe", 4);
            this.add((Component)labelPassword, c);
            final JPasswordField textPassword = new JPasswordField();
            ++c.gridx;
            this.add((Component)textPassword, c);
            ++c.gridy;
            c.fill = 0;
            JButton connect = new JButton("Se connecter au cloud");
            connect.setOpaque(false);
            this.add((Component)connect, c);
            connect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String result = NetUtils.getHTTPContent("https://cloud.openconcerto.org/getAuthToken?email=" + textEmail.getText() + "&password=" + new String(textPassword.getPassword()), false);
                    if (result != null && !result.contains("ERROR")) {
                        JOptionPane.showMessageDialog(CloudPanel.this, "Connexion activ\u00e9e");
                        serverFinderPanel.setToken(result);
                        serverFinderPanel.saveConfigFile();
                        CloudPanel.this.invalidate();
                        CloudPanel.this.removeAll();
                        CloudPanel.this.uiInit(serverFinderPanel);
                        CloudPanel.this.revalidate();
                        CloudPanel.this.repaint();
                    } else if (result != null && result.contains("not paid")) {
                        JOptionPane.showMessageDialog(CloudPanel.this, "Compte non cr\u00e9dit\u00e9");
                    } else if (result == null || result.isEmpty()) {
                        JOptionPane.showMessageDialog(CloudPanel.this, "Pas de r\u00e9ponse du serveur d'authentification.");
                    } else {
                        JOptionPane.showMessageDialog(CloudPanel.this, "Email ou identifiant incorrect");
                    }
                }
            });
        } else {
            c.weightx = 1.0;
            this.add((Component)new JLabelBold("Ce poste est configur\u00e9 pour utiliser le cloud"), c);
            ++c.gridy;
            this.add((Component)new JLabel("Id de connexion:" + token.substring(0, 16)), c);
            ++c.gridy;
            c.fill = 0;
            JButton buttonTest = new JButton("Tester la connexion");
            buttonTest.setOpaque(false);
            ++c.gridy;
            this.add((Component)buttonTest, c);
            buttonTest.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String result = NetUtils.getHTTPContent("https://cloud.openconcerto.org/getAuthInfo?token=" + token, false);
                    if (result != null && !result.contains("ERROR")) {
                        JOptionPane.showMessageDialog(CloudPanel.this, "Connexion op\u00e9rationnelle");
                    } else if (result != null && result.contains("not paid")) {
                        JOptionPane.showMessageDialog(CloudPanel.this, "Compte non cr\u00e9dit\u00e9");
                    } else {
                        JOptionPane.showMessageDialog(CloudPanel.this, "Connexion impossible");
                    }
                }
            });
            ++c.gridy;
            this.add((Component)new JLabel(" "), c);
            ++c.gridy;
            this.add((Component)new JLabel("D\u00e9sactivation de l'acc\u00e8s au cloud pour ce poste"), c);
            ++c.gridy;
            JButton buttonRevoke = new JButton("D\u00e9sactiver la connexion au cloud");
            buttonRevoke.setOpaque(false);
            this.add((Component)buttonRevoke, c);
            buttonRevoke.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int res = JOptionPane.showConfirmDialog(CloudPanel.this, "Souhaitez vous effacer la configuration de connexion au cloud pour ce poste?");
                    if (res == 0) {
                        serverFinderPanel.setToken(null);
                        serverFinderPanel.saveConfigFile();
                        CloudPanel.this.invalidate();
                        CloudPanel.this.removeAll();
                        CloudPanel.this.uiInit(serverFinderPanel);
                        CloudPanel.this.revalidate();
                        CloudPanel.this.repaint();
                    }
                }
            });
        }
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        this.add((Component)spacer, c);
    }
}

