/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.io.JSONAble;
import org.openconcerto.utils.io.JSONConverter;

public class RowSelectionSpec
implements Externalizable,
JSONAble {
    private String tableId;
    private List<Number> ids;

    public RowSelectionSpec() {
    }

    public RowSelectionSpec(JSONObject json) {
        this.fromJSON(json);
    }

    public RowSelectionSpec(String tableId) {
        this(tableId, new ArrayList<Number>(0));
    }

    public RowSelectionSpec(String tableId, List<Number> selectedIds) {
        this.tableId = tableId;
        this.ids = new ArrayList<Number>(selectedIds);
        this.ids.addAll(selectedIds);
    }

    public final List<Number> getIds() {
        return this.ids;
    }

    public final void setIds(List<Number> ids) {
        this.ids.clear();
        this.ids.addAll(ids);
    }

    public void clear() {
        this.ids.clear();
    }

    public String getTableId() {
        return this.tableId;
    }

    public boolean hasSelectedId() {
        return !this.getIds().isEmpty();
    }

    public String toString() {
        StringBuilder r = new StringBuilder("RowSelectionSpec: ").append(this.tableId).append(" : ");
        int idsSize = this.ids.size();
        int i = 0;
        while (i < idsSize) {
            if (i < idsSize - 1) {
                r.append(this.ids.get(i)).append(", ");
            } else {
                r.append(this.ids.get(i));
            }
            ++i;
        }
        return r.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            out.writeUTF(this.tableId);
            out.writeObject(this.ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tableId = in.readUTF();
        this.ids = CollectionUtils.castList((List)in.readObject(), Number.class);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("class", "RowSelectionSpec");
        json.put("table-id", this.tableId);
        json.put("ids", this.ids);
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        this.tableId = JSONConverter.getParameterFromJSON(json, "table-id", String.class);
        JSONArray jsonIds = JSONConverter.getParameterFromJSON(json, "ids", JSONArray.class);
        this.ids = new ArrayList<Number>(jsonIds.size());
        for (Object jsonId : jsonIds) {
            this.ids.add(JSONConverter.getObjectFromJSON(jsonId, Number.class));
        }
    }

    public void setTableId(String id) {
        this.tableId = id;
    }
}

