/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.changer.Change;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.utils.CollectionUtils;

public abstract class ChangeBase {
    private final DBRoot root;

    public ChangeBase(DBRoot r) {
        this.root = r;
    }

    public ChangeBase() throws IOException {
        this(new PropsConfiguration(new File("changeBase.properties"), Change.props).getRoot());
    }

    protected final SQLSyntax getSyntax() {
        return SQLSyntax.get(this.getRoot());
    }

    protected final void call(String converter) {
        this.call(converter, new String[0]);
    }

    protected final void call(String[] nameNparams) {
        String[] params = new String[nameNparams.length - 1];
        System.arraycopy(nameNparams, 1, params, 0, params.length);
        this.call(nameNparams[0], params);
    }

    protected final void call(String converter, String[] params) {
        Class<? extends Changer> c;
        Class<? extends Changer> clazz = c = this.getChange() == null ? null : this.getChange().findClass(converter);
        if (c != null) {
            try {
                this.getChange().exec(this.getRoot(), c, params);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Object[] types = new Class[params.length];
                Arrays.fill(types, String.class);
                this.call(this.getClass().getMethod(converter, (Class<?>[])types), (Object[])params);
            }
            catch (NoSuchMethodException exn) {
                String copies = CollectionUtils.join(Collections.nCopies(params.length, "String"), ", ");
                System.err.println("Le convertisseur '" + converter + "(" + copies + ")' n'existe pas.");
            }
        }
    }

    protected abstract Change getChange();

    private void call(Method converter, Object[] params) {
        try {
            converter.invoke((Object)this, params);
        }
        catch (Exception exn) {
            exn.printStackTrace();
        }
    }

    protected final SQLBase getBase() {
        return this.getRoot().getBase();
    }

    protected final DBRoot getRoot() {
        return this.root;
    }
}

