/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.UserInitialsValueProvider;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.utils.DecimalUtils;

public class PrixUnitaireRemiseProvider
extends UserInitialsValueProvider {
    public static int UNITAIRE_REMISE = 0;
    public static int TOTAL_NON_ACOMPTE = 1;
    public final int type;

    public PrixUnitaireRemiseProvider(int t) {
        this.type = t;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        if (this.type == UNITAIRE_REMISE) {
            return this.getPrixUnitaire(row);
        }
        return this.getPrixTotalOrigin(row);
    }

    public Object getPrixTotalOrigin(SQLRowAccessor row) {
        BigDecimal pv = row.getBigDecimal("PV_HT");
        BigDecimal remise = (BigDecimal)row.getObject("POURCENT_REMISE");
        if (remise == null) {
            remise = BigDecimal.ZERO;
        }
        BigDecimal acompte = BigDecimal.ONE;
        BigDecimal result = BigDecimal.ONE.subtract(remise.movePointLeft(2)).multiply(pv, DecimalUtils.HIGH_PRECISION).multiply(acompte, DecimalUtils.HIGH_PRECISION);
        return result.multiply(row.getBigDecimal("QTE_UNITAIRE")).multiply(new BigDecimal(row.getInt("QTE"))).setScale(2, RoundingMode.HALF_UP);
    }

    public Object getPrixUnitaire(SQLRowAccessor row) {
        BigDecimal pv = row.getBigDecimal("PV_HT");
        BigDecimal remise = (BigDecimal)row.getObject("POURCENT_REMISE");
        if (remise == null) {
            remise = BigDecimal.ZERO;
        }
        BigDecimal acompte = BigDecimal.ONE;
        if (row.getTable().contains("POURCENT_ACOMPTE") && row.getObject("POURCENT_ACOMPTE") != null) {
            acompte = ((BigDecimal)row.getObject("POURCENT_ACOMPTE")).movePointLeft(2);
        }
        BigDecimal result = BigDecimal.ONE.subtract(remise.movePointLeft(2)).multiply(pv, DecimalUtils.HIGH_PRECISION).multiply(acompte, DecimalUtils.HIGH_PRECISION);
        return result.setScale(2, RoundingMode.HALF_UP);
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("PrixUnitaireRemise", new PrixUnitaireRemiseProvider(UNITAIRE_REMISE));
        SpreadSheetCellValueProviderManager.put("PrixTotalSansAcompte", new PrixUnitaireRemiseProvider(TOTAL_NON_ACOMPTE));
    }
}

