/*
 * Decompiled with CFR 0.152.
 */
package jpos.util.tracing;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import jpos.util.DefaultProperties;
import jpos.util.JposProperties;
import jpos.util.tracing.Tracer;

public class TracerFactory {
    private HashMap tracerMap = new HashMap();
    private HashMap namedTracerState = new HashMap();
    private Tracer globalTracer = Tracer.getInstance();
    private PrintStream printStream = null;
    private boolean turnOnAllNamedTracers = false;
    private static TracerFactory instance = null;
    public static final String TRACING_PROP_NAME = "jpos.tracing";
    public static final String TRACER_PROP_NAME = "jpos.util.tracing.Tracer";
    public static final String TURN_ON_NAMED_TRACERS_PROP_NAME = "jpos.util.tracing.TurnOnNamedTracers";
    public static final String TURN_ON_ALL_NAMED_TRACERS_PROP_NAME = "jpos.util.tracing.TurnOnAllNamedTracers";
    public static final String TRACER_OUTPUT_TO_FILE_PROP_NAME = "jpos.util.tracing.TracerOutputToFile";
    public static final String TRACER_OUTPUT_FILE_NAME_PROP_NAME = "jpos.util.tracing.TracerOutputFileName";
    public static final String TRACER_OUTPUT_FILE_LOCATION = "jpos.util.tracing.TracerOutputFileLocation";
    public static final String USER_HOME_LOCATION_VALUE = "<user.home>";

    protected TracerFactory() {
    }

    public static TracerFactory getInstance() {
        if (instance == null) {
            instance = new TracerFactory();
            instance.init();
        }
        return instance;
    }

    public void setOutputFile(File file) throws IOException {
    }

    public Tracer createGlobalTracer() {
        return this.globalTracer;
    }

    public Tracer createGlobalTracer(boolean bl) {
        this.globalTracer.setOn(bl);
        return this.globalTracer;
    }

    public Tracer createTracer(String string) {
        if (this.tracerMap.containsKey(string)) {
            return (Tracer)this.tracerMap.get(string);
        }
        Tracer tracer = new Tracer(string);
        if (this.namedTracerState.containsKey(string)) {
            tracer.setOn((Boolean)this.namedTracerState.get(string));
        } else {
            tracer.setOn(false);
        }
        if (this.turnOnAllNamedTracers) {
            tracer.setOn(true);
        }
        this.tracerMap.put(string, tracer);
        return tracer;
    }

    public Tracer createTracer(String string, boolean bl) {
        Tracer tracer = this.createTracer(string);
        tracer.setOn(bl);
        return tracer;
    }

    protected void finalize() {
        if (this.printStream != null) {
            this.printStream.close();
        }
    }

    private boolean isPropertyTrue(String string) {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("TRUE");
    }

    private void init() {
        DefaultProperties defaultProperties = new DefaultProperties();
        defaultProperties.loadJposProperties();
        this.initGlobalTracer(defaultProperties);
        this.initTurnedOnTracers(defaultProperties);
        this.initNamedTracers(defaultProperties);
        this.initTracerOutput();
    }

    private void initGlobalTracer(JposProperties jposProperties) {
        if (!jposProperties.isPropertyDefined(TRACING_PROP_NAME)) {
            this.globalTracer.setOn(false);
        } else {
            String string = jposProperties.getPropertyString(TRACING_PROP_NAME);
            if (this.isPropertyTrue(string)) {
                this.globalTracer.setOn(true);
            }
        }
    }

    private void initTurnedOnTracers(JposProperties jposProperties) {
        if (jposProperties.isPropertyDefined(TURN_ON_ALL_NAMED_TRACERS_PROP_NAME)) {
            String string = jposProperties.getPropertyString(TURN_ON_ALL_NAMED_TRACERS_PROP_NAME);
            this.turnOnAllNamedTracers = this.isPropertyTrue(string);
        } else if (jposProperties.isPropertyDefined(TURN_ON_NAMED_TRACERS_PROP_NAME)) {
            List list = jposProperties.getStringListProperty(TURN_ON_NAMED_TRACERS_PROP_NAME);
            int n = 0;
            while (n < list.size()) {
                String string = list.get(n).toString();
                this.namedTracerState.put(string, Boolean.TRUE);
                ++n;
            }
        }
    }

    private void initNamedTracers(JposProperties jposProperties) {
        Enumeration enumeration = jposProperties.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(TRACER_PROP_NAME)) continue;
            String string2 = string.substring("jpos.util.tracing.Tracer.".length(), string.length());
            if (!jposProperties.isPropertyDefined(string)) continue;
            String string3 = jposProperties.getPropertyString(string);
            if (string3.equalsIgnoreCase("ON") || string3.equalsIgnoreCase("TRUE")) {
                this.namedTracerState.put(string2, Boolean.TRUE);
                continue;
            }
            this.namedTracerState.put(string2, Boolean.FALSE);
        }
    }

    private void initTracerOutput() {
    }
}

