/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.openconcerto.utils.CollectionUtils;

public class SystemUtils {

    public static final class PropertyList {
        private final String name;
        private final Pattern p;

        public PropertyList(String name, String sep) {
            this.name = name;
            this.p = Pattern.compile(sep, 16);
        }

        public final String getName() {
            return this.name;
        }

        private final String getSeparator() {
            return this.p.pattern();
        }

        public final String getValue() {
            return System.getProperty(this.name);
        }

        public final List<String> getValues() {
            return this.getList(this.getValue());
        }

        private final List<String> getList(String current) {
            if (current == null) {
                return null;
            }
            if (current.length() == 0) {
                return Collections.emptyList();
            }
            return Arrays.asList(this.p.split(current));
        }

        public final boolean add(String value) {
            return this.add(value, true);
        }

        public final boolean add(String value, boolean append) {
            if (value == null) {
                throw new NullPointerException("Null value");
            }
            String current = this.getValue();
            List<String> l = this.getList(current);
            Object newVal = l == null || l.size() == 0 ? value : (l.contains(value) ? null : (append ? String.valueOf(current) + this.getSeparator() + value : String.valueOf(value) + this.getSeparator() + current));
            if (newVal != null) {
                System.setProperty(this.name, (String)newVal);
                return true;
            }
            return false;
        }

        public final boolean remove(String value) {
            return this.remove(value, true);
        }

        public final boolean remove(String value, boolean unsetIfEmpty) {
            if (value == null) {
                throw new NullPointerException("Null value");
            }
            List<String> l = this.getValues();
            if (l == null || l.size() == 0 || !l.contains(value)) {
                return false;
            }
            ArrayList<String> newList = new ArrayList<String>(l.size() - 1);
            for (String item : l) {
                if (item.equals(value)) continue;
                newList.add(item);
            }
            if (unsetIfEmpty && newList.isEmpty()) {
                System.clearProperty(this.name);
            } else {
                System.setProperty(this.name, CollectionUtils.join(newList, this.getSeparator()));
            }
            return true;
        }
    }
}

