/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.valuewrapper;

import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.openconcerto.ui.component.IDocument;
import org.openconcerto.ui.component.text.DocumentComponent;
import org.openconcerto.ui.component.text.TextComponentUtils;
import org.openconcerto.ui.valuewrapper.BaseValueWrapper;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class TextValueWrapper
extends BaseValueWrapper<String> {
    private final JComponent comp;
    private final IDocument doc;

    public static TextValueWrapper create(JComponent o) {
        Document doc = TextComponentUtils.getDocument(o);
        if (doc != null) {
            return new TextValueWrapper(o, doc);
        }
        throw new IllegalArgumentException("" + o);
    }

    public TextValueWrapper(JTextComponent b) {
        this(b, b.getDocument());
    }

    public TextValueWrapper(DocumentComponent b) {
        this(b.getComp(), b.getDocument());
    }

    private TextValueWrapper(JComponent b, Document doc) {
        this.comp = b;
        this.doc = new IDocument(doc);
        doc.addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                TextValueWrapper.this.firePropertyChange();
            }
        });
    }

    @Override
    public JComponent getComp() {
        return this.comp;
    }

    @Override
    public String getValue() {
        return this.doc.getText();
    }

    @Override
    public void setValue(String val) {
        this.doc.setText(val);
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }
}

