/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.util.Date;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.UserInitialsValueProvider;

public class DateProvider
extends UserInitialsValueProvider {
    private final TypeDateProvider type;

    public DateProvider(TypeDateProvider t) {
        this.type = t;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        if (this.type == TypeDateProvider.CREATION) {
            return context.getRow().getCreationDate().getTime();
        }
        if (this.type == TypeDateProvider.MODIFICATION) {
            return context.getRow().getModificationDate().getTime();
        }
        return new Date();
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("date.today", new DateProvider(TypeDateProvider.TODAY));
        SpreadSheetCellValueProviderManager.put("date.creation", new DateProvider(TypeDateProvider.CREATION));
        SpreadSheetCellValueProviderManager.put("date.modification", new DateProvider(TypeDateProvider.MODIFICATION));
    }

    private static enum TypeDateProvider {
        TODAY,
        CREATION,
        MODIFICATION;

    }
}

