/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.jopendocument.link.Component;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.DocumentLocalStorageManager;
import org.openconcerto.erp.generationDoc.OOgenerationListeXML;
import org.openconcerto.erp.generationDoc.SheetXml;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.StringUtils;

public abstract class AbstractListeSheetXml
extends SheetXml {
    protected Map<Integer, List<Map<String, Object>>> listAllSheetValues = new HashMap<Integer, List<Map<String, Object>>>();
    protected Map<Integer, Map<Integer, String>> styleAllSheetValues = new HashMap<Integer, Map<Integer, String>>();
    protected Map<Integer, Map<String, Object>> mapAllSheetValues = new HashMap<Integer, Map<String, Object>>();
    protected List<String> sheetNames = new ArrayList<String>();
    private File generatedOpenDocumentFile;

    public AbstractListeSheetXml(SQLRow row) {
        this.row = row;
        this.generatedOpenDocumentFile = new File(this.getDocumentOutputDirectory(), String.valueOf(AbstractListeSheetXml.getValidFileName(this.getName())) + ".ods");
    }

    public AbstractListeSheetXml() {
        this.generatedOpenDocumentFile = new File(this.getDocumentOutputDirectory(), String.valueOf(AbstractListeSheetXml.getValidFileName(this.getName())) + ".ods");
    }

    @Override
    public final Future<SheetXml> createDocumentAsynchronous() {
        Callable<SheetXml> c = new Callable<SheetXml>(){

            @Override
            public SheetXml call() throws Exception {
                try {
                    AbstractListeSheetXml.this.createListeValues();
                    AbstractListeSheetXml.this.generatedOpenDocumentFile = OOgenerationListeXML.genere(AbstractListeSheetXml.this.getTemplateId(), AbstractListeSheetXml.this.getDocumentOutputDirectory(), AbstractListeSheetXml.getValidFileName(AbstractListeSheetXml.this.getName()), AbstractListeSheetXml.this.listAllSheetValues, AbstractListeSheetXml.this.mapAllSheetValues, AbstractListeSheetXml.this.styleAllSheetValues, AbstractListeSheetXml.this.sheetNames, null);
                    if (AbstractListeSheetXml.this.listAllSheetValues != null) {
                        AbstractListeSheetXml.this.listAllSheetValues.clear();
                    }
                    if (AbstractListeSheetXml.this.mapAllSheetValues != null) {
                        AbstractListeSheetXml.this.mapAllSheetValues.clear();
                    }
                    if (AbstractListeSheetXml.this.styleAllSheetValues != null) {
                        AbstractListeSheetXml.this.styleAllSheetValues.clear();
                    }
                    if (AbstractListeSheetXml.this.isRefreshFormulasRequired()) {
                        Component doc = ComptaPropsConfiguration.getOOConnexion().loadDocument(AbstractListeSheetXml.this.generatedOpenDocumentFile, true);
                        doc.save();
                        doc.close();
                    }
                    return AbstractListeSheetXml.this;
                }
                catch (Exception e) {
                    DEFAULT_HANDLER.uncaughtException(null, e);
                    throw e;
                }
                catch (Throwable e) {
                    DEFAULT_HANDLER.uncaughtException(null, e);
                    return null;
                }
            }
        };
        return runnableQueue.submit(c);
    }

    protected abstract void createListeValues();

    @Override
    protected String getStoragePathP() {
        return StringUtils.firstUp(this.elt.getPluralName());
    }

    @Override
    public File getGeneratedFile() {
        return this.generatedOpenDocumentFile;
    }

    @Override
    public File getDocumentOutputDirectoryP() {
        return DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory(this.getTemplateId());
    }

    @Override
    public File getPDFOutputDirectoryP() {
        return DocumentLocalStorageManager.getInstance().getPDFOutputDirectory(this.getTemplateId());
    }
}

