/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.element;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.tree.TreePath;
import org.openconcerto.erp.config.DsnBrutCode;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.SQLJavaEditor;
import org.openconcerto.erp.core.humanresources.payroll.component.FormuleTreeNode;
import org.openconcerto.erp.core.humanresources.payroll.component.RubriqueSQLComponent;
import org.openconcerto.erp.core.humanresources.payroll.component.VariableTree;
import org.openconcerto.erp.core.humanresources.payroll.element.SalarieSQLElement;
import org.openconcerto.erp.core.humanresources.payroll.element.VariablePayeSQLElement;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.utils.ListMap;

public class RubriqueNetSQLElement
extends ComptaSQLConfElement {
    public RubriqueNetSQLElement(DBRoot root) {
        super(root.getTable("RUBRIQUE_NET"), "une rubrique de net", "rubriques de net");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("BASE");
        l.add("TAUX");
        l.add("MONTANT");
        l.add("BRUT");
        l.add("FRAIS_PERS");
        l.add("IMPOSABLE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        return l;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, new String[]{"CODE", "NOM"});
    }

    @Override
    public SQLComponent createComponent() {
        return new RubriqueSQLComponent(this){
            private SQLJavaEditor formuleBase;
            private SQLJavaEditor formuleTaux;
            private SQLJavaEditor formuleMontant;

            @Override
            protected void addViews(GridBagConstraints c) {
                JPanel panelCalcul = new JPanel();
                panelCalcul.setLayout(new GridBagLayout());
                DefaultGridBagConstraints cPanel = new DefaultGridBagConstraints();
                final VariableTree tree = new VariableTree();
                JScrollPane paneTree = new JScrollPane(tree);
                cPanel.gridheight = 0;
                cPanel.weighty = 1.0;
                cPanel.weightx = 1.0;
                cPanel.fill = 1;
                cPanel.fill = 2;
                cPanel.weighty = 0.0;
                cPanel.weightx = 0.0;
                cPanel.gridheight = 1;
                ++cPanel.gridx;
                Map<String, List<?>> mapTree = VariablePayeSQLElement.getMapTree();
                this.formuleBase = new SQLJavaEditor(mapTree);
                this.formuleBase.setVarAssign("BASE");
                final JRadioButton radioBase = new JRadioButton(this.getLabelFor("BASE"));
                panelCalcul.add((Component)radioBase, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)((Object)this.formuleBase), cPanel);
                JSeparator sep1 = new JSeparator();
                cPanel.gridwidth = 0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                panelCalcul.add((Component)sep1, cPanel);
                cPanel.gridwidth = 1;
                cPanel.weightx = 0.0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                this.formuleTaux = new SQLJavaEditor(mapTree);
                this.formuleTaux.setVarAssign("TAUX");
                JRadioButton radioTaux = new JRadioButton(this.getLabelFor("TAUX"));
                panelCalcul.add((Component)radioTaux, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)((Object)this.formuleTaux), cPanel);
                JSeparator sep2 = new JSeparator();
                cPanel.gridwidth = 0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                panelCalcul.add((Component)sep2, cPanel);
                cPanel.gridwidth = 1;
                cPanel.weightx = 0.0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                this.formuleMontant = new SQLJavaEditor(mapTree);
                this.formuleMontant.setVarAssign("MONTANT");
                final JRadioButton radioMontant = new JRadioButton(this.getLabelFor("MONTANT"));
                panelCalcul.add((Component)radioMontant, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)((Object)this.formuleMontant), cPanel);
                JSeparator sep3 = new JSeparator();
                cPanel.gridwidth = 0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                panelCalcul.add((Component)sep3, cPanel);
                cPanel.gridwidth = 1;
                cPanel.weightx = 0.0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                JLabel labelSelSal = new JLabel("Salari\u00e9");
                labelSelSal.setHorizontalAlignment(4);
                panelCalcul.add((Component)labelSelSal, cPanel);
                SalarieSQLElement eltSal = this.getDirectory().getElement(SalarieSQLElement.class);
                final ElementComboBox selSalarie = new ElementComboBox(false);
                ++cPanel.gridx;
                selSalarie.init(eltSal);
                panelCalcul.add((Component)selSalarie, cPanel);
                ButtonGroup groupRadio = new ButtonGroup();
                groupRadio.add(radioBase);
                groupRadio.add(radioMontant);
                groupRadio.add(radioTaux);
                radioBase.setSelected(true);
                tree.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (e.getClickCount() == 2 && e.getButton() == 1) {
                            TreePath path = tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y);
                            Object obj = path.getLastPathComponent();
                            if (obj == null) {
                                return;
                            }
                            if (obj instanceof FormuleTreeNode) {
                                FormuleTreeNode n = (FormuleTreeNode)obj;
                                if (radioBase.isSelected()) {
                                    int start = formuleBase.getSelectionStart();
                                    String tmp = formuleBase.getText();
                                    formuleBase.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                } else if (radioMontant.isSelected()) {
                                    int start = formuleMontant.getSelectionStart();
                                    String tmp = formuleMontant.getText();
                                    formuleMontant.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                } else {
                                    int start = formuleTaux.getSelectionStart();
                                    String tmp = formuleTaux.getText();
                                    formuleTaux.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                }
                            }
                        }
                    }
                });
                JPanel panelProp = new JPanel();
                panelProp.setLayout(new GridBagLayout());
                cPanel.gridx = 0;
                cPanel.gridy = 0;
                cPanel.weightx = 0.0;
                cPanel.weighty = 0.0;
                cPanel.gridwidth = 1;
                cPanel.gridheight = 1;
                cPanel.fill = 2;
                cPanel.anchor = 18;
                cPanel.insets = new Insets(2, 2, 1, 2);
                this.addView("ID_PERIODE_VALIDITE", "required;notdecorated;noseparator");
                ElementSQLObject eltInfosPaye = (ElementSQLObject)this.getView("ID_PERIODE_VALIDITE");
                cPanel.gridy = 0;
                cPanel.gridx = 0;
                cPanel.gridheight = 0;
                cPanel.weighty = 1.0;
                cPanel.fill = 0;
                JPanel panelPeriodeVal = new JPanel();
                panelPeriodeVal.setBorder(BorderFactory.createTitledBorder("P\u00e9riode de validit\u00e9"));
                panelPeriodeVal.add(eltInfosPaye);
                panelProp.add((Component)panelPeriodeVal, cPanel);
                cPanel.weightx = 0.0;
                cPanel.weighty = 0.0;
                cPanel.gridheight = 1;
                cPanel.fill = 2;
                JLabel labelSelTypeRubrique = new JLabel("Type");
                labelSelTypeRubrique.setHorizontalAlignment(4);
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                cPanel.anchor = 17;
                panelProp.add((Component)labelSelTypeRubrique, cPanel);
                cPanel.anchor = 18;
                SQLRequestComboBox comboSelType = new SQLRequestComboBox(true, 20);
                ++cPanel.gridx;
                panelProp.add((Component)comboSelType, cPanel);
                JLabel labelSelTypeRubriqueImpression = new JLabel("Impression");
                labelSelTypeRubriqueImpression.setHorizontalAlignment(4);
                ++cPanel.gridx;
                cPanel.anchor = 17;
                panelProp.add((Component)labelSelTypeRubriqueImpression, cPanel);
                cPanel.anchor = 18;
                SQLRequestComboBox comboSelTypeImpression = new SQLRequestComboBox(true, 20);
                ++cPanel.gridx;
                c.fill = 0;
                c.weightx = 0.0;
                panelProp.add((Component)comboSelTypeImpression, cPanel);
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                ++cPanel.gridy;
                c.fill = 2;
                cPanel.gridwidth = 0;
                JCheckBox checkImpo = new JCheckBox(this.getLabelFor("IMPOSABLE"));
                panelProp.add((Component)checkImpo, cPanel);
                ++cPanel.gridy;
                JCheckBox checkFraisPers = new JCheckBox(this.getLabelFor("FRAIS_PERS"));
                panelProp.add((Component)checkFraisPers, cPanel);
                ++cPanel.gridy;
                JCheckBox checkBrut = new JCheckBox(this.getLabelFor("BRUT"));
                panelProp.add((Component)checkBrut, cPanel);
                ++cPanel.gridy;
                cPanel.gridwidth = 1;
                JLabel labelCpt = new JLabel(this.getLabelFor("NUMERO_COMPTE_PCE_CHARGES"));
                panelProp.add((Component)labelCpt, cPanel);
                ++cPanel.gridx;
                JTextField textCpt = new JTextField(this.getLabelFor("NUMERO_COMPTE_PCE_CHARGES"));
                panelProp.add((Component)textCpt, cPanel);
                this.addView(textCpt, "NUMERO_COMPTE_PCE_CHARGES");
                TitledSeparator sepRenseignement = new TitledSeparator("Prime, gratification et indemnit\u00e9 (S21.G00.52)");
                cPanel.gridwidth = 0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                panelProp.add((Component)sepRenseignement, cPanel);
                JLabel labelSelCodeRubrique = new JLabel("Code DSN (S21.G00.52.001)");
                labelSelCodeRubrique.setHorizontalAlignment(4);
                ++cPanel.gridy;
                cPanel.gridwidth = 1;
                cPanel.gridx = 1;
                cPanel.gridheight = 1;
                cPanel.gridwidth = 1;
                cPanel.weightx = 0.0;
                cPanel.anchor = 17;
                panelProp.add((Component)labelSelCodeRubrique, cPanel);
                ElementComboBox comboSelCodeRubrique = new ElementComboBox(false);
                SQLElement foreignElement = this.getElement().getForeignElement("ID_CODE_TYPE_RUBRIQUE_BRUT");
                ComboSQLRequest req = foreignElement.getComboRequest(true);
                Where where = new Where((FieldRef)foreignElement.getTable().getField("TYPE"), "=", (Object)DsnBrutCode.DsnTypeCodeBrut.PRIME.getName());
                where = where.or(new Where((FieldRef)foreignElement.getTable().getField("TYPE"), "=", (Object)DsnBrutCode.DsnTypeCodeBrut.AUTRE.getName()));
                req.setWhere(where);
                comboSelCodeRubrique.init(foreignElement, req);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelProp.add((Component)comboSelCodeRubrique, cPanel);
                this.addView(comboSelCodeRubrique, "ID_CODE_TYPE_RUBRIQUE_BRUT");
                TitledSeparator sepRenseignementPrev = new TitledSeparator("Renseignement contrat pr\u00e9voyance, mutuelle");
                cPanel.gridwidth = 0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                panelProp.add((Component)sepRenseignementPrev, cPanel);
                JLabel labelSelCaisse = new JLabel("Caisse de cotisation");
                ++cPanel.gridy;
                cPanel.gridwidth = 1;
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                panelProp.add((Component)labelSelCaisse, cPanel);
                ElementComboBox comboSelTypeCaisse = new ElementComboBox(true);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelProp.add((Component)comboSelTypeCaisse, cPanel);
                this.addView(comboSelTypeCaisse, "ID_CAISSE_COTISATION");
                JLabel labelSelTypeBase = new JLabel("Code Base assujettie (S21.G00.78)");
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                panelProp.add((Component)labelSelTypeBase, cPanel);
                ElementComboBox comboSelTypeBase = new ElementComboBox(false);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelProp.add((Component)comboSelTypeBase, cPanel);
                this.addView(comboSelTypeBase, "ID_CODE_BASE_ASSUJETTIE");
                JLabel labelSelTypeComposant = new JLabel("Type Composant base assujettie (S21.G00.79)");
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                panelProp.add((Component)labelSelTypeComposant, cPanel);
                ElementComboBox comboSelTypeComposant = new ElementComboBox(false);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelProp.add((Component)comboSelTypeComposant, cPanel);
                this.addView(comboSelTypeComposant, "ID_TYPE_COMPOSANT_BASE_ASSUJETTIE");
                JLabel labelSelCodeInd = new JLabel("Code cotisation individuelle (S21.G00.81)");
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                panelProp.add((Component)labelSelCodeInd, cPanel);
                ElementComboBox comboSelCodeInd = new ElementComboBox(false);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelProp.add((Component)comboSelCodeInd, cPanel);
                this.addView(comboSelCodeInd, "ID_CODE_COTISATION_INDIVIDUELLE");
                JTabbedPane tab = new JTabbedPane();
                tab.add("Calcul", new JSplitPane(1, paneTree, panelCalcul));
                tab.add("Propri\u00e9t\u00e9s", panelProp);
                c.gridwidth = 0;
                c.gridx = 0;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.add((Component)tab, c);
                this.addSQLObject((JComponent)((Object)this.formuleBase), "BASE");
                this.addSQLObject((JComponent)((Object)this.formuleTaux), "TAUX");
                this.addSQLObject((JComponent)((Object)this.formuleMontant), "MONTANT");
                this.addSQLObject(checkBrut, "BRUT");
                this.addSQLObject(checkFraisPers, "FRAIS_PERS");
                this.addSQLObject(checkImpo, "IMPOSABLE");
                this.addRequiredSQLObject(comboSelTypeImpression, "ID_IMPRESSION_RUBRIQUE");
                this.addRequiredSQLObject(comboSelType, "ID_TYPE_RUBRIQUE_NET");
                selSalarie.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        formuleBase.setSalarieID(selSalarie.getSelectedId());
                        formuleTaux.setSalarieID(selSalarie.getSelectedId());
                        formuleMontant.setSalarieID(selSalarie.getSelectedId());
                    }
                });
            }
        };
    }

    @Override
    protected String createCode() {
        return "humanresources.payroll.category";
    }
}

