/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.component;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.openconcerto.erp.core.humanresources.payroll.element.VariablePayeSQLElement;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.text.SimpleDocumentListener;

public abstract class RubriqueSQLComponent
extends BaseSQLComponent {
    private final JTextField textCode;
    private final JLabel labelWarningBadName;
    private final JTextField textLibelle = new JTextField();
    private ValidState validCode = ValidState.getTrueInstance();

    public RubriqueSQLComponent(SQLElement element) {
        super(element);
        this.textCode = new JTextField();
        this.textCode.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                RubriqueSQLComponent.this.updateCodeValidity();
            }
        });
        this.labelWarningBadName = new JLabelWarning("Code d\u00e9j\u00e0 attribu\u00e9");
    }

    @Override
    public final void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JLabel labelCode = new JLabel(this.getLabelFor("CODE"));
        labelCode.setHorizontalAlignment(4);
        this.add((Component)labelCode, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textCode, c);
        c.weightx = 0.0;
        ++c.gridx;
        this.add((Component)this.labelWarningBadName, c);
        this.labelWarningBadName.setVisible(false);
        ++c.gridy;
        c.gridx = 0;
        JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
        labelNom.setHorizontalAlignment(4);
        this.add((Component)labelNom, c);
        boolean nl = this.newline();
        ++c.gridx;
        c.gridwidth = nl ? 0 : 1;
        c.weightx = 1.0;
        this.add((Component)this.textLibelle, c);
        c.weightx = 0.0;
        c.gridwidth = 1;
        if (nl) {
            ++c.gridy;
        }
        this.addRequiredSQLObject(this.textCode, "CODE");
        this.addSQLObject(this.textLibelle, "NOM");
        this.addViews(c);
    }

    protected boolean newline() {
        return true;
    }

    protected abstract void addViews(GridBagConstraints var1);

    private ValidState computeCodeValidity() {
        Number rubCount;
        String code = this.textCode.getText().trim();
        if (VariablePayeSQLElement.isForbidden(code)) {
            return ValidState.createCached(false, "Code r\u00e9serv\u00e9");
        }
        SQLSelect selAllCodeName = new SQLSelect(this.getTable().getBase());
        selAllCodeName.addSelectFunctionStar("count");
        selAllCodeName.setWhere(new Where((FieldRef)this.getTable().getField("CODE"), "=", (Object)code));
        int idSelected = this.getSelectedID();
        if (idSelected >= 0) {
            selAllCodeName.andWhere(new Where((FieldRef)this.getTable().getField("ID"), "!=", idSelected));
        }
        if ((rubCount = (Number)this.getTable().getDBSystemRoot().getDataSource().executeScalar(selAllCodeName.asString())).intValue() > 0) {
            return ValidState.createCached(false, "Code d\u00e9j\u00e0 attribu\u00e9");
        }
        SQLSelect selAllVarName = new SQLSelect(this.getTable().getBase());
        SQLTable tableVar = this.getTable().getTable("VARIABLE_PAYE");
        selAllVarName.addSelectFunctionStar("count");
        selAllVarName.setWhere(new Where((FieldRef)tableVar.getField("NOM"), "=", (Object)code));
        Number payVarCount = (Number)this.getTable().getDBSystemRoot().getDataSource().executeScalar(selAllVarName.asString());
        return ValidState.createCached(payVarCount.intValue() == 0, "Code d\u00e9j\u00e0 attribu\u00e9 \u00e0 une variable de paye");
    }

    private void updateCodeValidity() {
        this.setValidCode(this.computeCodeValidity());
    }

    private final void setValidCode(ValidState state) {
        if (!state.equals(this.validCode)) {
            this.validCode = state;
            boolean visible = !this.validCode.isValid();
            this.labelWarningBadName.setVisible(visible);
            if (visible) {
                this.labelWarningBadName.setText(this.validCode.getValidationText());
            }
            this.fireValidChange();
        }
    }

    @Override
    public synchronized ValidState getValidState() {
        return super.getValidState().and(this.validCode);
    }

    @Override
    public void select(SQLRowAccessor r) {
        super.select(r);
        this.updateCodeValidity();
    }
}

