/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.accounting.model.PointageModel;
import org.openconcerto.erp.core.finance.accounting.ui.ListPanelEcritures;
import org.openconcerto.erp.core.finance.accounting.ui.PointageRenderer;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FontUtils;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class PointagePanel
extends JPanel {
    private ListPanelEcritures ecriturePanel;
    private JTextField codePointage;
    private ISQLCompteSelector selCompte;
    private final JDate datePointee;
    private JCheckBox boxValidEcriture;
    private JPanel warningPanel;
    private final DeviseField fieldSoldeD = new DeviseField(15);
    private final DeviseField fieldSoldeA = new DeviseField(15);
    private final DeviseField fieldEcart = new DeviseField(15);
    private final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private final SQLTable tableEcr = this.base.getTable("ECRITURE");
    private final SQLTable tableCpt = this.base.getTable("COMPTE_PCE");
    private static final int allEcriture = 0;
    private static final int ecriturePointee = 1;
    private static final int ecritureNotPointee = 2;
    private int modeSelect;
    private PointageModel model;
    private JButton buttonPointer;
    private JDate dateFin;
    private JDate dateDeb;

    public PointagePanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        SQLElementDirectory directory = Configuration.getInstance().getDirectory();
        this.modeSelect = 0;
        JLabel labelPointageCompte = new JLabel("Pointage du compte");
        labelPointageCompte.setHorizontalAlignment(4);
        this.add((Component)labelPointageCompte, c);
        this.selCompte = new ISQLCompteSelector();
        SQLElement eltCpt = directory.getElement("COMPTE_PCE");
        ComboSQLRequest createComboRequest = eltCpt.createComboRequest();
        String function = "REGEXP";
        if (Configuration.getInstance().getBase().getServer().getSQLSystem() == SQLSystem.POSTGRESQL) {
            function = "~";
        }
        createComboRequest.setWhere(new Where((FieldRef)eltCpt.getTable().getField("NUMERO"), function, (Object)"^5.*$"));
        this.selCompte.init(eltCpt, createComboRequest);
        new SwingWorker<Integer, Object>(){

            @Override
            protected Integer doInBackground() throws Exception {
                return ComptePCESQLElement.getId("5");
            }

            @Override
            protected void done() {
                try {
                    PointagePanel.this.selCompte.setValue((Integer)this.get());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }.execute();
        c.weightx = 1.0;
        ++c.gridx;
        c.gridwidth = 0;
        this.add((Component)this.selCompte, c);
        c.insets = new Insets(2, 2, 1, 2);
        TitledSeparator sepGestionPointage = new TitledSeparator("Gestion du pointage");
        c.fill = 2;
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)sepGestionPointage, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        JLabel labelReleve = new JLabel("N\u00b0 de relev\u00e9");
        labelReleve.setHorizontalAlignment(4);
        this.add((Component)labelReleve, c);
        this.codePointage = new JTextField(10);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 17;
        this.add((Component)this.codePointage, c);
        ++c.gridx;
        c.fill = 2;
        this.createPanelWarning();
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.add((Component)this.warningPanel, c);
        JLabel labelDate = new JLabel("Date de pointage");
        labelDate.setHorizontalAlignment(4);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)labelDate, c);
        this.datePointee = new JDate(true);
        c.fill = 0;
        c.weightx = 1.0;
        ++c.gridx;
        c.gridwidth = 1;
        this.add((Component)this.datePointee, c);
        JPanel panelCheckValue = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cCheck = new DefaultGridBagConstraints();
        JLabel labelSoldeD = new JLabel("Solde de d\u00e9part");
        labelSoldeD.setHorizontalAlignment(4);
        cCheck.gridwidth = 1;
        cCheck.weightx = 0.0;
        panelCheckValue.add((Component)labelSoldeD, cCheck);
        cCheck.fill = 0;
        cCheck.weightx = 1.0;
        ++cCheck.gridx;
        cCheck.gridwidth = 1;
        panelCheckValue.add((Component)this.fieldSoldeD, cCheck);
        JLabel labelSoldeA = new JLabel("Solde d'arriv\u00e9e");
        labelSoldeA.setHorizontalAlignment(4);
        ++cCheck.gridx;
        cCheck.gridwidth = 1;
        cCheck.weightx = 0.0;
        panelCheckValue.add((Component)labelSoldeA, cCheck);
        cCheck.fill = 0;
        cCheck.weightx = 1.0;
        ++cCheck.gridx;
        cCheck.gridwidth = 1;
        panelCheckValue.add((Component)this.fieldSoldeA, cCheck);
        JLabel labelEcart = new JLabel("Ecart pointage");
        labelEcart.setHorizontalAlignment(4);
        ++cCheck.gridx;
        cCheck.gridwidth = 1;
        cCheck.weightx = 0.0;
        panelCheckValue.add((Component)labelEcart, cCheck);
        cCheck.fill = 0;
        cCheck.weightx = 1.0;
        ++cCheck.gridx;
        cCheck.gridwidth = 1;
        this.fieldEcart.setEditable(false);
        panelCheckValue.add((Component)this.fieldEcart, cCheck);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.add((Component)panelCheckValue, c);
        this.fieldSoldeA.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                PointagePanel.this.model.updateTotauxCompte(PointagePanel.this.fieldSoldeD, PointagePanel.this.fieldSoldeA, PointagePanel.this.fieldEcart);
            }
        });
        this.fieldSoldeD.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                PointagePanel.this.model.updateTotauxCompte(PointagePanel.this.fieldSoldeD, PointagePanel.this.fieldSoldeA, PointagePanel.this.fieldEcart);
            }
        });
        TitledSeparator sepPeriode = new TitledSeparator("Filtre ");
        ++c.gridy;
        c.gridx = 0;
        c.anchor = 17;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)sepPeriode, c);
        JPanel panelSelectEcritures = this.createPanelSelectionEcritures();
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.gridx = 0;
        JLabel labelEcr = new JLabel("Ecritures");
        labelEcr.setHorizontalAlignment(4);
        this.add((Component)labelEcr, c);
        ++c.gridx;
        c.fill = 0;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)panelSelectEcritures, c);
        c.fill = 2;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        JPanel panelPeriode = new JPanel();
        this.dateDeb = new JDate();
        JLabel periodLabel = new JLabel("P\u00e9riode du ");
        periodLabel.setHorizontalAlignment(4);
        c.gridwidth = 1;
        this.add((Component)periodLabel, c);
        ++c.gridx;
        panelPeriode.add(this.dateDeb);
        this.dateDeb.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PointagePanel.this.changeListRequest();
                PointagePanel.this.model.updateTotauxCompte(PointagePanel.this.fieldSoldeD, PointagePanel.this.fieldSoldeA, PointagePanel.this.fieldEcart);
            }
        });
        this.dateFin = new JDate(true);
        panelPeriode.add(new JLabel("au"));
        this.dateFin.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PointagePanel.this.changeListRequest();
                PointagePanel.this.model.updateTotauxCompte(PointagePanel.this.fieldSoldeD, PointagePanel.this.fieldSoldeA, PointagePanel.this.fieldEcart);
            }
        });
        panelPeriode.add(this.dateFin);
        c.weightx = 1.0;
        c.fill = 0;
        c.gridwidth = 0;
        this.add((Component)panelPeriode, c);
        TitledSeparator sepEcriture = new TitledSeparator("Ecritures ");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)sepEcriture, c);
        EcritureSQLElement ecritureElem = directory.getElement(EcritureSQLElement.class);
        this.ecriturePanel = new ListPanelEcritures((SQLElement)ecritureElem, new IListe(ecritureElem.createPointageTableSource()));
        this.ecriturePanel.setShowReadOnlyFrameOnDoubleClick(false);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        this.ecriturePanel.getListe().setPreferredSize(new Dimension(this.ecriturePanel.getListe().getPreferredSize().width, 200));
        this.add((Component)this.ecriturePanel, c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 1;
        c.gridwidth = 4;
        c.gridheight = 3;
        this.model = new PointageModel(this.selCompte.getSelectedId(), this);
        JTable table = new JTable(this.model);
        table.setRowHeight(FontUtils.getPreferredRowHeight(table));
        DeviseNiceTableCellRenderer cellRenderer = new DeviseNiceTableCellRenderer();
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumnModel().getColumn(i).setCellRenderer(cellRenderer);
            ++i;
        }
        JScrollPane sPane = new JScrollPane(table);
        Dimension d = new Dimension(table.getPreferredSize().width, table.getPreferredSize().height + table.getTableHeader().getPreferredSize().height + 4);
        sPane.setPreferredSize(d);
        this.add((Component)sPane, c);
        c.gridx += 4;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        this.add((Component)this.createPanelLegende(), c);
        this.boxValidEcriture = new JCheckBox("Valider les \u00e9critures point\u00e9es");
        ++c.gridx;
        c.gridheight = 1;
        c.gridwidth = 0;
        this.add((Component)this.boxValidEcriture, c);
        c.anchor = 14;
        this.buttonPointer = new JButton("Pointer");
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.gridx = 5;
        ++c.gridy;
        c.fill = 0;
        this.add((Component)this.buttonPointer, c);
        JButton buttonDepointer = new JButton("D\u00e9pointer");
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)buttonDepointer, c);
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.gridx = 5;
        ++c.gridy;
        c.fill = 0;
        c.anchor = 13;
        JButton buttonClose = new JButton("Fermer");
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Window)SwingUtilities.getRoot(PointagePanel.this)).dispose();
            }
        });
        this.add((Component)buttonClose, c);
        this.buttonPointer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rowIndex = PointagePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                int i = 0;
                while (i < rowIndex.length) {
                    System.err.println("Action pointage sur " + i);
                    PointagePanel.this.actionPointage(rowIndex[i]);
                    ++i;
                }
            }
        });
        buttonDepointer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rowIndex = PointagePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                int i = 0;
                while (i < rowIndex.length) {
                    System.err.println("Action depointage sur " + i);
                    PointagePanel.this.actionDepointage(rowIndex[i]);
                    ++i;
                }
            }
        });
        this.selCompte.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PointagePanel.this.changeListRequest();
            }
        });
        this.ecriturePanel.getListe().getJTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    int rowIndex = PointagePanel.this.ecriturePanel.getListe().getJTable().rowAtPoint(e.getPoint());
                    int id = PointagePanel.this.ecriturePanel.getListe().idFromIndex(rowIndex);
                    SQLRow row = PointagePanel.this.tableEcr.getRow(id);
                    if (row.getString("POINTEE").trim().length() == 0) {
                        PointagePanel.this.actionPointage(rowIndex);
                    } else {
                        PointagePanel.this.actionDepointage(rowIndex);
                    }
                }
                if (e.getButton() == 3) {
                    PointagePanel.this.actionMenuDroit(e);
                }
                int[] selectedRows = PointagePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                int[] idRows = new int[selectedRows.length];
                int i = 0;
                while (i < idRows.length) {
                    idRows[i] = PointagePanel.this.ecriturePanel.getListe().idFromIndex(selectedRows[i]);
                    ++i;
                }
                PointagePanel.this.model.updateSelection(idRows);
            }
        });
        this.ecriturePanel.getListe().getJTable().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int[] selectedRows = PointagePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                int[] idRows = new int[selectedRows.length];
                int i = 0;
                while (i < idRows.length) {
                    idRows[i] = PointagePanel.this.ecriturePanel.getListe().idFromIndex(selectedRows[i]);
                    ++i;
                }
                PointagePanel.this.model.updateSelection(idRows);
            }
        });
        this.ecriturePanel.getListe().addListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                PointagePanel.this.model.updateTotauxCompte(PointagePanel.this.fieldSoldeD, PointagePanel.this.fieldSoldeA, PointagePanel.this.fieldEcart);
            }
        });
        this.codePointage.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                PointagePanel.this.warningPanel.setVisible(PointagePanel.this.codePointage.getText().trim().length() == 0);
                PointagePanel.this.buttonPointer.setEnabled(PointagePanel.this.codePointage.getText().trim().length() != 0);
                PointagePanel.this.model.updateTotauxCompte(PointagePanel.this.fieldSoldeD, PointagePanel.this.fieldSoldeA, PointagePanel.this.fieldEcart);
            }
        });
        this.changeListRequest();
        this.warningPanel.setVisible(this.codePointage.getText().trim().length() == 0);
        this.buttonPointer.setEnabled(this.codePointage.getText().trim().length() != 0);
    }

    private void actionMenuDroit(final MouseEvent mE) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new AbstractAction("Voir la source"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowIndex = PointagePanel.this.ecriturePanel.getListe().getJTable().rowAtPoint(mE.getPoint());
                int id = PointagePanel.this.ecriturePanel.getListe().idFromIndex(rowIndex);
                SQLTable ecriture = PointagePanel.this.base.getTable("ECRITURE");
                SQLRow rowEcr = ecriture.getRow(id);
                MouvementSQLElement.showSource(rowEcr.getInt("ID_MOUVEMENT"));
            }
        });
        if (this.codePointage.getText().trim().length() != 0) {
            menu.add(new AbstractAction("Pointer"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rowIndex = PointagePanel.this.ecriturePanel.getListe().getJTable().rowAtPoint(mE.getPoint());
                    PointagePanel.this.actionPointage(rowIndex);
                }
            });
        }
        menu.add(new AbstractAction("D\u00e9pointer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowIndex = PointagePanel.this.ecriturePanel.getListe().getJTable().rowAtPoint(mE.getPoint());
                PointagePanel.this.actionDepointage(rowIndex);
            }
        });
        menu.show(mE.getComponent(), mE.getPoint().x, mE.getPoint().y);
    }

    public java.util.Date getDateDeb() {
        return this.dateDeb.getValue();
    }

    public java.util.Date getDateFin() {
        return this.dateFin.getDate();
    }

    public String getCodePointage() {
        return this.codePointage.getText();
    }

    private void createPanelWarning() {
        this.warningPanel = new JPanel();
        this.warningPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JLabelWarning warningNoCodeImg = new JLabelWarning();
        this.warningPanel.add((Component)warningNoCodeImg, c);
        JLabel warningNoCodeText = new JLabel("Impossible de pointer tant que le num\u00e9ro de relev\u00e9 n'est pas saisi!");
        ++c.gridx;
        this.warningPanel.add((Component)warningNoCodeText, c);
    }

    private void actionPointage(int rowIndex) {
        String codePoint = this.codePointage.getText().trim();
        int id = this.ecriturePanel.getListe().idFromIndex(rowIndex);
        SQLRow row = this.tableEcr.getRow(id);
        SQLRowValues rowVals = new SQLRowValues(this.tableEcr);
        if (!this.datePointee.isEmpty() && codePoint.length() > 0) {
            if (this.boxValidEcriture.isSelected() && !row.getBoolean("VALIDE").booleanValue()) {
                EcritureSQLElement.validationEcritures(row.getInt("ID_MOUVEMENT"));
            }
            rowVals.put("POINTEE", codePoint);
            rowVals.put("DATE_POINTEE", new Date(this.datePointee.getDate().getTime()));
            try {
                rowVals.update(id);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        this.model.updateTotauxCompte(this.fieldSoldeD, this.fieldSoldeA, this.fieldEcart);
    }

    public ListPanelEcritures getEcriturePanel() {
        return this.ecriturePanel;
    }

    private void actionDepointage(int rowIndex) {
        int id = this.ecriturePanel.getListe().idFromIndex(rowIndex);
        SQLRow row = this.tableEcr.getRow(id);
        SQLRowValues rowVals = new SQLRowValues(this.tableEcr);
        if (row.getString("POINTEE").trim().length() != 0) {
            rowVals.put("POINTEE", "");
            rowVals.put("DATE_POINTEE", null);
            try {
                rowVals.update(id);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        this.model.updateTotauxCompte(this.fieldSoldeD, this.fieldSoldeA, this.fieldEcart);
    }

    private void changeListRequest() {
        Integer idCpt = this.selCompte.getSelectedId();
        Where w = new Where((FieldRef)this.tableEcr.getField("ID_COMPTE_PCE"), "=", (Object)idCpt);
        if (!UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.ACCES_NOT_RESCTRICTED_TO_411)) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("COMPTE_NUMERO"), "LIKE", (Object)"411%"));
        }
        java.util.Date d1 = this.dateDeb.getValue();
        java.util.Date d2 = this.dateFin.getValue();
        if (d1 == null && d2 != null) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("DATE"), "<=", (Object)d2));
        } else if (d1 != null && d2 == null) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("DATE"), ">=", (Object)d1));
        } else if (d1 != null && d2 != null) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("DATE"), d1, (Object)d2));
        }
        if (this.modeSelect == 1) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("POINTEE"), "!=", (Object)""));
        } else if (this.modeSelect == 2) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("POINTEE"), "=", (Object)""));
        }
        this.ecriturePanel.getListe().getRequest().setWhere(w);
        this.ecriturePanel.getListe().setModificationAllowed(false);
        this.model.setIdCompte(Integer.parseInt(((Object)idCpt).toString()));
    }

    private JPanel createPanelSelectionEcritures() {
        JPanel panelSelectEcritures = new JPanel();
        GridBagConstraints cPanel = new GridBagConstraints();
        cPanel.anchor = 18;
        cPanel.fill = 2;
        cPanel.gridheight = 1;
        cPanel.gridwidth = 1;
        cPanel.gridx = 0;
        cPanel.gridy = 0;
        cPanel.weightx = 0.0;
        cPanel.weighty = 0.0;
        panelSelectEcritures.setLayout(new GridBagLayout());
        final JRadioButton buttonBoth = new JRadioButton("Toutes");
        panelSelectEcritures.add((Component)buttonBoth, cPanel);
        ++cPanel.gridx;
        final JRadioButton buttonNotPointe = new JRadioButton("Non point\u00e9es");
        panelSelectEcritures.add((Component)buttonNotPointe, cPanel);
        ++cPanel.gridx;
        final JRadioButton buttonPointe = new JRadioButton("Point\u00e9es");
        panelSelectEcritures.add((Component)buttonPointe, cPanel);
        ButtonGroup group = new ButtonGroup();
        group.add(buttonBoth);
        group.add(buttonNotPointe);
        group.add(buttonPointe);
        buttonBoth.setSelected(true);
        buttonPointe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (buttonPointe.isSelected()) {
                    PointagePanel.this.modeSelect = 1;
                    PointagePanel.this.changeListRequest();
                }
            }
        });
        buttonNotPointe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (buttonNotPointe.isSelected()) {
                    PointagePanel.this.modeSelect = 2;
                    PointagePanel.this.changeListRequest();
                }
            }
        });
        buttonBoth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (buttonBoth.isSelected()) {
                    PointagePanel.this.modeSelect = 0;
                    PointagePanel.this.changeListRequest();
                }
            }
        });
        return panelSelectEcritures;
    }

    private JPanel createPanelLegende() {
        JPanel panelLegende = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 0, 0, 0);
        GridBagConstraints cPanel = new GridBagConstraints();
        cPanel.anchor = 18;
        cPanel.fill = 2;
        cPanel.gridheight = 1;
        cPanel.gridwidth = 1;
        cPanel.gridx = 0;
        cPanel.gridy = -1;
        cPanel.weightx = 0.0;
        cPanel.weighty = 0.0;
        cPanel.insets = new Insets(0, 0, 0, 0);
        panelLegende.setLayout(new GridBagLayout());
        panelLegende.setBorder(BorderFactory.createTitledBorder("L\u00e9gendes"));
        JPanel ecritureValidPanel = new JPanel();
        ecritureValidPanel.setLayout(new GridBagLayout());
        ecritureValidPanel.setBackground(Color.WHITE);
        ecritureValidPanel.add((Component)new JLabel("Ecritures valid\u00e9es"), cPanel);
        panelLegende.add((Component)ecritureValidPanel, c);
        JPanel ecritureNonValidPanel = new JPanel();
        ecritureNonValidPanel.setLayout(new GridBagLayout());
        ecritureNonValidPanel.setBackground(PointageRenderer.getCouleurEcritureNonValide());
        ecritureNonValidPanel.add((Component)new JLabel("Ecritures non valid\u00e9es"), cPanel);
        panelLegende.add((Component)ecritureNonValidPanel, c);
        JPanel ecritureNonValidTodayPanel = new JPanel();
        ecritureNonValidTodayPanel.setLayout(new GridBagLayout());
        ecritureNonValidTodayPanel.setBackground(PointageRenderer.getCouleurEcritureToDay());
        ecritureNonValidTodayPanel.add((Component)new JLabel("Ecritures non valid\u00e9es du jour"), cPanel);
        panelLegende.add((Component)ecritureNonValidTodayPanel, c);
        JPanel ecriturePointePanel = new JPanel();
        ecriturePointePanel.setLayout(new GridBagLayout());
        ecriturePointePanel.setBackground(PointageRenderer.getCouleurEcriturePointee());
        ecriturePointePanel.add((Component)new JLabel("Ecritures point\u00e9es"), cPanel);
        panelLegende.add((Component)ecriturePointePanel, c);
        return panelLegende;
    }
}

