/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.Row;
import org.openconcerto.utils.io.JSONConverter;
import org.openconcerto.utils.io.Transferable;

public class TableContent
implements Transferable {
    private static final long serialVersionUID = 3648381615123520834L;
    private String tableId;
    private List<Row> rows;

    public TableContent() {
    }

    public TableContent(String tableId) {
        this.init(tableId, new ArrayList<Row>());
    }

    public TableContent(String tableId, List<Row> rows) {
        this.init(tableId, rows);
    }

    public TableContent(JSONObject json) {
        this.fromJSON(json);
    }

    private final void init(String tableId, List<Row> rows) {
        this.tableId = tableId;
        this.rows = rows;
    }

    public final String getTableId() {
        return this.tableId;
    }

    public final void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public final synchronized Row getRow(int index) {
        return this.rows.get(index);
    }

    public final synchronized int getRowsCount() {
        return this.rows.size();
    }

    public final synchronized boolean addRow(Row row) {
        return this.rows.add(row);
    }

    public final synchronized Row setRow(int index, Row row) {
        return this.rows.set(index, row);
    }

    public final synchronized void insertRow(int index, Row row) {
        this.rows.add(index, row);
    }

    public final synchronized Row removeRow(int index) {
        return this.rows.remove(index);
    }

    public final synchronized boolean removeRow(Row row) {
        return this.rows.remove(row);
    }

    public final synchronized void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public final synchronized void clearRows() {
        this.rows.clear();
    }

    public final synchronized List<Row> getRows() {
        return new ArrayList<Row>(this.rows);
    }

    public synchronized String toString() {
        return "TableContent of " + this.tableId + " lines count : " + this.getRowsCount();
    }

    @Override
    public synchronized JSONObject toJSON() {
        JSONObject result = new JSONObject();
        result.put("class", "TableContent");
        result.put("table-id", this.tableId);
        result.put("rows", JSONConverter.getJSON(this.rows));
        return result;
    }

    @Override
    public synchronized void fromJSON(JSONObject json) {
        this.tableId = JSONConverter.getParameterFromJSON(json, "table-id", String.class);
        JSONArray jsonRows = JSONConverter.getParameterFromJSON(json, "rows", JSONArray.class);
        if (jsonRows != null) {
            ArrayList<Row> listRows = new ArrayList<Row>();
            for (Object o : jsonRows) {
                listRows.add(new Row(JSONConverter.getObjectFromJSON(o, JSONObject.class)));
            }
            this.setRows(listRows);
        }
    }
}

