/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.RowRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.BaseFillSQLRequest;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumns;
import org.openconcerto.sql.view.list.SQLTableModelLinesSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceState;
import org.openconcerto.sql.view.list.search.SearchQueue;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.NumberUtils;

@ThreadSafe
public final class ListSQLLine
implements Comparable<ListSQLLine> {
    private final SQLTableModelLinesSource src;
    @GuardedBy(value="this")
    private SQLRowAccessor row;
    private final Set<RowRef> pks;
    private final SQLTableModelSourceState state;
    private final int id;
    @GuardedBy(value="this")
    private Number order;
    private final BaseFillSQLRequest.OrderValue reqOrderVal;
    @GuardedBy(value="this")
    private List<Object> list;

    public static final int indexFromID(List<ListSQLLine> l, int id) {
        int foundIndex = -1;
        int size = l.size();
        int i = 0;
        while (i < size) {
            int currentID = l.get(i).getID();
            if (currentID == id) {
                foundIndex = i;
                break;
            }
            ++i;
        }
        return foundIndex;
    }

    static final ListSQLLine fromID(List<ListSQLLine> list, int id) {
        int size = list.size();
        int i = 0;
        while (i < size) {
            ListSQLLine line = list.get(i);
            if (line.getID() == id) {
                return line;
            }
            ++i;
        }
        return null;
    }

    ListSQLLine(SQLTableModelLinesSource src, SQLRowValues row, int id, SQLTableModelSourceState state) {
        this.src = src;
        this.setRow(row);
        this.id = id;
        this.state = state;
        boolean isGraph = src.getParent().getKeepMode() == ComboSQLRequest.KeepMode.GRAPH;
        BaseFillSQLRequest.OrderValue orderValue = this.reqOrderVal = isGraph ? null : state.getReq().createOrderValue(row);
        if (isGraph) {
            this.clearCache();
            this.pks = null;
        } else {
            this.list = Collections.emptyList();
            this.loadCache(state.getAllColumns().getAllColumns().size());
            this.setRow(row.asRow());
            HashSet<RowRef> tmpRefs = new HashSet<RowRef>(row.getGraphSize(), 1.0f);
            for (SQLRowValues v : row.getGraph().getItems()) {
                tmpRefs.add(v.getRowRef());
            }
            this.pks = Collections.unmodifiableSet(tmpRefs);
        }
    }

    private void loadCache(int columnCount) {
        this.updateList(columnCount, Collections.emptySet());
    }

    public final SQLTableModelSourceState getState() {
        return this.state;
    }

    public final SQLTableModelColumns getColumns() {
        return this.getState().getAllColumns();
    }

    public final SQLTableModelLinesSource getSrc() {
        return this.src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setRow(SQLRowAccessor v) {
        if (!v.isFrozen()) {
            throw new IllegalArgumentException("Not frozen : " + v);
        }
        ListSQLLine listSQLLine = this;
        synchronized (listSQLLine) {
            this.row = v;
        }
    }

    public final SQLRowValues getRow() {
        return (SQLRowValues)this.getRowAccessor();
    }

    public final synchronized SQLRowAccessor getRowAccessor() {
        return this.row;
    }

    public final Set<RowRef> getPKs() {
        return this.pks;
    }

    @Override
    public int compareTo(ListSQLLine o) {
        if (this.src != o.src) {
            throw new IllegalArgumentException(this.src + " != " + o.src);
        }
        return this.src.compare(this, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int compareLikeRequest(ListSQLLine l1, ListSQLLine l2) {
        Number order2;
        Number order1;
        if (l1 == l2) {
            return 0;
        }
        if (l1.getState() != l2.getState()) {
            throw new IllegalArgumentException("Different states");
        }
        SQLTableModelLinesSource src = l1.getSrc();
        List<ListSQLLine> list = src.getModel().getUpdateQ().getFullList();
        synchronized (list) {
            order1 = l1.getOrder();
            order2 = l2.getOrder();
        }
        if (order1 != null) {
            if (order2 == null) {
                throw new IllegalStateException("Order mismatch :\n" + order1 + " for " + l1 + " not coherent with\n" + order2 + " for " + l2);
            }
            return NumberUtils.compare(order1, order2);
        }
        if (order2 != null) {
            throw new IllegalStateException("Order mismatch :\n" + order1 + " for " + l1 + " not coherent with\n" + order2 + " for " + l2);
        }
        BaseFillSQLRequest.OrderValue orderVal1 = l1.getRequestOrderValue();
        if (orderVal1 != null) {
            BaseFillSQLRequest.OrderValue orderVal2 = l2.getRequestOrderValue();
            return orderVal1.compareTo(orderVal2);
        }
        assert (l2.getRequestOrderValue() == null);
        return l1.getState().getReq().order(l1.getRow(), l2.getRow());
    }

    public int getID() {
        return this.id;
    }

    public final synchronized void setOrder(Number order) {
        this.order = order;
    }

    public final synchronized Number getOrder() {
        return this.order;
    }

    public final BaseFillSQLRequest.OrderValue getRequestOrderValue() {
        return this.reqOrderVal;
    }

    public synchronized List<Object> getList(int columnCount) {
        this.loadCache(columnCount);
        return this.list;
    }

    public Object getValueAt(int column) {
        return this.getList(column + 1).get(column);
    }

    public final void setValueAt(Object obj, int colIndex) {
        this.getColumns().getColumns().get(colIndex).put(this, obj);
    }

    private final Set<Integer> updateValueAt(Set<Integer> colIndexes) {
        if (colIndexes.size() == 0) {
            return colIndexes;
        }
        this.updateList(-1, colIndexes);
        return colIndexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean updateList(int newSize, Set<Integer> colsToUpdate) {
        int minIndexToUpdate;
        if (colsToUpdate.isEmpty()) {
            minIndexToUpdate = -1;
        } else {
            minIndexToUpdate = Collections.min(colsToUpdate);
            if (minIndexToUpdate < 0) {
                throw new IllegalArgumentException("Negative indexes : " + colsToUpdate);
            }
        }
        ListSQLLine listSQLLine = this;
        synchronized (listSQLLine) {
            int alreadyLoaded;
            block9: {
                alreadyLoaded = this.list.size();
                if (newSize < 0) {
                    newSize = alreadyLoaded;
                }
                if (alreadyLoaded < newSize || minIndexToUpdate >= 0 && minIndexToUpdate < alreadyLoaded) break block9;
                return false;
            }
            ArrayList<Object> newList = new ArrayList<Object>(newSize);
            int i = 0;
            while (i < newSize) {
                Object o = i >= alreadyLoaded || colsToUpdate.contains(i) ? this.getColumns().getAllColumns().get(i).show(this.getRow()) : this.list.get(i);
                newList.add(o);
                ++i;
            }
            this.list = Collections.unmodifiableList(newList);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.getSrc().getParent().getKeepMode() != ComboSQLRequest.KeepMode.GRAPH) {
            throw new IllegalStateException("Wouldn't be able to compute cell values");
        }
        ListSQLLine listSQLLine = this;
        synchronized (listSQLLine) {
            this.list = Collections.emptyList();
        }
    }

    synchronized Set<Integer> loadAt(int id, SQLRowValues vals, Path p) {
        assert (vals == null || vals.getID() == id);
        String lastReferentField = SearchQueue.getLastReferentField(p);
        assert (vals != null || lastReferentField != null);
        Set<Integer> indexes = lastReferentField == null ? this.pathToIndex(p, vals.getFields()) : null;
        SQLRowValues copy = this.getRow().deepCopy();
        if (lastReferentField == null) {
            for (SQLRowValues v : copy.followPath(p, SQLRowValues.CreateMode.CREATE_NONE, false)) {
                if (v.getID() != id) continue;
                v.load(vals.deepCopy(), null);
            }
        } else {
            SQLField lastField = p.getStep(-1).getSingleField();
            Collection<SQLRowValues> previous = p.length() > 1 && p.getStep(-2).reverse().equals(p.getStep(-1)) ? copy.followPath(p.minusLast(2), SQLRowValues.CreateMode.CREATE_NONE, false) : null;
            Collection<SQLRowValues> targets = copy.followPath(p.minusLast(), SQLRowValues.CreateMode.CREATE_NONE, false);
            for (SQLRowValues target : targets) {
                SQLRowValues toRemove = null;
                for (SQLRowValues toUpdate : target.getReferentRows(lastField)) {
                    if (previous != null && previous.contains(toUpdate) || toUpdate.getID() != id) continue;
                    if (toRemove != null) {
                        throw new IllegalStateException("Duplicate IDs " + id + " : " + System.identityHashCode(toRemove) + " and " + System.identityHashCode(toUpdate) + "\n" + copy.printGraph());
                    }
                    toRemove = toUpdate;
                }
                if (toRemove != null) {
                    toRemove.remove(lastField.getName());
                }
                if (vals == null || !target.getIDNumber().equals(vals.getForeignIDNumberValue(lastField.getName()).getValue())) continue;
                vals.deepCopy().put(lastField.getName(), (Object)target);
            }
        }
        copy.getGraph().freeze();
        this.setRow(copy);
        if (indexes == null) {
            this.clearCache();
            return null;
        }
        return this.updateValueAt(indexes);
    }

    private Set<Integer> pathToIndex(Path p, Collection<String> modifiedFields) {
        if (ListSQLLine.containsFK(p.getLast(), modifiedFields)) {
            return null;
        }
        HashSet<Integer> res = new HashSet<Integer>();
        Set<FieldPath> modifiedPaths = FieldPath.create(p, modifiedFields);
        List<SQLTableModelColumn> cols = this.getColumns().getAllColumns();
        int i = 0;
        while (i < cols.size()) {
            SQLTableModelColumn col = cols.get(i);
            if (CollectionUtils.containsAny(col.getPaths(), modifiedPaths)) {
                res.add(i);
            }
            ++i;
        }
        return res;
    }

    private static boolean containsFK(SQLTable t, Collection<String> fields) {
        Set<SQLField> ffs = t.getFields(SQLTable.VirtualFields.FOREIGN_KEYS);
        for (String f : fields) {
            if (!ffs.contains(t.getField(f))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " on " + this.getRowAccessor();
    }
}

