/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.ShowAs;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItemNotFound;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.cc.Cookies;
import org.openconcerto.utils.cc.ITransformer;

public final class SQLElementDirectory {
    private final DBSystemRoot systemRoot;
    private final Map<SQLTable, SQLElement> elements;
    private final SetMap<String, SQLTable> tableNames;
    private final SetMap<String, SQLTable> byCode;
    private final SetMap<Class<? extends SQLElement>, SQLTable> byClass;
    private final List<DirectoryListener> listeners;
    private String phrasesPkgName;
    @GuardedBy(value="this")
    private SQLFieldTranslator translator;
    private final ShowAs showAs;
    private final Cookies cookies;

    public SQLElementDirectory(DBSystemRoot systemRoot) {
        this.systemRoot = systemRoot;
        this.elements = new HashMap<SQLTable, SQLElement>();
        this.tableNames = new SetMap();
        this.byCode = new SetMap();
        this.byClass = new SetMap();
        this.listeners = new ArrayList<DirectoryListener>();
        this.phrasesPkgName = null;
        this.showAs = new ShowAs(null);
        this.cookies = new Cookies();
    }

    public final synchronized void destroy() {
        for (SQLElement elem : this.elements.values()) {
            elem.destroy();
        }
    }

    public final ShowAs getShowAs() {
        return this.showAs;
    }

    public final synchronized void setTranslator(SQLFieldTranslator translator) {
        if (translator.getDirectory() != this) {
            throw new IllegalArgumentException("Not for this : " + translator);
        }
        this.translator = translator;
    }

    public final synchronized SQLFieldTranslator getTranslator() {
        return this.translator;
    }

    public final Cookies getCookies() {
        return this.cookies;
    }

    private static <K> SQLTable getSoleTable(SetMap<K, SQLTable> m, K key) throws IllegalArgumentException {
        Object res = m.getNonNull(key);
        if (res.size() > 1) {
            throw new IllegalArgumentException(key + " is not unique: " + CollectionUtils.join(res, ",", new ITransformer<SQLTable, SQLName>(){

                @Override
                public SQLName transformChecked(SQLTable input) {
                    return input.getSQLName();
                }
            }));
        }
        return (SQLTable)CollectionUtils.getSole(res);
    }

    public final synchronized void putAll(SQLElementDirectory o) {
        this.cookies.putAll(o.getCookies());
        for (SQLElement elem : new ArrayList<SQLElement>(o.getElements())) {
            if (this.contains(elem.getTable())) continue;
            this.addSQLElement(elem);
        }
        this.translator.putAll(o.getTranslator());
    }

    public final void addSQLElement(Class<? extends SQLElement> element) {
        this.addSQLElement(element, null);
    }

    public final void addSQLElement(Class<? extends SQLElement> element, DBRoot root) {
        SQLElement newInstance;
        try {
            newInstance = root == null ? element.getConstructor(new Class[0]).newInstance(new Object[0]) : element.getConstructor(DBRoot.class).newInstance(root);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof DBStructureItemNotFound) {
                Log.get().config("ignore inexistent tables: " + e.getCause().getLocalizedMessage());
                return;
            }
            throw new IllegalArgumentException("Constructor failed", e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't use constructor", e);
        }
        this.addSQLElement(newInstance);
    }

    public final synchronized SQLElement addSQLElement(SQLElement elem) {
        if (elem.getTable().getDBSystemRoot() != this.systemRoot) {
            throw new IllegalArgumentException("Not in this system root : " + elem);
        }
        SQLElement res = this.removeSQLElement(elem.getTable());
        this.elements.put(elem.getTable(), elem);
        this.tableNames.add(elem.getTable().getName(), elem.getTable());
        this.byCode.add(elem.getCode(), elem.getTable());
        this.byClass.add(elem.getClass(), elem.getTable());
        ListMap<String, String> sa = elem.getShowAs();
        if (sa != null) {
            for (Map.Entry entry : sa.entrySet()) {
                try {
                    if (entry.getKey() == null) {
                        this.showAs.show(elem.getTable(), (List<String>)((List)entry.getValue()));
                        continue;
                    }
                    this.showAs.show(elem.getTable().getField((String)entry.getKey()), (List<String>)((List)entry.getValue()));
                }
                catch (RuntimeException exn) {
                    throw new IllegalStateException("Couldn't add showAs for " + elem + " : " + entry, exn);
                }
            }
        }
        for (DirectoryListener directoryListener : this.listeners) {
            directoryListener.elementAdded(elem);
        }
        elem.setDirectory(this);
        return res;
    }

    public final synchronized boolean contains(SQLTable t) {
        return this.elements.containsKey(t);
    }

    public final synchronized SQLElement getElement(SQLTable t) {
        return this.elements.get(t);
    }

    public final synchronized SQLElement getElement(String tableName) {
        return this.getElement(SQLElementDirectory.getSoleTable(this.tableNames, tableName));
    }

    public final <S extends SQLElement> S getElement(Class<S> clazz) {
        return this.getElementOfClass(clazz, true);
    }

    public final <S extends SQLElement> S getElementOfClass(Class<S> clazz, boolean allowSubclass) {
        List<S> res = this.getElementsOfClass(clazz, allowSubclass);
        if (res.size() > 1) {
            throw new IllegalArgumentException(clazz + " is not unique: " + res);
        }
        return (S)(res.isEmpty() ? null : (SQLElement)res.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <S extends SQLElement> List<S> getElementsOfClass(Class<S> clazz, boolean allowSubclass) {
        List<Object> res;
        SQLElementDirectory sQLElementDirectory = this;
        synchronized (sQLElementDirectory) {
            if (allowSubclass) {
                res = new ArrayList();
                for (SQLElement elem : this.elements.values()) {
                    if (!clazz.isInstance(elem)) continue;
                    res.add((SQLElement)clazz.cast(elem));
                }
            } else {
                Set tables = (Set)this.byClass.get(clazz);
                if (tables != null) {
                    res = new ArrayList(tables.size());
                    for (SQLTable t : tables) {
                        res.add((SQLElement)clazz.cast(this.getElement(t)));
                    }
                } else {
                    res = Collections.emptyList();
                }
            }
        }
        if (res.isEmpty()) {
            return Collections.emptyList();
        }
        if (res.size() == 1) {
            return Collections.singletonList((SQLElement)res.get(0));
        }
        return Collections.unmodifiableList(res);
    }

    public final synchronized SQLElement getElementForCode(String code) {
        return this.getElement(SQLElementDirectory.getSoleTable(this.byCode, code));
    }

    public final synchronized Set<SQLTable> getTables() {
        return this.getElementsMap().keySet();
    }

    public final synchronized Collection<SQLElement> getElements() {
        return this.getElementsMap().values();
    }

    public final Map<SQLTable, SQLElement> getElementsMap() {
        return Collections.unmodifiableMap(this.elements);
    }

    public synchronized void removeSQLElement(SQLElement elem) {
        if (this.getElement(elem.getTable()) == elem) {
            this.removeSQLElement(elem.getTable());
        }
    }

    public synchronized SQLElement removeSQLElement(SQLTable t) {
        SQLElement elem = this.elements.remove(t);
        if (elem != null) {
            this.tableNames.removeOne(elem.getTable().getName(), elem.getTable());
            this.byCode.removeOne(elem.getCode(), elem.getTable());
            this.byClass.removeOne(elem.getClass(), elem.getTable());
            for (SQLElement otherElem : this.elements.values()) {
                otherElem.resetRelationships();
            }
            elem.setDirectory(null);
            this.showAs.removeTable(elem.getTable());
            for (DirectoryListener dl : this.listeners) {
                dl.elementRemoved(elem);
            }
        }
        return elem;
    }

    public final synchronized void initL18nPackageName(String baseName) {
        if (this.phrasesPkgName != null) {
            throw new IllegalStateException("Already initialized : " + this.getL18nPackageName());
        }
        this.phrasesPkgName = baseName;
    }

    public final synchronized String getL18nPackageName() {
        return this.phrasesPkgName;
    }

    public final synchronized void addListener(DirectoryListener dl) {
        this.listeners.add(dl);
    }

    public final synchronized void removeListener(DirectoryListener dl) {
        this.listeners.remove(dl);
    }

    public static interface DirectoryListener {
        public void elementAdded(SQLElement var1);

        public void elementRemoved(SQLElement var1);
    }
}

