/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.checks.EmptyObjFromVO;

public abstract class SQLRowValuesMap<T> {
    private final SQLTable t;
    private final Map<SQLRowValues, SQLRow> map;
    private final IPredicate<? super T> emptyPredicate;

    public SQLRowValuesMap(SQLTable t) {
        this(t, EmptyObjFromVO.getDefaultPredicate());
    }

    public SQLRowValuesMap(SQLTable t, IPredicate<? super T> emptyPredicate) {
        this.t = t;
        this.map = new HashMap<SQLRowValues, SQLRow>();
        this.emptyPredicate = emptyPredicate;
    }

    protected abstract void fill(SQLRowValues var1, T var2);

    public final Object getValue(T obj) throws SQLException {
        if (this.emptyPredicate.evaluateChecked(obj)) {
            return SQLRowValues.SQL_EMPTY_LINK;
        }
        SQLRowValues key = new SQLRowValues(this.t);
        this.fill(key, obj);
        SQLRow res = this.map.get(key);
        if (res == null) {
            res = key.insert();
            this.map.put(key, res);
        }
        return res.getIDNumber();
    }
}

