/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.product.component;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.CodeFournisseurItemTable;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.preferences.DefaultProps;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class ArticleFournisseurSQLComponent
extends BaseSQLComponent {
    private JTextField textPVHT;
    private JTextField textPVTTC;
    private JTextField textPAHT;
    private JTextField textMetrique1VT;
    private JTextField textMetrique1HA;
    private final JCheckBox boxService = new JCheckBox(this.getLabelFor("SERVICE"));
    private final JCheckBox checkObs = new JCheckBox(this.getLabelFor("OBSOLETE"));
    private JTextField textNom;
    private JTextField textCode;
    private JTextField textPoids;
    private JTextField textValMetrique1;
    private JTextField textValMetrique2;
    private JTextField textValMetrique3;
    private DocumentListener htDocListener;
    private DocumentListener ttcDocListener;
    private DocumentListener detailsListener;
    private PropertyChangeListener propertyChangeListener;
    private PropertyChangeListener taxeListener;
    private final ElementComboBox comboSelTaxe = new ElementComboBox(false, 10);
    private final ElementComboBox comboSelModeVente = new ElementComboBox(false, 25);
    private JLabel labelMetriqueHA1 = new JLabel(this.getLabelFor("PRIX_METRIQUE_HA_1"), 4);
    private JLabel labelMetriqueVT1 = new JLabel(this.getLabelFor("PRIX_METRIQUE_VT_1"), 4);
    private final JTextField textMarge = new JTextField(15);
    private DocumentListener pieceHAArticle = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            ArticleFournisseurSQLComponent.this.textMetrique1HA.setText(ArticleFournisseurSQLComponent.this.textPAHT.getText());
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            ArticleFournisseurSQLComponent.this.textMetrique1HA.setText(ArticleFournisseurSQLComponent.this.textPAHT.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            ArticleFournisseurSQLComponent.this.textMetrique1HA.setText(ArticleFournisseurSQLComponent.this.textPAHT.getText());
        }
    };
    private DocumentListener pieceVTArticle = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            ArticleFournisseurSQLComponent.this.textMetrique1VT.setText(ArticleFournisseurSQLComponent.this.textPVHT.getText());
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            ArticleFournisseurSQLComponent.this.textMetrique1VT.setText(ArticleFournisseurSQLComponent.this.textPVHT.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            ArticleFournisseurSQLComponent.this.textMetrique1VT.setText(ArticleFournisseurSQLComponent.this.textPVHT.getText());
        }
    };
    private DocumentListener listenerMargeTextMarge = new SimpleDocumentListener(){

        @Override
        public void update(DocumentEvent e) {
            ArticleFournisseurSQLComponent.this.textPVHT.getDocument().removeDocumentListener(ArticleFournisseurSQLComponent.this.listenerMargeTextVT);
            ArticleFournisseurSQLComponent.this.updateVtFromMarge();
            ArticleFournisseurSQLComponent.this.textPVHT.getDocument().addDocumentListener(ArticleFournisseurSQLComponent.this.listenerMargeTextVT);
        }
    };
    private DocumentListener listenerMargeTextVT = new SimpleDocumentListener(){

        @Override
        public void update(DocumentEvent e) {
            ArticleFournisseurSQLComponent.this.textMarge.getDocument().removeDocumentListener(ArticleFournisseurSQLComponent.this.listenerMargeTextMarge);
            if (ArticleFournisseurSQLComponent.this.textPVHT.getText().trim().length() > 0 && ArticleFournisseurSQLComponent.this.textPAHT.getText().trim().length() > 0) {
                BigDecimal vt = StringUtils.getBigDecimalFromUserText(ArticleFournisseurSQLComponent.this.textPVHT.getText());
                BigDecimal ha = StringUtils.getBigDecimalFromUserText(ArticleFournisseurSQLComponent.this.textPAHT.getText());
                if (vt != null && ha != null && vt.signum() != 0 && ha.signum() != 0) {
                    BigDecimal margeHT = vt.subtract(ha);
                    BigDecimal value = DefaultNXProps.getInstance().getBooleanValue(TotalPanel.MARGE_MARQUE, false) ? (vt.compareTo(BigDecimal.ZERO) > 0 ? margeHT.divide(vt, DecimalUtils.HIGH_PRECISION).multiply(BigDecimal.valueOf(100L), DecimalUtils.HIGH_PRECISION) : BigDecimal.ZERO) : margeHT.divide(ha, DecimalUtils.HIGH_PRECISION).multiply(BigDecimal.valueOf(100L), DecimalUtils.HIGH_PRECISION);
                    if (value.compareTo(BigDecimal.ZERO) > 0) {
                        ArticleFournisseurSQLComponent.this.textMarge.setText(value.setScale(6, RoundingMode.HALF_UP).toString());
                    } else {
                        ArticleFournisseurSQLComponent.this.textMarge.setText("0");
                    }
                }
            }
            ArticleFournisseurSQLComponent.this.textMarge.getDocument().addDocumentListener(ArticleFournisseurSQLComponent.this.listenerMargeTextMarge);
        }
    };
    private DocumentListener listenerMargeTextHA = new SimpleDocumentListener(){

        @Override
        public void update(DocumentEvent e) {
            ArticleFournisseurSQLComponent.this.textPVHT.getDocument().removeDocumentListener(ArticleFournisseurSQLComponent.this.listenerMargeTextVT);
            ArticleFournisseurSQLComponent.this.updateVtFromMarge();
            ArticleFournisseurSQLComponent.this.textPVHT.getDocument().addDocumentListener(ArticleFournisseurSQLComponent.this.listenerMargeTextVT);
        }
    };
    private SQLRowValues rowValuesDefaultCodeFournisseur;
    private CodeFournisseurItemTable codeFournisseurTable;

    private void updateVtFromMarge() {
        BigDecimal ha;
        if (this.textPAHT.getText().trim().length() > 0 && (ha = StringUtils.getBigDecimalFromUserText(this.textPAHT.getText())) != null && this.textMarge.getText().trim().length() > 0) {
            BigDecimal d = StringUtils.getBigDecimalFromUserText(this.textMarge.getText());
            if (DefaultNXProps.getInstance().getBooleanValue(TotalPanel.MARGE_MARQUE, false)) {
                BigDecimal e = BigDecimal.ONE.subtract(d.divide(BigDecimal.valueOf(100L), DecimalUtils.HIGH_PRECISION));
                if (e.signum() == 0) {
                    this.textPVHT.setText("0");
                } else {
                    this.textPVHT.setText(ha.divide(e, DecimalUtils.HIGH_PRECISION).setScale((int)this.getTable().getField("PV_HT").getType().getDecimalDigits(), RoundingMode.HALF_UP).toString());
                }
            } else {
                BigDecimal result = ha.multiply(d.divide(BigDecimal.valueOf(100L), DecimalUtils.HIGH_PRECISION).add(BigDecimal.ONE));
                this.textPVHT.setText(result.setScale((int)this.getTable().getField("PV_HT").getType().getDecimalDigits(), RoundingMode.HALF_UP).toString());
            }
        }
    }

    public ArticleFournisseurSQLComponent(SQLElement elt) {
        super(elt);
    }

    @Override
    public void select(SQLRowAccessor r) {
        super.select(r);
        if (r != null && r.getID() > this.getTable().getUndefinedID()) {
            this.checkObs.setVisible(true);
            if (this.codeFournisseurTable != null) {
                this.codeFournisseurTable.insertFrom("ID_ARTICLE", r.getID());
            }
        }
    }

    @Override
    public void addViews() {
        DefaultProps props;
        String modeVente;
        Boolean bModeVente;
        boolean modeVenteAvance;
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.textPVHT = new JTextField(15);
        this.textPVTTC = new JTextField(15);
        this.textPAHT = new JTextField(15);
        this.textPVHT.getDocument().addDocumentListener(this.listenerMargeTextVT);
        this.textMetrique1HA = new JTextField(15);
        this.textMetrique1VT = new JTextField(15);
        this.textValMetrique1 = new JTextField(15);
        this.textValMetrique2 = new JTextField(15);
        this.textValMetrique3 = new JTextField(15);
        this.textCode = new JTextField();
        this.textNom = new JTextField();
        this.textPoids = new JTextField(6);
        JLabel codelabel = new JLabel(this.getLabelFor("CODE"));
        codelabel.setHorizontalAlignment(4);
        DefaultGridBagConstraints.lockMinimumSize(codelabel);
        this.add((Component)codelabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        DefaultGridBagConstraints.lockMinimumSize(this.textCode);
        this.add((Component)this.textCode, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 0.0;
        JLabel labelFamille = new JLabel(this.getLabelFor("ID_FAMILLE_ARTICLE_FOURNISSEUR"));
        labelFamille.setHorizontalAlignment(4);
        DefaultGridBagConstraints.lockMinimumSize(labelFamille);
        this.add((Component)labelFamille, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        ElementComboBox comboSelFamille = new ElementComboBox(false, 25);
        this.addSQLObject(comboSelFamille, "ID_FAMILLE_ARTICLE_FOURNISSEUR");
        DefaultGridBagConstraints.lockMinimumSize(comboSelFamille);
        this.add((Component)comboSelFamille, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
        labelNom.setHorizontalAlignment(4);
        DefaultGridBagConstraints.lockMinimumSize(labelNom);
        this.add((Component)labelNom, c);
        ++c.gridx;
        c.weightx = 1.0;
        DefaultGridBagConstraints.lockMinimumSize(this.textNom);
        this.add((Component)this.textNom, c);
        ++c.gridx;
        c.weightx = 0.0;
        JLabel labelCodeBarre = new JLabel(this.getLabelFor("CODE_BARRE"));
        labelCodeBarre.setHorizontalAlignment(4);
        DefaultGridBagConstraints.lockMinimumSize(labelCodeBarre);
        this.add((Component)labelCodeBarre, c);
        ++c.gridx;
        c.weightx = 1.0;
        JTextField fieldCodeBarre = new JTextField();
        DefaultGridBagConstraints.lockMinimumSize(fieldCodeBarre);
        this.add((Component)fieldCodeBarre, c);
        this.addView(fieldCodeBarre, "CODE_BARRE");
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        boolean gestionUV = prefs.getBoolean(GestionArticleGlobalPreferencePanel.UNITE_VENTE, true);
        if (gestionUV) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("ID_UNITE_VENTE"), 4), c);
            ++c.gridx;
            c.weightx = 1.0;
            c.fill = 0;
            ElementComboBox boxUnite = new ElementComboBox();
            DefaultGridBagConstraints.lockMinimumSize(boxUnite);
            this.add((Component)boxUnite, c);
            this.addView(boxUnite, "ID_UNITE_VENTE");
            c.fill = 2;
        }
        boolean bl = modeVenteAvance = (bModeVente = Boolean.valueOf(modeVente = (props = DefaultNXProps.getInstance()).getStringProperty("ArticleModeVenteAvance"))) == null || bModeVente != false;
        if (modeVenteAvance) {
            this.addModeVenteAvance(c);
        }
        this.getMontantPanel(c, props);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        this.add((Component)addP, c);
        JTabbedPane pane = new JTabbedPane();
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        pane.add("Tarifs de vente", this.createTarifPanel());
        pane.add("Exportation", this.createExportationPanel());
        pane.add("Achat", this.createAchatPanel());
        pane.add("Stock", this.createStockPanel());
        pane.add("Descriptif", this.createDescriptifPanel());
        pane.add("D\u00e9signations multilingues", this.createDesignationPanel());
        pane.add("Comptabilit\u00e9", this.createComptaPanel());
        pane.add(this.getLabelFor("INFOS"), this.createInfosPanel());
        c.fill = 1;
        this.add((Component)pane, c);
        this.addSQLObject(this.textMetrique1HA, "PRIX_METRIQUE_HA_1");
        this.addSQLObject(this.textMetrique1VT, "PRIX_METRIQUE_VT_1");
        this.addSQLObject(this.textValMetrique1, "VALEUR_METRIQUE_1");
        this.addSQLObject(this.textValMetrique2, "VALEUR_METRIQUE_2");
        this.addSQLObject(this.textValMetrique3, "VALEUR_METRIQUE_3");
        this.addSQLObject(this.comboSelModeVente, "ID_MODE_VENTE_ARTICLE");
        this.addSQLObject(this.boxService, "SERVICE");
        this.addRequiredSQLObject(this.textNom, "NOM");
        this.addRequiredSQLObject(this.textCode, "CODE");
        this.addSQLObject(this.textPoids, "POIDS");
        this.comboSelTaxe.setButtonsVisible(false);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println(ArticleFournisseurSQLComponent.this.comboSelModeVente.getSelectedId());
                ArticleFournisseurSQLComponent.this.selectModeVente(ArticleFournisseurSQLComponent.this.comboSelModeVente.getSelectedId());
            }
        };
        this.setListenerModeVenteActive(true);
        this.comboSelModeVente.setValue(5);
    }

    private Component createInfosPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        ITextArea infos = new ITextArea();
        c.fill = 1;
        panel.add((Component)infos, c);
        this.addSQLObject(infos, "INFOS");
        return panel;
    }

    private Component createDescriptifPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.checkObs.setOpaque(false);
        panel.add((Component)this.checkObs, c);
        this.checkObs.setVisible(false);
        this.addView(this.checkObs, "OBSOLETE");
        if (this.getTable().getFieldsName().contains("COLORIS")) {
            JTextField fieldColoris = new JTextField();
            ++c.gridy;
            c.fill = 2;
            c.weightx = 0.0;
            c.gridwidth = 1;
            panel.add((Component)new JLabel(this.getLabelFor("COLORIS")), c);
            c.weightx = 1.0;
            ++c.gridx;
            panel.add((Component)fieldColoris, c);
            this.addView(fieldColoris, "COLORIS");
        }
        ITextArea area = new ITextArea();
        JLabel sep = new JLabel("Descriptif complet");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        c.fill = 2;
        panel.add((Component)sep, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)area, c);
        this.addView(area, "DESCRIPTIF");
        return panel;
    }

    private Component createDesignationPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        panel.add((Component)new JLabel("Ajouter une d\u00e9signation "), c);
        ElementComboBox boxDes = new ElementComboBox();
        boxDes.init(Configuration.getInstance().getDirectory().getElement("LANGUE"));
        ++c.gridx;
        panel.add((Component)boxDes, c);
        c.fill = 0;
        ++c.gridx;
        JButton buttonAjouterDes = new JButton("Ajouter");
        buttonAjouterDes.setOpaque(false);
        panel.add((Component)buttonAjouterDes, c);
        ++c.gridx;
        JButton buttonSupprimerDes = new JButton("Supprimer");
        buttonSupprimerDes.setOpaque(false);
        panel.add((Component)buttonSupprimerDes, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        return panel;
    }

    private Component createStockPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        boolean gestionStockMin = prefs.getBoolean(GestionArticleGlobalPreferencePanel.WARNING_STOCK_MIN, true);
        c.gridx = 0;
        ++c.gridy;
        final JCheckBox boxStock = new JCheckBox(this.getLabelFor("GESTION_STOCK"));
        boxStock.setOpaque(false);
        panel.add((Component)boxStock, c);
        this.addView(boxStock, "GESTION_STOCK");
        final JTextField fieldQteMin = new JTextField();
        final JTextField fieldQteAchat = new JTextField();
        boxStock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fieldQteMin.setEnabled(boxStock.isSelected());
                fieldQteAchat.setEnabled(boxStock.isSelected());
            }
        });
        c.gridwidth = 1;
        if (gestionStockMin) {
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            panel.add((Component)new JLabel(this.getLabelFor("QTE_ACHAT")), c);
            ++c.gridx;
            c.weightx = 1.0;
            panel.add((Component)fieldQteAchat, c);
            this.addView(fieldQteAchat, "QTE_ACHAT");
        }
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        panel.add((Component)spacer, c);
        return panel;
    }

    private Component createComptaPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        ISQLCompteSelector sel = new ISQLCompteSelector();
        c.fill = 1;
        panel.add((Component)new JLabel(this.getLabelFor("ID_COMPTE_PCE")), c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add((Component)sel, c);
        this.addView(sel, "ID_COMPTE_PCE");
        c.gridwidth = 1;
        ++c.gridy;
        c.weighty = 0.0;
        c.gridx = 0;
        c.weightx = 0.0;
        ISQLCompteSelector selAchat = new ISQLCompteSelector();
        c.fill = 1;
        panel.add((Component)new JLabel(this.getLabelFor("ID_COMPTE_PCE_ACHAT")), c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add((Component)selAchat, c);
        this.addView(selAchat, "ID_COMPTE_PCE_ACHAT");
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        panel.add((Component)spacer, c);
        return panel;
    }

    private Component createAchatPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        JLabel labelFournisseur = new JLabel(this.getLabelFor("ID_FOURNISSEUR"));
        labelFournisseur.setHorizontalAlignment(4);
        panel.add((Component)labelFournisseur, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        final ElementComboBox comboSelFournisseur = new ElementComboBox(false, 25);
        panel.add((Component)comboSelFournisseur, c);
        this.addView(comboSelFournisseur, "ID_FOURNISSEUR");
        SQLPreferences prefs = new SQLPreferences(ComptaPropsConfiguration.getInstanceCompta().getRootSociete());
        boolean supplierCode = prefs.getBoolean(GestionArticleGlobalPreferencePanel.SUPPLIER_PRODUCT_CODE, false);
        if (this.getTable().getSchema().contains("CODE_FOURNISSEUR") && supplierCode) {
            this.rowValuesDefaultCodeFournisseur = new SQLRowValues(this.getTable().getTable("CODE_FOURNISSEUR"));
            this.codeFournisseurTable = new CodeFournisseurItemTable(this.rowValuesDefaultCodeFournisseur);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 3;
            c.weighty = 1.0;
            c.weightx = 1.0;
            c.fill = 1;
            panel.add((Component)this.codeFournisseurTable, c);
            comboSelFournisseur.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ArticleFournisseurSQLComponent.this.rowValuesDefaultCodeFournisseur.put("ID_FOURNISSEUR", comboSelFournisseur.getSelectedId());
                }
            });
        } else {
            ++c.gridy;
            c.weighty = 1.0;
            c.weightx = 1.0;
            c.fill = 1;
            JPanel spacer = new JPanel();
            spacer.setOpaque(false);
            panel.add((Component)spacer, c);
        }
        return panel;
    }

    private JPanel createExportationPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridwidth = 1;
        JLabel labelCodeD = new JLabel(this.getLabelFor("CODE_DOUANIER"));
        labelCodeD.setHorizontalAlignment(4);
        panel.add((Component)labelCodeD, c);
        ++c.gridx;
        JTextField fieldCodeDouanier = new JTextField();
        c.weightx = 1.0;
        panel.add((Component)fieldCodeDouanier, c);
        this.addView(fieldCodeDouanier, "CODE_DOUANIER");
        ++c.gridx;
        c.weightx = 0.0;
        JLabel labelPays = new JLabel(this.getLabelFor("ID_PAYS"));
        labelPays.setHorizontalAlignment(4);
        panel.add((Component)labelPays, c);
        ++c.gridx;
        c.weightx = 1.0;
        ElementComboBox comboSelPays = new ElementComboBox(false);
        panel.add((Component)comboSelPays, c);
        this.addView(comboSelPays, "ID_PAYS");
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        panel.add((Component)spacer, c);
        return panel;
    }

    private JPanel createTarifPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        panel.add((Component)new JLabel("Ajouter le tarif "), c);
        return panel;
    }

    protected void getMontantPanel(GridBagConstraints c, DefaultProps props) {
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        JPanel pDevise = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cDevise = new DefaultGridBagConstraints();
        cDevise.insets = new Insets(0, 0, 0, 4);
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Devise du fournisseur"), c);
        final ElementComboBox boxDevise = new ElementComboBox(true, 15);
        ++cDevise.gridx;
        cDevise.weightx = 1.0;
        pDevise.add((Component)boxDevise, cDevise);
        this.addView(boxDevise, "ID_DEVISE_HA");
        DefaultGridBagConstraints.lockMinimumSize(boxDevise);
        cDevise.weightx = 0.0;
        ++cDevise.gridx;
        pDevise.add((Component)new JLabel("Prix d'achat devise"), cDevise);
        final JTextField fieldHAD = new JTextField(15);
        cDevise.weightx = 1.0;
        ++cDevise.gridx;
        pDevise.add((Component)fieldHAD, cDevise);
        this.addView(fieldHAD, "PA_DEVISE");
        DefaultGridBagConstraints.lockMinimumSize(fieldHAD);
        ++c.gridx;
        c.gridwidth = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)pDevise, c);
        fieldHAD.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                if (!ArticleFournisseurSQLComponent.this.isFilling() && boxDevise != null && boxDevise.getSelectedRow() != null && !boxDevise.getSelectedRow().isUndefined()) {
                    BigDecimal ha = StringUtils.getBigDecimalFromUserText(fieldHAD.getText());
                    if (ha == null) {
                        ha = BigDecimal.ZERO;
                    }
                    String devCode = boxDevise.getSelectedRow().getString("CODE");
                    CurrencyConverter c = new CurrencyConverter();
                    ArticleFournisseurSQLComponent.this.textPAHT.setText(c.convert(ha, devCode, c.getCompanyCurrencyCode(), new Date(), true).setScale((int)ArticleFournisseurSQLComponent.this.getTable().getField("PA_DEVISE").getType().getDecimalDigits(), RoundingMode.HALF_UP).toString());
                }
            }
        });
        JPanel p = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cAchat = new DefaultGridBagConstraints();
        cAchat.insets = new Insets(0, 0, 0, 4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("PA_HT"), 4), c);
        ++cAchat.gridx;
        cAchat.weightx = 1.0;
        p.add((Component)this.textPAHT, cAchat);
        this.textPAHT.getDocument().addDocumentListener(this.listenerMargeTextHA);
        ++cAchat.gridx;
        cAchat.weightx = 0.0;
        p.add((Component)new JLabel("Marge"), cAchat);
        cAchat.weightx = 1.0;
        ++cAchat.gridx;
        p.add((Component)this.textMarge, cAchat);
        this.textMarge.getDocument().addDocumentListener(this.listenerMargeTextMarge);
        ++cAchat.gridx;
        cAchat.weightx = 0.0;
        p.add((Component)new JLabel("%           "), cAchat);
        JLabel labelPds = new JLabel(this.getLabelFor("POIDS"));
        ++cAchat.gridx;
        cAchat.weightx = 0.0;
        p.add((Component)labelPds, cAchat);
        labelPds.setHorizontalAlignment(4);
        cAchat.weightx = 1.0;
        ++cAchat.gridx;
        p.add((Component)this.textPoids, cAchat);
        DefaultGridBagConstraints.lockMinimumSize(this.textPoids);
        String sService = props.getStringProperty("ArticleService");
        Boolean bService = Boolean.valueOf(sService);
        if (bService != null && bService.booleanValue()) {
            ++cAchat.gridx;
            cAchat.weightx = 0.0;
            p.add((Component)this.boxService, cAchat);
        }
        ++c.gridx;
        c.gridwidth = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)p, c);
        c.gridx = 0;
        ++c.gridy;
        JPanel p2 = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cVT = new DefaultGridBagConstraints();
        cVT.insets = new Insets(0, 0, 0, 4);
        c.weightx = 0.0;
        c.fill = 2;
        c.gridwidth = 1;
        this.add((Component)new JLabel(this.getLabelFor("PV_HT"), 4), c);
        ++cVT.gridx;
        cVT.weightx = 1.0;
        p2.add((Component)this.textPVHT, cVT);
        JLabel labelTaxe = new JLabel(this.getLabelFor("ID_TAXE"));
        ++cVT.gridx;
        cVT.weightx = 0.0;
        p2.add((Component)labelTaxe, cVT);
        labelTaxe.setHorizontalAlignment(4);
        ++cVT.gridx;
        p2.add((Component)this.comboSelTaxe, cVT);
        ++cVT.gridx;
        cVT.weightx = 0.0;
        p2.add((Component)new JLabel(this.getLabelFor("PV_TTC")), cVT);
        ++cVT.gridx;
        cVT.weightx = 1.0;
        p2.add((Component)this.textPVTTC, cVT);
        c.gridx = 1;
        c.gridwidth = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)p2, c);
        this.addRequiredSQLObject(this.textPAHT, "PA_HT");
        this.addRequiredSQLObject(this.textPVHT, "PV_HT");
        DefaultGridBagConstraints.lockMinimumSize(this.textPVHT);
        this.addRequiredSQLObject(this.comboSelTaxe, "ID_TAXE");
        DefaultGridBagConstraints.lockMinimumSize(this.comboSelTaxe);
        DefaultGridBagConstraints.lockMaximumSize(this.comboSelTaxe);
        this.addRequiredSQLObject(this.textPVTTC, "PV_TTC");
        DefaultGridBagConstraints.lockMinimumSize(this.textPVTTC);
        DefaultGridBagConstraints.lockMinimumSize(this.textPAHT);
        DefaultGridBagConstraints.lockMinimumSize(this.textMarge);
        this.ttcDocListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ArticleFournisseurSQLComponent.this.setTextHT();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ArticleFournisseurSQLComponent.this.setTextHT();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ArticleFournisseurSQLComponent.this.setTextHT();
            }
        };
        this.htDocListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ArticleFournisseurSQLComponent.this.setTextTTC();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ArticleFournisseurSQLComponent.this.setTextTTC();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ArticleFournisseurSQLComponent.this.setTextTTC();
            }
        };
        this.detailsListener = new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                ArticleFournisseurSQLComponent.this.updatePiece();
            }
        };
        this.taxeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (ArticleFournisseurSQLComponent.this.textPVHT.getText().trim().length() > 0) {
                    ArticleFournisseurSQLComponent.this.setTextTTC();
                } else {
                    ArticleFournisseurSQLComponent.this.setTextHT();
                }
            }
        };
        this.textPVHT.getDocument().addDocumentListener(this.htDocListener);
        this.textPVTTC.getDocument().addDocumentListener(this.ttcDocListener);
        this.comboSelTaxe.addValueListener(this.taxeListener);
        this.textMetrique1HA.getDocument().addDocumentListener(this.detailsListener);
        this.textMetrique1VT.getDocument().addDocumentListener(this.detailsListener);
        this.textValMetrique1.getDocument().addDocumentListener(this.detailsListener);
        this.textValMetrique2.getDocument().addDocumentListener(this.detailsListener);
        this.textValMetrique3.getDocument().addDocumentListener(this.detailsListener);
    }

    private void setListenerModeVenteActive(boolean b) {
        if (b) {
            this.comboSelModeVente.addValueListener(this.propertyChangeListener);
        } else {
            this.comboSelModeVente.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void addModeVenteAvance(GridBagConstraints c) {
        DefaultProps props = DefaultNXProps.getInstance();
        JSeparator sep = new JSeparator();
        JLabel labelDetails = new JLabel("Article d\u00e9taill\u00e9", 4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelDetails, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)sep, c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel(this.getLabelFor("ID_MODE_VENTE_ARTICLE"), 4), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.add((Component)this.comboSelModeVente, c);
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridy;
        this.add((Component)this.labelMetriqueHA1, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textMetrique1HA, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)this.labelMetriqueVT1, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textMetrique1VT, c);
        c.weightx = 0.0;
        JLabel labelMetrique1 = new JLabel(this.getLabelFor("VALEUR_METRIQUE_1"), 4);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)labelMetrique1, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textValMetrique1, c);
        ++c.gridx;
        c.weightx = 0.0;
        Boolean bMetrique1 = Boolean.valueOf(props.getStringProperty("ArticleLongueur"));
        labelMetrique1.setVisible(bMetrique1 == null || bMetrique1 != false);
        this.textValMetrique1.setVisible(bMetrique1 == null || bMetrique1 != false);
        JLabel labelMetrique2 = new JLabel(this.getLabelFor("VALEUR_METRIQUE_2"), 4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelMetrique2, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textValMetrique2, c);
        ++c.gridx;
        c.weightx = 0.0;
        Boolean bMetrique2 = Boolean.valueOf(props.getStringProperty("ArticleLargeur"));
        labelMetrique2.setVisible(bMetrique2 == null || bMetrique2 != false);
        this.textValMetrique2.setVisible(bMetrique2 == null || bMetrique2 != false);
        JLabel labelMetrique3 = new JLabel(this.getLabelFor("VALEUR_METRIQUE_3"), 4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelMetrique3, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textValMetrique3, c);
        ++c.gridx;
        Boolean bMetrique3 = Boolean.valueOf(props.getStringProperty("ArticlePoids"));
        labelMetrique3.setVisible(bMetrique3 == null || bMetrique3 != false);
        this.textValMetrique3.setVisible(bMetrique3 == null || bMetrique3 != false);
        JSeparator sep2 = new JSeparator();
        JLabel labelPiece = new JLabel("Article pi\u00e8ce", 4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelPiece, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)sep2, c);
    }

    @Override
    public void update() {
        super.update();
        if (this.codeFournisseurTable != null) {
            this.codeFournisseurTable.updateField("ID_ARTICLE", this.getSelectedID());
        }
    }

    private void selectModeVente(int id) {
        this.labelMetriqueHA1.setEnabled(true);
        this.labelMetriqueVT1.setEnabled(true);
        this.textMetrique1HA.setEnabled(true);
        this.textMetrique1VT.setEnabled(true);
        this.textPAHT.getDocument().removeDocumentListener(this.pieceHAArticle);
        this.textPVHT.getDocument().removeDocumentListener(this.pieceVTArticle);
        switch (id) {
            case 3: {
                this.labelMetriqueHA1.setText("Prix d'achat HT au m\u00e8tre carr\u00e9");
                this.labelMetriqueVT1.setText("Prix de vente HT au m\u00e8tre carr\u00e9");
                break;
            }
            case 2: 
            case 6: {
                this.labelMetriqueHA1.setText("Prix d'achat HT au m\u00e8tre");
                this.labelMetriqueVT1.setText("Prix de vente HT au m\u00e8tre");
                break;
            }
            case 4: {
                this.labelMetriqueHA1.setText("Prix d'achat HT au kilo");
                this.labelMetriqueVT1.setText("Prix de vente HT au kilo");
                break;
            }
            default: {
                this.labelMetriqueHA1.setEnabled(false);
                this.labelMetriqueVT1.setEnabled(false);
                this.textMetrique1HA.setEnabled(false);
                this.textMetrique1VT.setEnabled(false);
                this.textMetrique1HA.setText(this.textPAHT.getText().trim());
                this.textMetrique1VT.setText(this.textPVHT.getText().trim());
                this.textPAHT.getDocument().addDocumentListener(this.pieceHAArticle);
                this.textPVHT.getDocument().addDocumentListener(this.pieceVTArticle);
            }
        }
    }

    @Override
    public int insert(SQLRow order) {
        int id = super.insert(order);
        if (this.codeFournisseurTable != null) {
            this.codeFournisseurTable.updateField("ID_ARTICLE", id);
        }
        return id;
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        SQLRow row = this.getTable().getRow(this.getTable().getUndefinedID());
        rowVals.put("ID_TAXE", row.getInt("ID_TAXE"));
        rowVals.put("ID_UNITE_VENTE", 2);
        rowVals.put("ID_MODE_VENTE_ARTICLE", 5);
        this.selectModeVente(5);
        rowVals.put("VALEUR_METRIQUE_1", Float.valueOf("1.0"));
        rowVals.put("PA_HT", BigDecimal.ZERO);
        rowVals.put("POIDS", Float.valueOf(0.0f));
        return rowVals;
    }

    private void setTextHT() {
        int id;
        this.textPVHT.getDocument().removeDocumentListener(this.htDocListener);
        BigDecimal ttc = StringUtils.getBigDecimalFromUserText(this.textPVTTC.getText());
        if (ttc != null && (id = this.comboSelTaxe.getSelectedId()) > 1) {
            Float resultTaux = TaxeCache.getCache().getTauxFromId(id);
            float taux = resultTaux == null ? 0.0f : resultTaux.floatValue() / 100.0f;
            this.textPVHT.setText(ttc.divide(BigDecimal.valueOf(taux).add(BigDecimal.ONE), DecimalUtils.HIGH_PRECISION).setScale((int)this.getTable().getField("PV_HT").getType().getDecimalDigits(), RoundingMode.HALF_UP).toString());
        }
        this.textPVHT.getDocument().addDocumentListener(this.htDocListener);
    }

    private void setTextTTC() {
        int id;
        this.textPVTTC.getDocument().removeDocumentListener(this.ttcDocListener);
        BigDecimal ht = StringUtils.getBigDecimalFromUserText(this.textPVHT.getText());
        if (ht != null && (id = this.comboSelTaxe.getSelectedId()) > 1) {
            Float resultTaux = TaxeCache.getCache().getTauxFromId(id);
            float taux = resultTaux == null ? 0.0f : resultTaux.floatValue() / 100.0f;
            this.textPVTTC.setText(ht.multiply(BigDecimal.valueOf(taux).add(BigDecimal.ONE), DecimalUtils.HIGH_PRECISION).setScale((int)this.getTable().getField("PV_TTC").getType().getDecimalDigits(), RoundingMode.HALF_UP).toString());
        }
        this.textPVTTC.getDocument().addDocumentListener(this.ttcDocListener);
    }

    private void updatePiece() {
        if (this.comboSelModeVente.getSelectedId() > 1 && this.comboSelModeVente.getSelectedId() != 5) {
            SQLRowValues rowVals = this.getDetailsRowValues();
            float poidsTot = ReferenceArticleSQLElement.getPoidsFromDetails(rowVals);
            this.textPoids.setText(String.valueOf(poidsTot));
            this.textPAHT.setText(ReferenceArticleSQLElement.getPrixHAFromDetails(rowVals).setScale((int)this.getTable().getField("PA_HT").getType().getDecimalDigits(), RoundingMode.HALF_UP).toString());
            this.textPVHT.setText(ReferenceArticleSQLElement.getPrixVTFromDetails(rowVals).setScale((int)this.getTable().getField("PV_HT").getType().getDecimalDigits(), RoundingMode.HALF_UP).toString());
        }
    }

    public int getSelectedTaxe() {
        return this.comboSelTaxe.getSelectedId();
    }

    public SQLRowValues getDetailsRowValues() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        BigDecimal pAchat = StringUtils.getBigDecimalFromUserText(this.textMetrique1HA.getText());
        if (pAchat == null) {
            pAchat = BigDecimal.ZERO;
        }
        rowVals.put("PRIX_METRIQUE_HA_1", pAchat);
        BigDecimal pVente = StringUtils.getBigDecimalFromUserText(this.textMetrique1VT.getText());
        if (pVente == null) {
            pVente = BigDecimal.ZERO;
        }
        rowVals.put("PRIX_METRIQUE_VT_1", pVente);
        this.put(rowVals, this.textValMetrique1);
        this.put(rowVals, this.textValMetrique2);
        this.put(rowVals, this.textValMetrique3);
        rowVals.put("ID_MODE_VENTE_ARTICLE", this.comboSelModeVente.getSelectedId());
        return rowVals;
    }

    private void put(SQLRowValues rowVals, JTextField comp) {
        Float f = Float.valueOf(comp.getText() == null || comp.getText().trim().length() == 0 ? 0.0f : Float.valueOf(comp.getText()).floatValue());
        rowVals.put(this.getView(comp).getField().getName(), f);
    }
}

