/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.tax.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.ExceptionHandler;

public final class TaxeCache {
    private final Map<Integer, Float> mapTaux = new HashMap<Integer, Float>();
    private final Map<SQLRowAccessor, Float> mapRowTaux = new LinkedHashMap<SQLRowAccessor, Float>();
    private static TaxeCache instance;
    private SQLRow firstIdTaxe = null;
    private SQLRow firstIdTaxeAchat = null;

    private static final SQLRowValuesListFetcher getSel() {
        DBRoot root = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete();
        SQLTable table = root.getTable("TAXE");
        SQLRowValues rowVals = new SQLRowValues(table);
        rowVals.putNulls("TAUX", "CODE", "NOM", "ID_TAXE", "DEFAULT", "DEFAULT_ACHAT");
        List<String> compteFields = Arrays.asList("ID_COMPTE_PCE_COLLECTE", "ID_COMPTE_PCE_DED", "ID_COMPTE_PCE", "ID_COMPTE_PCE_VENTE", "ID_COMPTE_PCE_VENTE_SERVICE", "ID_COMPTE_PCE_COLLECTE_INTRA", "ID_COMPTE_PCE_DED_INTRA", "ID_COMPTE_PCE_COLLECTE_ENCAISSEMENT");
        for (String foreignFieldName : compteFields) {
            if (!table.contains(foreignFieldName)) continue;
            rowVals.putRowValues(foreignFieldName).putNulls("NUMERO", "NOM");
        }
        return SQLRowValuesListFetcher.create(rowVals);
    }

    private TaxeCache() {
        this.loadCache();
    }

    private void loadCache() {
        this.mapRowTaux.clear();
        this.mapTaux.clear();
        this.firstIdTaxe = null;
        this.firstIdTaxeAchat = null;
        SQLRowValuesListFetcher sel = TaxeCache.getSel();
        List<SQLRowValues> l = sel.fetch();
        for (SQLRowValues sqlRow : l) {
            this.mapRowTaux.put(sqlRow, Float.valueOf(sqlRow.getFloat("TAUX")));
            this.mapTaux.put(sqlRow.getID(), Float.valueOf(sqlRow.getFloat("TAUX")));
            if (sqlRow.getBoolean("DEFAULT").booleanValue()) {
                this.firstIdTaxe = sqlRow.asRow();
            }
            if (!sqlRow.getBoolean("DEFAULT_ACHAT").booleanValue()) continue;
            this.firstIdTaxeAchat = sqlRow.asRow();
        }
    }

    public static synchronized TaxeCache getCache() {
        if (instance == null) {
            instance = new TaxeCache();
        }
        return instance;
    }

    public synchronized Float getTauxFromId(int idTaux) {
        Float f = this.mapTaux.get(idTaux);
        if (f == null) {
            this.loadCache();
            f = this.mapTaux.get(idTaux);
        }
        return f;
    }

    public synchronized SQLRowAccessor getRowFromId(int idTaux) {
        Set<SQLRowAccessor> s = this.mapRowTaux.keySet();
        for (SQLRowAccessor r : s) {
            if (r.getID() != idTaux) continue;
            return r;
        }
        this.loadCache();
        for (SQLRowAccessor r : s) {
            if (r.getID() != idTaux) continue;
            return r;
        }
        return null;
    }

    public synchronized SQLRow getFirstTaxe() {
        if (this.firstIdTaxe == null) {
            SQLRowValuesListFetcher sel = TaxeCache.getSel();
            List<SQLRowValues> rows = sel.fetch(new Where((FieldRef)sel.getReq().getTable("TAXE").getField("DEFAULT"), "=", (Object)Boolean.TRUE));
            if (rows != null && !rows.isEmpty()) {
                this.firstIdTaxe = rows.get(0).asRow();
            } else {
                ExceptionHandler.handle("Aucune TVA par d\u00e9faut d\u00e9finie!", new IllegalArgumentException("Aucune TVA par d\u00e9faut d\u00e9finie!"));
                return this.mapRowTaux.keySet().iterator().next().asRow();
            }
        }
        return this.firstIdTaxe;
    }

    public synchronized SQLRow getFirstTaxeAchat() {
        if (this.firstIdTaxeAchat == null) {
            SQLRowValuesListFetcher sel = TaxeCache.getSel();
            List<SQLRowValues> rows = sel.fetch(new Where((FieldRef)sel.getReq().getTable("TAXE").getField("DEFAULT_ACHAT"), "=", (Object)Boolean.TRUE));
            this.firstIdTaxeAchat = rows != null && !rows.isEmpty() ? rows.get(0).asRow() : this.getFirstTaxe();
        }
        return this.firstIdTaxeAchat;
    }

    public synchronized Integer getIdFromTaux(Float tax) {
        Set<Integer> s = this.mapTaux.keySet();
        for (Integer integer : s) {
            if (!this.mapTaux.get(integer).equals(tax)) continue;
            return integer;
        }
        this.loadCache();
        for (Integer integer : s) {
            if (!this.mapTaux.get(integer).equals(tax)) continue;
            return integer;
        }
        return null;
    }

    public synchronized Set<SQLRowAccessor> getAllTaxe() {
        return Collections.unmodifiableSet(this.mapRowTaux.keySet());
    }
}

