/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;
import org.openconcerto.erp.core.common.ui.NiveauTableCellRender;

public class NiveauTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final Color BG = new Color(232, 242, 252);
    private final int max;
    private final JPopupMenu popup;
    private final JPanel btnPanel;
    private final JLabel btnEmpty = new JLabel(String.valueOf("\u00d8"));
    private int value;
    final NiveauTableCellRender renderer = new NiveauTableCellRender();
    private boolean listenersInited = false;

    public NiveauTableCellEditor() {
        this(4);
    }

    public NiveauTableCellEditor(int max) {
        this.max = max;
        this.value = -1;
        this.popup = new JPopupMenu("levelEditor");
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                NiveauTableCellEditor.this.fireEditingCanceled();
            }
        });
        this.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                NiveauTableCellEditor.this.popup.setVisible(false);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                NiveauTableCellEditor.this.popup.setVisible(false);
            }
        });
        this.btnPanel = new JPanel(new FlowLayout());
        this.btnPanel.setOpaque(false);
        this.btnPanel.setFocusable(false);
        this.popup.setFocusable(false);
        this.fillPopup();
        this.popup.pack();
    }

    private void initListener(final JTable t) {
        if (!this.listenersInited) {
            this.listenersInited = true;
            this.renderer.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 9) {
                        final int row = t.getEditingRow();
                        final int column = e.getModifiers() == 1 ? t.getEditingColumn() - 1 : t.getEditingColumn() + 1;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (t.getCellEditor() != null && t.getCellEditor().stopCellEditing() && column >= 0 && column < t.getColumnCount()) {
                                    t.setColumnSelectionInterval(column, column);
                                    t.setRowSelectionInterval(row, row);
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (t.editCellAt(row, column)) {
                                                t.getEditorComponent().requestFocusInWindow();
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    } else if (e.getKeyCode() == 32 && e.getModifiers() == 1) {
                        e.setModifiers(0);
                    }
                }
            });
        }
    }

    protected void levelChosen(int btnLevel) {
        this.value = btnLevel;
        this.popup.setVisible(false);
        this.fireEditingStopped();
    }

    private void fillPopup() {
        JPanel p = new JPanel(new BorderLayout());
        p.setFocusable(true);
        p.setBackground(Color.WHITE);
        p.add((Component)new JLabel(" Niveau"), "First");
        this.btnEmpty.setHorizontalAlignment(0);
        this.btnEmpty.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                NiveauTableCellEditor.this.levelChosen(-1);
            }
        });
        this.btnEmpty.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                NiveauTableCellEditor.this.highlight(-1);
            }
        });
        this.btnEmpty.setPreferredSize(new Dimension(this.btnEmpty.getMinimumSize().width + 12, this.btnEmpty.getMinimumSize().height + 6));
        this.btnEmpty.setOpaque(true);
        this.btnPanel.add(this.btnEmpty);
        int i = 1;
        while (i <= this.max) {
            final JLabel btn = new JLabel(String.valueOf(i));
            btn.setHorizontalAlignment(0);
            btn.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    NiveauTableCellEditor.this.levelChosen(Integer.parseInt(btn.getText()));
                }
            });
            btn.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    NiveauTableCellEditor.this.highlight(Integer.parseInt(btn.getText()));
                }
            });
            btn.setPreferredSize(new Dimension(btn.getMinimumSize().width + 12, btn.getMinimumSize().height + 6));
            btn.setOpaque(true);
            this.btnPanel.add(btn);
            ++i;
        }
        p.add((Component)this.btnPanel, "Center");
        this.btnPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39 || e.getKeyCode() == 38) {
                    NiveauTableCellEditor niveauTableCellEditor = NiveauTableCellEditor.this;
                    niveauTableCellEditor.value = niveauTableCellEditor.value + 1;
                    if (NiveauTableCellEditor.this.value == 0) {
                        NiveauTableCellEditor.this.value = 1;
                    }
                    if (NiveauTableCellEditor.this.value > NiveauTableCellEditor.this.max) {
                        NiveauTableCellEditor.this.value = NiveauTableCellEditor.this.max;
                    }
                    NiveauTableCellEditor.this.highlight(NiveauTableCellEditor.this.value);
                } else if (e.getKeyCode() == 37 || e.getKeyCode() == 40) {
                    NiveauTableCellEditor niveauTableCellEditor = NiveauTableCellEditor.this;
                    niveauTableCellEditor.value = niveauTableCellEditor.value - 1;
                    if (NiveauTableCellEditor.this.value < 1) {
                        NiveauTableCellEditor.this.value = -1;
                    }
                    NiveauTableCellEditor.this.highlight(NiveauTableCellEditor.this.value);
                } else if (e.getKeyCode() == 10) {
                    NiveauTableCellEditor.this.levelChosen(NiveauTableCellEditor.this.value);
                } else if (e.getKeyCode() == 49) {
                    NiveauTableCellEditor.this.levelChosen(1);
                } else if (e.getKeyCode() == 50) {
                    if (NiveauTableCellEditor.this.max >= 2) {
                        NiveauTableCellEditor.this.levelChosen(2);
                    }
                } else if (e.getKeyCode() == 51) {
                    if (NiveauTableCellEditor.this.max >= 3) {
                        NiveauTableCellEditor.this.levelChosen(3);
                    }
                } else if (e.getKeyCode() == 52) {
                    if (NiveauTableCellEditor.this.max >= 4) {
                        NiveauTableCellEditor.this.levelChosen(4);
                    }
                } else if (e.getKeyCode() == 53) {
                    if (NiveauTableCellEditor.this.max >= 5) {
                        NiveauTableCellEditor.this.levelChosen(5);
                    }
                } else if (e.getKeyCode() == 54) {
                    if (NiveauTableCellEditor.this.max >= 6) {
                        NiveauTableCellEditor.this.levelChosen(6);
                    }
                } else if (e.getKeyCode() == 55) {
                    if (NiveauTableCellEditor.this.max >= 7) {
                        NiveauTableCellEditor.this.levelChosen(7);
                    }
                } else if (e.getKeyCode() == 56) {
                    if (NiveauTableCellEditor.this.max >= 8) {
                        NiveauTableCellEditor.this.levelChosen(8);
                    }
                } else if (e.getKeyCode() == 57 && NiveauTableCellEditor.this.max >= 9) {
                    NiveauTableCellEditor.this.levelChosen(9);
                }
            }
        });
        this.popup.add(p);
    }

    private Component getBtnForLevel(int level) {
        if (level == -1) {
            return this.btnEmpty;
        }
        return this.btnPanel.getComponent(level);
    }

    public void highlight(int btnLevel) {
        int index = 0;
        while (index <= this.max) {
            Component btnForLevel = this.getBtnForLevel(index);
            if (btnForLevel != null) {
                if (index == btnLevel || btnLevel == -1 && index == 0) {
                    btnForLevel.setBackground(BG);
                } else {
                    btnForLevel.setBackground(Color.WHITE);
                }
            }
            ++index;
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value == null) {
            value = 1;
        }
        this.initListener(table);
        this.value = ((Number)value).intValue();
        if (this.value == -1) {
            this.renderer.setText("\u00d8");
        } else {
            this.renderer.setText(String.valueOf(this.value));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NiveauTableCellEditor.this.showPopup(NiveauTableCellEditor.this.renderer);
            }
        });
        return this.renderer;
    }

    protected void showPopup(Component renderer) {
        if (renderer.isShowing()) {
            this.popup.show(renderer, 0, renderer.getHeight() + 2);
        }
        this.highlight(this.value);
        this.btnPanel.requestFocus(true);
        this.btnPanel.requestFocusInWindow();
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                JFrame f = new JFrame("Level test");
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout());
                JTable t = new JTable(new Integer[][]{{4, 3}, {2, 1}}, new String[]{"A", "B"});
                p.add((Component)new JTextField("Hello"), "North");
                p.add((Component)new JScrollPane(t), "Center");
                f.setContentPane(p);
                t.getColumnModel().getColumn(0).setCellEditor(new NiveauTableCellEditor());
                t.getColumnModel().getColumn(1).setCellEditor(new NiveauTableCellEditor());
                f.setSize(200, 200);
                f.setVisible(true);
            }
        });
    }
}

