/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.html;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openconcerto.utils.html.HTMLDiv;
import org.openconcerto.utils.html.HTMLElement;
import org.openconcerto.utils.html.HTMLFile;

public class HTMLManipulatorFrame
extends JFrame {
    JTextField textDirPath;
    JTextField textDivname;
    JTextArea textContent;
    JButton buttonFind;
    JLabel labelStatus;
    JButton buttonReplace;

    HTMLManipulatorFrame() {
        super("Div replace content");
        JPanel p = new JPanel();
        this.setContentPane(p);
        this.setDefaultCloseOperation(3);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        p.add((Component)new JLabel("Directory path:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.textDirPath = new JTextField("T:\\SitesWeb\\Dyseurope\\DysEuropeV7\\en");
        p.add((Component)this.textDirPath, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        p.add((Component)new JLabel("Div id:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.textDivname = new JTextField("siteInfo");
        p.add((Component)this.textDivname, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        p.add((Component)new JLabel("Replace content by:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.textContent = new JTextArea("<p>Hello</p>");
        this.textContent.setPreferredSize(new Dimension(300, 200));
        this.textContent.setMinimumSize(new Dimension(300, 200));
        this.textContent.setFont(this.textDivname.getFont());
        this.textContent.setLineWrap(true);
        p.add((Component)this.textContent, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridwidth = 2;
        this.labelStatus = new JLabel();
        p.add((Component)this.labelStatus, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.buttonFind = new JButton("Find");
        this.buttonFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HTMLManipulatorFrame.this.apply(false);
            }
        });
        p.add((Component)this.buttonFind, c);
        ++c.gridx;
        this.buttonReplace = new JButton("Replace");
        this.buttonReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HTMLManipulatorFrame.this.apply(true);
            }
        });
        p.add((Component)this.buttonReplace, c);
    }

    private void apply(boolean b) {
        this.disableActions();
        this.updateStatus("Please wait...");
        File f = new File(this.textDirPath.getText());
        if (!f.exists()) {
            this.updateStatus("Directory not found");
            this.enableActions();
            return;
        }
        if (!f.isDirectory()) {
            this.updateStatus(String.valueOf(this.textDirPath.getText()) + " Not a directory");
            this.enableActions();
            return;
        }
        File[] files = f.listFiles();
        int count = 0;
        int found = 0;
        String divText = this.textDivname.getText();
        String text = this.textContent.getText();
        int i = 0;
        while (i < files.length) {
            File htmlFile = files[i];
            if (htmlFile.getName().toLowerCase().endsWith(".html")) {
                ++count;
                HTMLFile hF = new HTMLFile(htmlFile);
                HTMLDiv div = hF.getDivId(divText);
                if (div != null) {
                    ++found;
                    if (b) {
                        hF.replaceContent((HTMLElement)div, text);
                        hF.saveAs(htmlFile);
                    }
                }
            }
            ++i;
        }
        this.updateStatus("Found " + count + " html files (" + found + " containing div id: " + divText);
        this.enableActions();
    }

    protected void enableActions() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HTMLManipulatorFrame.this.buttonFind.setEnabled(true);
                HTMLManipulatorFrame.this.buttonReplace.setEnabled(true);
            }
        });
    }

    protected void disableActions() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HTMLManipulatorFrame.this.buttonFind.setEnabled(false);
                HTMLManipulatorFrame.this.buttonReplace.setEnabled(false);
            }
        });
    }

    void updateStatus(final String t) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HTMLManipulatorFrame.this.labelStatus.setText(t);
            }
        });
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedLookAndFeelException e) {
                    e.printStackTrace();
                }
                HTMLManipulatorFrame f = new HTMLManipulatorFrame();
                f.pack();
                f.setVisible(true);
            }
        });
    }
}

