/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.convertor.NumberConvertor;

public class NumberUtils {
    static final int MAX_LONG_LENGTH = String.valueOf(Long.MAX_VALUE).length();
    static final Set<RoundingMode> DIVIDE_SUPPORTED_MODES = Collections.unmodifiableSet(EnumSet.of(RoundingMode.UP, RoundingMode.DOWN, RoundingMode.CEILING, RoundingMode.FLOOR));

    public static final <N extends Number> boolean areEqual(N n1, N n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        Class<?> n1Class = n1.getClass();
        if (n1Class != n2.getClass()) {
            return false;
        }
        if (n1Class == AtomicInteger.class || n1Class == AtomicLong.class) {
            return n1.longValue() == n2.longValue();
        }
        if (n1Class == BigDecimal.class) {
            return ((BigDecimal)n1).compareTo((BigDecimal)n2) == 0;
        }
        return n1.equals(n2);
    }

    public static final boolean areNumericallyEqual(Number n1, Number n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        return NumberUtils.compare(n1, n2) == 0;
    }

    public static final int compare(Number n1, Number n2) {
        Class<? extends Number> biggerClass = NumberUtils.getWiderClass(n1, n2);
        if (biggerClass == AtomicInteger.class) {
            biggerClass = Integer.class;
        } else if (biggerClass == AtomicLong.class) {
            biggerClass = Long.class;
        }
        return NumberUtils.compare(n1, n2, biggerClass);
    }

    private static final <N extends Number> int compare(Number n1, Number n2, Class<N> clazz) {
        N n1Converted = NumberConvertor.convertExact(n1, clazz);
        N n2Converted = NumberConvertor.convertExact(n2, clazz);
        Comparable comparable = (Comparable)n1Converted;
        return comparable.compareTo(n2Converted);
    }

    public static final Class<? extends Number> getWiderClass(Number n1, Number n2) {
        boolean n2isFloat;
        Class<?> n2Class;
        Class<?> n1Class = n1.getClass();
        if (n1Class == (n2Class = n2.getClass())) {
            return n1Class;
        }
        if (n1Class == BigDecimal.class || n2Class == BigDecimal.class) {
            return BigDecimal.class;
        }
        boolean n1isFloat = n1Class == Float.class || n1Class == Double.class;
        boolean bl = n2isFloat = n2Class == Float.class || n2Class == Double.class;
        if (n1isFloat && n2isFloat) {
            return Double.class;
        }
        if (n1isFloat || n2isFloat) {
            if (n1Class == BigInteger.class || n2Class == BigInteger.class) {
                return BigDecimal.class;
            }
            return Double.class;
        }
        if (n1Class == BigInteger.class || n2Class == BigInteger.class) {
            return BigInteger.class;
        }
        if (n1Class == Long.class || n2Class == Long.class || n1Class == AtomicLong.class || n2Class == AtomicLong.class) {
            return Long.class;
        }
        if (n1Class == Integer.class || n2Class == Integer.class || n1Class == AtomicInteger.class || n2Class == AtomicInteger.class) {
            return Integer.class;
        }
        if (n1Class == Short.class || n2Class == Short.class) {
            return Short.class;
        }
        if (n1Class == Byte.class || n2Class == Byte.class) {
            return Byte.class;
        }
        throw new IllegalStateException("Unknown classes " + n1Class + " / " + n2Class);
    }

    public static final boolean hasFractionalPart(Number n) {
        if (n instanceof Integer || n instanceof Long || n instanceof Short || n instanceof Byte || n instanceof BigInteger || n instanceof AtomicLong || n instanceof AtomicInteger) {
            return false;
        }
        BigDecimal bd = n instanceof BigDecimal ? (BigDecimal)n : (n instanceof Double || n instanceof Float ? new BigDecimal(n.doubleValue()) : new BigDecimal(n.toString()));
        return DecimalUtils.decimalDigits(bd) > 0;
    }

    public static final int intDigits(long l) {
        long x = Math.abs(l);
        long p = 10L;
        int i = 1;
        while (x >= p && i < MAX_LONG_LENGTH) {
            p *= 10L;
            ++i;
        }
        return i;
    }

    public static final int intDigits(Number n) {
        if (n instanceof Integer || n instanceof Long || n instanceof Short || n instanceof Byte || n instanceof AtomicLong || n instanceof AtomicInteger) {
            return NumberUtils.intDigits(n.longValue());
        }
        BigDecimal bd = n instanceof BigDecimal ? (BigDecimal)n : (n instanceof BigInteger ? new BigDecimal((BigInteger)n) : (n instanceof Double || n instanceof Float ? new BigDecimal(n.doubleValue()) : new BigDecimal(n.toString())));
        return DecimalUtils.intDigits(bd);
    }

    public static Number divide(Number n, double d) {
        if (d == 1.0) {
            return n;
        }
        if (n instanceof BigDecimal) {
            return ((BigDecimal)n).divide(new BigDecimal(d), DecimalUtils.HIGH_PRECISION);
        }
        if (n instanceof BigInteger) {
            return new BigDecimal((BigInteger)n).divide(new BigDecimal(d), DecimalUtils.HIGH_PRECISION);
        }
        return n.doubleValue() / d;
    }

    public static final int divideRoundUp(int n, int d) {
        return NumberUtils.divideRound(n, d, RoundingMode.UP);
    }

    public static final int divideRoundDown(int n, int d) {
        return NumberUtils.divideRound(n, d, RoundingMode.DOWN);
    }

    public static final int divideRoundCeiling(int n, int d) {
        return NumberUtils.divideRound(n, d, RoundingMode.CEILING);
    }

    public static final int divideRoundFloor(int n, int d) {
        return NumberUtils.divideRound(n, d, RoundingMode.FLOOR);
    }

    static final int divideRound(int n, int d, RoundingMode mode) {
        int mult;
        if (n == 0) {
            return 0;
        }
        if (mode == RoundingMode.DOWN) {
            mult = 0;
        } else if (mode == RoundingMode.UP) {
            mult = NumberUtils.signum(n) * (d - 1);
        } else if (mode == RoundingMode.CEILING) {
            mult = n > 0 ? d - 1 : 0;
        } else if (mode == RoundingMode.FLOOR) {
            mult = n > 0 ? 0 : -(d - 1);
        } else {
            throw new UnsupportedOperationException();
        }
        return (n + mult) / d;
    }

    public static Number negate(Number n) {
        if (n == null) {
            return null;
        }
        Class<?> clazz = n.getClass();
        Number res = n instanceof BigDecimal ? ((BigDecimal)n).negate() : (n instanceof BigInteger ? ((BigInteger)n).negate() : (clazz == Short.class ? (Number)(-n.shortValue()) : (Number)(clazz == Integer.class ? (Number)(-n.intValue()) : (Number)(clazz == Long.class ? (Number)(-n.longValue()) : (Number)(clazz == Byte.class ? (Number)(-n.byteValue()) : (Number)(clazz == AtomicInteger.class ? new AtomicInteger(-n.intValue()) : (clazz == AtomicLong.class ? new AtomicLong(-n.longValue()) : (clazz == Double.class ? (Number)(-n.doubleValue()) : (Number)(clazz == Float.class ? Float.valueOf(-n.floatValue()) : new BigDecimal(n.toString()).negate())))))))));
        return res;
    }

    public static int signum(long l) {
        int res = l == 0L ? 0 : (l < 0L ? -1 : 1);
        return res;
    }

    public static int signum(Number n) {
        if (n == null) {
            throw new NullPointerException();
        }
        Class<?> clazz = n.getClass();
        int res = n instanceof BigDecimal ? ((BigDecimal)n).signum() : (n instanceof BigInteger ? ((BigInteger)n).signum() : (clazz == Double.class ? (int)Math.signum(n.doubleValue()) : (clazz == Float.class ? (int)Math.signum(n.floatValue()) : (clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == AtomicInteger.class || clazz == AtomicLong.class ? NumberUtils.signum(n.longValue()) : (int)Math.signum(n.doubleValue())))));
        return res;
    }

    public static int ensureInt(long l) throws ArithmeticException {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ArithmeticException("long value " + String.valueOf(l) + " cannot be cast to int without changing its value.");
        }
        return (int)l;
    }
}

