/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.LightUIContainer;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUIPanel;
import org.openconcerto.utils.io.JSONConverter;
import org.openconcerto.utils.io.Transferable;

public class LightUILine
extends LightUIContainer
implements Transferable,
Externalizable {
    private static final long serialVersionUID = 4132718509484530435L;
    public static final int ALIGN_GRID = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    private int gridAlignment = 0;
    private int elementPadding = 0;
    private int elementMargin = 0;

    public LightUILine() {
        super("");
        this.setType(16);
    }

    public LightUILine(JSONObject json) {
        super(json);
    }

    public LightUILine(LightUILine line) {
        super(line);
    }

    public void setElementPadding(Integer elementPadding) {
        this.elementPadding = elementPadding;
    }

    public Integer getElementPadding() {
        return this.elementPadding;
    }

    public void setElementMargin(Integer elementMargin) {
        this.elementMargin = elementMargin;
    }

    public Integer getElementMargin() {
        return this.elementMargin;
    }

    public int getGridAlignment() {
        return this.gridAlignment;
    }

    public void setGridAlignment(int gridAlignment) {
        this.gridAlignment = gridAlignment;
    }

    public Integer getTotalHeight() {
        Integer h = 0;
        int size = this.getChildrenCount();
        int i = 0;
        while (i < size) {
            h = h + this.getChild(i).getHeight();
            ++i;
        }
        return h;
    }

    public Integer getTotalGridWidth() {
        Integer w = 0;
        int size = this.getChildrenCount();
        int i = 0;
        while (i < size) {
            w = w + this.getChild(i).getGridWidth();
            ++i;
        }
        return w;
    }

    public static String createId(LightUIPanel parent) {
        return String.valueOf(parent.getId()) + ".line." + parent.getChildrenCount();
    }

    @Override
    protected void copy(LightUIElement element) {
        super.copy(element);
        if (!(element instanceof LightUILine)) {
            throw new InvalidClassException(this.getClassName(), element.getClassName(), element.getId());
        }
        LightUILine line = (LightUILine)element;
        this.elementMargin = line.elementMargin;
        this.elementPadding = line.elementPadding;
        this.gridAlignment = line.gridAlignment;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = super.toJSON();
        result.put("class", "LightUILine");
        if (this.elementPadding != 0) {
            result.put("element-padding", this.elementPadding);
        }
        if (this.elementMargin != 0) {
            result.put("element-margin", this.elementMargin);
        }
        if (this.gridAlignment != 0) {
            result.put("grid-alignment", this.gridAlignment);
        }
        return result;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.elementPadding = JSONConverter.getParameterFromJSON(json, "element-padding", Integer.class, 0);
        this.elementMargin = JSONConverter.getParameterFromJSON(json, "element-margin", Integer.class, 0);
        this.gridAlignment = JSONConverter.getParameterFromJSON(json, "grid-alignment", Integer.class, 0);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.elementMargin);
        out.writeInt(this.elementPadding);
        out.writeByte(this.gridAlignment);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.elementMargin = in.readInt();
        this.elementPadding = in.readInt();
        this.gridAlignment = in.readByte();
    }

    @Override
    public void addChild(LightUIElement child) {
        if (child instanceof LightUILine) {
            throw new IllegalArgumentException("child is a LightUILine");
        }
        super.addChild(child);
    }
}

