/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.JTree;
import org.openconcerto.laf.LAFUtils;

public class FontUtils {
    public static Font setFontFor(Component comp, String toDisplay) {
        return FontUtils.setFontFor(comp, LAFUtils.getUIName((Component)comp), toDisplay);
    }

    public static Font setFontFor(Component comp, String name, String toDisplay) {
        Font res;
        if (name == null) {
            throw new NullPointerException();
        }
        if (comp.getFont().canDisplayUpTo(toDisplay) == -1) {
            res = null;
        } else {
            Font comboSysFont = LAFUtils.getFont((String)(String.valueOf(name) + ".font"));
            if (comboSysFont == null) {
                res = null;
            } else {
                res = comboSysFont.deriveFont(comp.getFont().getAttributes());
                comp.setFont(res);
            }
        }
        return res;
    }

    public static int getPreferredRowHeight(JTree tree) {
        return 2 + (int)((float)tree.getFont().getSize() * 1.4f);
    }

    public static int getPreferredRowHeight(JTable table) {
        return 4 + (int)((float)table.getFont().getSize() * 1.4f);
    }
}

