/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.list.ListAccess;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumns;
import org.openconcerto.sql.view.list.SQLTableModelLinesSource;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.UpdateQueue;
import org.openconcerto.sql.view.list.search.SearchQueue;
import org.openconcerto.sql.view.search.ColumnSearchSpec;
import org.openconcerto.sql.view.search.SearchList;
import org.openconcerto.sql.view.search.SearchSpec;
import org.openconcerto.utils.SleepingQueue;
import org.openconcerto.utils.TableSorter;
import org.openconcerto.utils.cc.IPredicate;

public class ITableModel
extends AbstractTableModel {
    private static Timer autoHibernateTimer = null;
    private static boolean defaultCellsEditable = false;
    private static boolean defaultOrderEditable = true;
    private final SQLTableModelLinesSource linesSource;
    private SQLTableModelColumns columns;
    private final List<String> colNames;
    private final List<ListSQLLine> liste;
    private boolean updating = false;
    private boolean filledOnce = false;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private List<TableModelListener> fullListeners = new LinkedList<TableModelListener>();
    private final UpdateQueue updateQ;
    private boolean loading;
    @GuardedBy(value="runSleep")
    private SleepState wantedState;
    @GuardedBy(value="runSleep")
    private SleepState actualState;
    @GuardedBy(value="runSleep")
    private int hibernateDelay;
    @GuardedBy(value="runSleep")
    private TimerTask autoHibernate;
    private final AtomicInteger runSleep;
    private final SearchQueue searchQ;
    private boolean searching;
    private boolean cellsEditable;
    private boolean orderEditable;
    private boolean debug;
    @GuardedBy(value="this")
    private Thread.UncaughtExceptionHandler uncaughtExnHandler = null;
    private DyingQueueExceptionHandler dyingQueueHandler = null;

    public static Timer getAutoHibernateTimer() {
        if (autoHibernateTimer == null) {
            autoHibernateTimer = new Timer(String.valueOf(ITableModel.class.getSimpleName()) + " auto-hibernate timer", true);
        }
        return autoHibernateTimer;
    }

    public static void setDefaultCellsEditable(boolean defaultEditable) {
        assert (SwingUtilities.isEventDispatchThread());
        defaultCellsEditable = defaultEditable;
    }

    public static final boolean isDefaultCellsEditable() {
        return defaultCellsEditable;
    }

    public static void setDefaultOrderEditable(boolean defaultEditable) {
        assert (SwingUtilities.isEventDispatchThread());
        defaultOrderEditable = defaultEditable;
    }

    public static final boolean isDefaultOrderEditable() {
        return defaultOrderEditable;
    }

    public static ListSQLLine getLine(TableModel m, int row) {
        if (m instanceof ITableModel) {
            return ((ITableModel)m).getRow(row);
        }
        if (m instanceof TableSorter) {
            TableSorter sorter = (TableSorter)m;
            return ITableModel.getLine(sorter.getTableModel(), sorter.modelIndex(row));
        }
        throw new IllegalArgumentException("neither ITableModel nor TableSorter : " + m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITableModel(SQLTableModelSource src) {
        this.liste = new ArrayList<ListSQLLine>(100);
        this.setCellsEditable(ITableModel.isDefaultCellsEditable());
        this.setOrderEditable(ITableModel.isDefaultOrderEditable());
        this.debug = false;
        this.linesSource = src.createLinesSource(this);
        this.colNames = new ArrayList<String>();
        this.setCols(src.getAllColumns());
        this.updateQ = new UpdateQueue(this);
        this.loading = false;
        this.updateQ.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("beingRun")) {
                    final boolean isLoading = UpdateQueue.isUpdate((RunnableFuture)evt.getNewValue());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ITableModel.this.setLoading(isLoading);
                        }
                    });
                }
            }
        });
        AtomicInteger atomicInteger = this.runSleep = new AtomicInteger(0);
        synchronized (atomicInteger) {
            this.wantedState = this.actualState = SleepState.AWAKE;
            this.setHibernateDelay(30);
            this.autoHibernate = null;
        }
        this.searchQ = new SearchQueue(new ListAccess(this));
        this.searching = false;
        this.searchQ.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("beingRun")) {
                    final boolean isSearching = SearchQueue.isSearch((RunnableFuture)evt.getNewValue());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ITableModel.this.setSearching(isSearching);
                        }
                    });
                }
            }
        });
    }

    void print(String s) {
        this.print(s, Level.FINE);
    }

    void print(String s, Level l) {
        Log.get().log(l, this.getTable() + " " + this.hashCode() + " : " + s);
    }

    public void invokeLater(final Runnable r) {
        if (r == null) {
            return;
        }
        this.runnableAdded();
        this.updateQ.put(new Runnable(){

            @Override
            public void run() {
                try {
                    ITableModel.this.getSearchQueue().put(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(r);
                        }
                    });
                }
                finally {
                    ITableModel.this.runnableCompleted();
                }
            }
        });
    }

    public void putExternalUpdated(String externalID, IPredicate<ListSQLLine> affectedPredicate) {
        this.getUpdateQ().putExternalUpdated(externalID, affectedPredicate);
    }

    final UpdateQueue getUpdateQ() {
        return this.updateQ;
    }

    public void updateAll() {
        this.updateQ.putUpdateAll();
    }

    public final void setAlwaysUpdateAll(boolean b) {
        this.getUpdateQ().setAlwaysUpdateAll(b);
    }

    void setList(List<ListSQLLine> liste, SQLTableModelColumns columns) {
        this.setUpdating(true);
        if (liste == null) {
            Collections.sort(this.liste);
        } else {
            this.liste.clear();
            this.liste.addAll(liste);
            this.filledOnce = true;
            this.print("liste filled : " + this.liste.size());
        }
        if (columns != null && this.setCols(columns)) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
        this.setUpdating(false);
    }

    void addToList(ListSQLLine modifiedLine) {
        this.setUpdating(true);
        this.liste.add(modifiedLine);
        Collections.sort(this.liste);
        int index = this.indexFromID(modifiedLine.getID());
        this.fireTableRowsInserted(index, index);
        this.setUpdating(false);
    }

    void fullListChanged(ListSQLLine modifiedLine, Collection<Integer> modifiedFields) {
        boolean orderChanged;
        this.setUpdating(true);
        int index = this.indexFromID(modifiedLine.getID());
        if (index >= 0) {
            this.liste.set(index, modifiedLine);
            boolean afterPred = index > 0 ? modifiedLine.compareTo(this.liste.get(index - 1)) > 0 : true;
            boolean beforeSucc = index < this.liste.size() - 1 ? modifiedLine.compareTo(this.liste.get(index + 1)) < 0 : true;
            orderChanged = !afterPred || !beforeSucc;
        } else {
            this.liste.add(modifiedLine);
            orderChanged = true;
        }
        if (orderChanged) {
            Collections.sort(this.liste);
            this.fireTableDataChanged();
        } else if (modifiedFields == null) {
            this.fireTableRowsUpdated(index, index);
        } else {
            for (Integer i : modifiedFields) {
                this.fireTableCellUpdated(index, i);
            }
        }
        this.setUpdating(false);
    }

    void removeFromList(int id) {
        this.setUpdating(true);
        int index = this.indexFromID(id);
        if (index >= 0) {
            this.liste.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
        this.setUpdating(false);
    }

    @Override
    public void fireTableChanged(TableModelEvent e) {
        if (e.getColumn() == -1 || e.getColumn() < this.getColumnCount()) {
            super.fireTableChanged(e);
        } else {
            for (TableModelListener l : this.fullListeners) {
                l.tableChanged(e);
            }
        }
    }

    protected void updateColNames() {
        this.colNames.clear();
        for (SQLTableModelColumn sQLTableModelColumn : this.getCols()) {
            this.colNames.add(this.isDebug() ? String.valueOf(sQLTableModelColumn.getName()) + " " + sQLTableModelColumn.getPaths().toString() : sQLTableModelColumn.getName());
        }
    }

    public List<String> getColumnNames() {
        return this.colNames;
    }

    private boolean setCols(SQLTableModelColumns cols) {
        if (!cols.equals(this.columns)) {
            this.columns = cols;
            this.updateColNames();
            return true;
        }
        return false;
    }

    final List<? extends SQLTableModelColumn> getCols() {
        return this.isDebug() ? this.columns.getAllColumns() : this.columns.getColumns();
    }

    @Override
    public int getRowCount() {
        return this.liste.size();
    }

    public int getTotalRowCount() {
        return this.getUpdateQ().getFullListSize();
    }

    @Override
    public int getColumnCount() {
        return this.getColumnNames().size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return String.valueOf(this.getColumnNames().get(columnIndex));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getReq().getColumn(columnIndex).getValueClass();
    }

    public final void setEditable(boolean b) {
        this.setCellsEditable(b);
        this.setOrderEditable(b);
    }

    public final void setCellsEditable(boolean b) {
        if (this.cellsEditable != b) {
            this.cellsEditable = b;
            this.supp.firePropertyChange("cellsEditable", !this.cellsEditable, this.cellsEditable);
        }
    }

    public final boolean areCellsEditable() {
        return this.cellsEditable;
    }

    public final void setOrderEditable(boolean b) {
        if (this.orderEditable != b) {
            this.orderEditable = b;
            this.supp.firePropertyChange("orderEditable", !this.orderEditable, this.orderEditable);
        }
    }

    public final boolean isOrderEditable() {
        return this.orderEditable;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.areCellsEditable()) {
            return false;
        }
        SQLTableModelColumn col = this.getReq().getColumn(columnIndex);
        return col.isEditable() && !this.isReadOnly(rowIndex, columnIndex, col) && this.hasRight(col);
    }

    private boolean isReadOnly(int rowIndex, int columnIndex, SQLTableModelColumn col) {
        ListSQLLine line = this.getRow(rowIndex);
        if (!line.getSrc().isCellEditable(line, columnIndex, col)) {
            return true;
        }
        SQLRowValues r = line.getRow();
        return r.getTable().contains("UI_LOCK") && SQLComponent.isReadOnly(r);
    }

    private boolean hasRight(SQLTableModelColumn col) {
        UserRights u = UserRightsManager.getCurrentUserRights();
        for (SQLTable t : col.getWriteFields().getTables()) {
            if (TableAllRights.hasRight(u, "UPDATE_ROW", t)) continue;
            return false;
        }
        for (SQLTable t : col.getWriteTables()) {
            if (TableAllRights.hasRight(u, "INSERT_ROW", t) && TableAllRights.hasRight(u, "DELETE_ROW", t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount()) {
            throw new IllegalArgumentException("!!!+ acces a la ligne :" + rowIndex + " et la taille est de:" + this.getRowCount());
        }
        return this.getRow(rowIndex).getValueAt(columnIndex);
    }

    public final ListSQLLine getRow(int rowIndex) {
        return this.liste.get(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.getRow(rowIndex).setValueAt(aValue, columnIndex);
    }

    public int idFromIndex(int index) {
        if (index >= 0 && this.liste.size() > index) {
            return this.getRow(index).getID();
        }
        return -1;
    }

    public int indexFromID(int id) {
        return ListSQLLine.indexFromID(this.liste, id);
    }

    final SearchQueue getSearchQueue() {
        return this.searchQ;
    }

    public void search(SearchSpec list, Runnable r) {
        this.getSearchQueue().setSearch(list, r);
    }

    public void search(SearchSpec list) {
        this.search(list, null);
    }

    public void resetSearch(Runnable r) {
        this.search(null, r);
    }

    public void resetSearch() {
        this.resetSearch(null);
    }

    void searchContains(String s, int colIndex, Runnable r) {
        SearchList spec = s == null ? null : SearchList.singleton(ColumnSearchSpec.create(s, colIndex));
        this.search(spec, r);
    }

    public void searchContains(String s, Runnable r) {
        this.searchContains(s, -1, r);
    }

    protected final boolean canOrder() {
        return this.isOrderEditable() && this.getReq().getReq().isTableOrder() && TableAllRights.hasRight(UserRightsManager.getCurrentUserRights(), "UPDATE_ROW", this.getTable());
    }

    private final void handleCannotOrder(boolean ignoreForbidden) {
        if (!ignoreForbidden) {
            throw new IllegalStateException("Not allowed to order rows of " + this.getTable());
        }
    }

    public void moveBy(List<? extends SQLRowAccessor> rows, int inc, boolean ignoreForbidden) {
        if (this.canOrder()) {
            this.getLinesSource().moveBy(rows, inc);
        } else {
            this.handleCannotOrder(ignoreForbidden);
        }
    }

    public void moveTo(List<Number> rows, int rowIndex, boolean ignoreForbidden) {
        if (this.canOrder()) {
            this.getLinesSource().moveTo(rows, rowIndex);
        } else {
            this.handleCannotOrder(ignoreForbidden);
        }
    }

    ListSQLLine getDestLine(int rowID, int inc) {
        int rowIndex = this.indexFromID(rowID);
        if (rowIndex < 0) {
            return null;
        }
        int destIndex = rowIndex + inc;
        boolean min = false;
        int max = this.getRowCount() - 1;
        if (destIndex < 0) {
            destIndex = 0;
        } else if (destIndex > max) {
            destIndex = max;
        }
        if (destIndex != rowIndex) {
            return this.getRow(destIndex);
        }
        return null;
    }

    public final boolean filledOnce() {
        return this.filledOnce;
    }

    public final boolean isUpdating() {
        return this.updating;
    }

    private void setUpdating(boolean searching) {
        assert (SwingUtilities.isEventDispatchThread());
        boolean old = this.updating;
        if (old != searching) {
            this.updating = searching;
            this.supp.firePropertyChange("updating", old, this.updating);
        }
    }

    private void setLoading(boolean isLoading) {
        boolean old = this.loading;
        if (old != isLoading) {
            this.loading = isLoading;
            this.supp.firePropertyChange("loading", old, this.loading);
        }
    }

    public final boolean isLoading() {
        return this.loading;
    }

    private void setSearching(boolean searching) {
        boolean old = this.searching;
        if (old != searching) {
            this.searching = searching;
            this.supp.firePropertyChange("searching", old, this.searching);
        }
    }

    public final boolean isSearching() {
        return this.searching;
    }

    void setSleeping(boolean sleeping) {
        this.setSleeping(sleeping ? SleepState.SLEEPING : SleepState.AWAKE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSleeping(SleepState state) {
        AtomicInteger atomicInteger = this.runSleep;
        synchronized (atomicInteger) {
            this.wantedState = state;
            this.sleepUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setHibernateDelay(int seconds) {
        AtomicInteger atomicInteger = this.runSleep;
        synchronized (atomicInteger) {
            this.hibernateDelay = seconds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getHibernateDelay() {
        AtomicInteger atomicInteger = this.runSleep;
        synchronized (atomicInteger) {
            return this.hibernateDelay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runnableAdded() {
        AtomicInteger atomicInteger = this.runSleep;
        synchronized (atomicInteger) {
            this.runSleep.incrementAndGet();
            this.sleepUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runnableCompleted() {
        AtomicInteger atomicInteger = this.runSleep;
        synchronized (atomicInteger) {
            this.runSleep.decrementAndGet();
            this.sleepUpdated();
        }
    }

    private void sleepUpdated() {
        SleepState res;
        assert (Thread.holdsLock(this.runSleep));
        if (this.runSleep.get() > 0) {
            res = SleepState.AWAKE;
        } else if (this.wantedState == this.actualState) {
            res = null;
        } else if (this.actualState == SleepState.AWAKE) {
            res = SleepState.SLEEPING;
        } else if (this.actualState == SleepState.SLEEPING) {
            res = this.wantedState;
        } else if (this.actualState == SleepState.HIBERNATING) {
            res = this.wantedState == SleepState.AWAKE ? this.wantedState : null;
        } else {
            throw new IllegalStateException("unknown state: " + (Object)((Object)this.actualState));
        }
        if (res != null) {
            this.setActual(res);
        }
    }

    private void setActual(SleepState state) {
        if (this.actualState != state) {
            this.print("changing state " + (Object)((Object)this.actualState) + " => " + (Object)((Object)state));
            this.actualState = state;
            if (this.autoHibernate != null) {
                this.autoHibernate.cancel();
            }
            switch (this.actualState) {
                case AWAKE: {
                    this.updateQ.setSleeping(false);
                    break;
                }
                case SLEEPING: {
                    this.updateQ.setSleeping(true);
                    int delay = this.getHibernateDelay();
                    if (delay < 0) break;
                    this.autoHibernate = new TimerTask(){

                        @Override
                        public void run() {
                            try {
                                ITableModel.this.setSleeping(SleepState.HIBERNATING);
                            }
                            catch (Exception e) {
                                ITableModel.this.print("HIBERNATING failed : " + e.getMessage(), Level.WARNING);
                                e.printStackTrace();
                            }
                        }
                    };
                    ITableModel.getAutoHibernateTimer().schedule(this.autoHibernate, delay * 1000);
                    break;
                }
                case HIBERNATING: {
                    this.updateQ.putRemoveAll();
                }
            }
            this.sleepUpdated();
        }
    }

    public final SQLTableModelLinesSource getLinesSource() {
        return this.linesSource;
    }

    public final SQLTableModelSource getReq() {
        return this.linesSource.getParent();
    }

    public final SQLTable getTable() {
        return this.getReq().getPrimaryTable();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propName, PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(propName, l);
    }

    public void rmPropertyChangeListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    public void rmPropertyChangeListener(String propName, PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(propName, l);
    }

    public final boolean isDebug() {
        return this.debug;
    }

    public final void setDebug(boolean debug) {
        if (this.debug != debug) {
            this.setUpdating(true);
            this.debug = debug;
            this.updateColNames();
            this.fireTableStructureChanged();
            this.setUpdating(false);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + this.hashCode() + " for " + this.getTable();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.addTableModelListener(l, false);
    }

    public void addTableModelListener(TableModelListener l, boolean full) {
        assert (SwingUtilities.isEventDispatchThread());
        this.start();
        if (full) {
            this.fullListeners.add(l);
        }
        super.addTableModelListener(l);
    }

    public final synchronized void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExnHandler) {
        this.uncaughtExnHandler = uncaughtExnHandler;
    }

    public final synchronized Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExnHandler;
    }

    public final void start() {
        SleepingQueue.RunningState state = this.updateQ.getRunningState();
        if (state.compareTo(SleepingQueue.RunningState.RUNNING) > 0) {
            throw new IllegalStateException("dead tableModel: " + this);
        }
        if (state == SleepingQueue.RunningState.NEW) {
            this.print("starting");
            this.getLinesSource().live();
            this.startQueue(this.updateQ);
        }
    }

    final void startSearchQueue() {
        this.startQueue(this.getSearchQueue());
    }

    final void startQueue(SleepingQueue q) {
        q.start(thr -> thr.setUncaughtExceptionHandler(this.getUncaughtExceptionHandler()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTableModelListener(TableModelListener l) {
        assert (SwingUtilities.isEventDispatchThread());
        this.fullListeners.remove(l);
        super.removeTableModelListener(l);
        if (this.listenerList.getListenerCount() == 0) {
            SleepingQueue.RunningState threadState = this.updateQ.getRunningState();
            if (threadState == SleepingQueue.RunningState.RUNNING) {
                this.print("dying");
                SleepingQueue.LethalFutureTask<?> dieSearch = this.updateQ.die();
                this.getLinesSource().die();
                AtomicInteger atomicInteger = this.runSleep;
                synchronized (atomicInteger) {
                    if (this.autoHibernate != null) {
                        this.autoHibernate.cancel();
                        this.autoHibernate = null;
                    }
                }
                this.wait(dieSearch, 25L, TimeUnit.MILLISECONDS);
            } else {
                this.print("not dying");
                Log.get().warning("Queue is " + (Object)((Object)threadState) + " : unbalanced removeTableModelListener() called with " + l);
            }
        }
    }

    public void setDyingQueueExceptionHandler(DyingQueueExceptionHandler h) {
        assert (SwingUtilities.isEventDispatchThread());
        this.dyingQueueHandler = h;
    }

    public DyingQueueExceptionHandler getDyingQueueExceptionHandler() {
        return this.dyingQueueHandler;
    }

    final void wait(SleepingQueue.LethalFutureTask<?> f, long amount, TimeUnit unit) {
        try {
            f.get(amount, unit);
            assert (f.getQueue().getRunningState().compareTo(SleepingQueue.RunningState.DYING) >= 0);
        }
        catch (Exception e) {
            DyingQueueExceptionHandler handler = this.getDyingQueueExceptionHandler();
            if (handler != null) {
                handler.handle(f, e);
            }
            if (e instanceof TimeoutException) {
                Log.get().log(Level.INFO, "Killing still isn't done so create a watcher for " + f);
                SleepingQueue.watchDying(f, 15, 60, TimeUnit.SECONDS);
            }
            Log.get().log(Level.WARNING, "Exception while waiting, queue state is " + (Object)((Object)f.getQueue().getRunningState()) + " for " + f, e);
        }
    }

    public static interface DyingQueueExceptionHandler {
        public void handle(SleepingQueue.LethalFutureTask<?> var1, Exception var2);
    }

    public static enum SleepState {
        AWAKE,
        SLEEPING,
        HIBERNATING;

    }
}

