/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openconcerto.erp.core.sales.pos.io.Printable;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.erp.core.sales.pos.model.RegisterFiles;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.ui.ArticleSearchPanel;
import org.openconcerto.erp.core.sales.pos.ui.ArticleSelectorPanel;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;
import org.openconcerto.erp.core.sales.pos.ui.PaiementPanel;
import org.openconcerto.erp.core.sales.pos.ui.StatusBar;
import org.openconcerto.erp.core.sales.pos.ui.TicketPanel;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.StringUtils;

public class CaissePanel
extends JPanel
implements CaisseListener {
    public static final Color LIGHT_BLUE = new Color(83, 129, 172);
    public static final Color DARK_BLUE = new Color(0, 98, 159);
    private CaisseControler controler;
    private StatusBar st;
    private ArticleSelectorPanel articleSelectorPanel;
    private ArticleSearchPanel articleSearchPanel;
    private JPanel selector;
    private static Map<Integer, SQLRowAccessor> cacheArticle = new HashMap<Integer, SQLRowAccessor>();

    public CaissePanel(CaisseFrame caisseFrame) throws Exception {
        SQLElementDirectory dir = caisseFrame.getConf().getDirectory();
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        this.setOpaque(this.isOpaque());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.controler = new CaisseControler(caisseFrame);
        c.fill = 2;
        this.st = this.createStatusBar(caisseFrame);
        this.add((Component)this.st, c);
        TicketPanel t = new TicketPanel(this.controler);
        this.loadArticles(dir);
        ++c.gridy;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.anchor = 16;
        c.fill = 0;
        this.add((Component)t, c);
        c.fill = 1;
        ++c.gridx;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridheight = 2;
        this.articleSelectorPanel = new ArticleSelectorPanel(this.controler);
        this.articleSearchPanel = new ArticleSearchPanel(this.controler);
        this.selector = this.articleSelectorPanel;
        this.add((Component)this.selector, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new PaiementPanel(this), c);
        this.controler.addCaisseListener(this);
    }

    private StatusBar createStatusBar(final CaisseFrame caisseFrame) {
        StatusBar s = new StatusBar();
        s.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = this.controler.getPOSConf().getScreenWidth() < 1280 ? new Insets(0, 2, 0, 2) : new Insets(0, 10, 0, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 10;
        c.weightx = 0.0;
        POSButton bValidate = new POSButton("Valider");
        bValidate.setForeground(Color.WHITE);
        bValidate.setBackground(DARK_BLUE);
        s.add((Component)bValidate, c);
        c.weightx = 1.0;
        ++c.gridx;
        POSButton bClients = new POSButton("Clients");
        bClients.setForeground(Color.WHITE);
        bClients.setBackground(DARK_BLUE);
        s.add((Component)bClients, c);
        ++c.gridx;
        POSButton bMenu = new POSButton("Menu");
        bMenu.setForeground(Color.WHITE);
        bMenu.setBackground(DARK_BLUE);
        s.add((Component)bMenu, c);
        bValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (caisseFrame.getPOSConf().askPostalCode()) {
                    caisseFrame.showPostalCodeFrame(CaissePanel.this);
                } else {
                    CaissePanel.this.validateTicket(caisseFrame);
                }
            }
        });
        bClients.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    caisseFrame.showClients();
                }
                catch (Throwable ex) {
                    ExceptionHandler.handle("Erreur d'affichage du menu", ex);
                }
            }
        });
        bMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    caisseFrame.showMenu();
                }
                catch (Throwable ex) {
                    ExceptionHandler.handle("Erreur d'affichage du menu", ex);
                }
            }
        });
        return s;
    }

    private void loadArticles(SQLElementDirectory dir) {
        SQLSelect selUniteVente = new SQLSelect();
        selUniteVente.addSelectStar(dir.getElement("UNITE_VENTE").getTable());
        HashMap<Integer, String> mapUniteVenteName = new HashMap<Integer, String>();
        for (SQLRow row : SQLRowListRSH.execute(selUniteVente)) {
            mapUniteVenteName.put(row.getID(), row.getString("CODE"));
        }
        Set<Integer> favoriteProductsIds = this.controler.loadFavoriteProductsIds();
        ArrayList<Article> favoriteProducts = new ArrayList<Article>();
        HashMap<Integer, Categorie> categoriesMap = new HashMap<Integer, Categorie>();
        SQLElement eltFam = dir.getElement("FAMILLE_ARTICLE");
        SQLElement eltArticle = dir.getElement("ARTICLE");
        SQLSelect selFamille = new SQLSelect();
        selFamille.addSelectStar(eltFam.getTable());
        selFamille.addFieldOrder(eltFam.getTable().getField("CODE"));
        for (SQLRow row : SQLRowListRSH.execute(selFamille)) {
            Categorie c;
            Categorie cP = (Categorie)categoriesMap.get(row.getInt("ID_FAMILLE_ARTICLE_PERE"));
            if (cP != null) {
                c = new Categorie(row.getString("NOM"));
                cP.add(c);
            } else {
                c = new Categorie(row.getString("NOM"), true);
            }
            categoriesMap.put(row.getID(), c);
        }
        SQLSelect selArticle = new SQLSelect();
        SQLTable tableArticle = eltArticle.getTable();
        selArticle.addAllSelect(tableArticle.getFields(SQLTable.VirtualFields.PRIMARY_KEY.union(SQLTable.VirtualFields.ARCHIVE)));
        selArticle.addAllSelect(tableArticle, Arrays.asList("ID_FAMILLE_ARTICLE", "NOM", "CODE", "CODE_BARRE", "ID_TAXE", "PV_HT", "PV_TTC", "ADDITIONAL_TICKET_COPY", "ID_UNITE_VENTE"));
        selArticle.setWhere(new Where((FieldRef)tableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE).and(new Where((FieldRef)tableArticle.getField("MASQUE_CAISSE"), "=", (Object)Boolean.FALSE)));
        Categorie cUnclassified = new Categorie("Non class\u00e9s", true);
        cUnclassified.setUnknown();
        for (SQLRow row : SQLRowListRSH.execute(selArticle)) {
            Integer idProduct;
            String name;
            int idFamilleArticle = row.getInt("ID_FAMILLE_ARTICLE");
            Categorie s1 = (Categorie)categoriesMap.get(idFamilleArticle);
            if (s1 == null) {
                s1 = cUnclassified;
                categoriesMap.put(idFamilleArticle, cUnclassified);
            }
            if ((name = row.getString("NOM").trim()).length() <= 0) continue;
            Article a = new Article(s1, name, row.getID());
            String barcode = row.getString("CODE_BARRE");
            String code = row.getString("CODE");
            a.setBarCode(StringUtils.isEmpty(barcode, true) ? code : barcode);
            a.setCode(code);
            a.setIdTaxe(row.getInt("ID_TAXE"));
            a.setPriceWithoutTax(row.getBigDecimal("PV_HT"));
            a.setPriceWithTax(row.getBigDecimal("PV_TTC"));
            a.setAdditionalCopyRequested(row.getBoolean("ADDITIONAL_TICKET_COPY"));
            if (row.getInt("ID_UNITE_VENTE") != 2) {
                a.setSalesUnit((String)mapUniteVenteName.get(row.getInt("ID_UNITE_VENTE")));
            }
            if (!favoriteProductsIds.contains(idProduct = Integer.valueOf(a.getId()))) continue;
            favoriteProducts.add(a);
        }
        Categorie.setFavoriteProducts(favoriteProducts);
        this.initCacheArticleMap(dir);
    }

    public static SQLRowAccessor getArticleRowValuesFromCache(int id) {
        return cacheArticle.get(id);
    }

    private void initCacheArticleMap(SQLElementDirectory dir) {
        SQLTable tableArt = dir.getElement("ARTICLE").getTable();
        SQLRowValues rowValsArt = new SQLRowValues(tableArt);
        rowValsArt.putNulls(tableArt.getFieldsName());
        SQLTable tableArtCatComptable = dir.getElement("ARTICLE_CATEGORIE_COMPTABLE").getTable();
        SQLRowValues rowValsArtCatComptable = new SQLRowValues(tableArtCatComptable);
        rowValsArtCatComptable.putNulls(tableArtCatComptable.getFieldsName());
        rowValsArtCatComptable.put("ID_ARTICLE", (Object)rowValsArt);
        SQLRowValues rowValsCaCompt = rowValsArtCatComptable.putRowValues("ID_CATEGORIE_COMPTABLE");
        rowValsCaCompt.putNulls(rowValsCaCompt.getTable().getFieldsName());
        SQLRowValues rowValsFam = rowValsArt.putRowValues("ID_FAMILLE_ARTICLE");
        rowValsFam.putNulls(rowValsFam.getTable().getFieldsName());
        SQLRowValues rowValuesFamP = rowValsFam.putRowValues("ID_FAMILLE_ARTICLE_PERE");
        rowValuesFamP.putNulls(rowValuesFamP.getTable().getFieldsName());
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValsArt);
        List<SQLRowValues> res = fetcher.fetch();
        for (SQLRowValues sqlRowValues : res) {
            cacheArticle.put(sqlRowValues.getID(), sqlRowValues);
        }
    }

    @Override
    public void paint(Graphics g) {
        boolean minimalHeight;
        System.err.println("CaissePanel.paint()" + this.getWidth() + " x " + this.getHeight());
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g.setFont(new Font("Arial", 0, 32));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.controler.isClientDefined()) {
            g.setColor(DARK_BLUE);
            g.setFont(new Font("Arial", 0, 28));
            g.drawString(this.controler.getClient().getFullName(), 20, 75);
            g.setColor(Color.GRAY);
            g.setFont(g.getFont().deriveFont(18.0f));
            g.drawString("Solde : " + new DecimalFormat("#0.00").format(this.controler.getClient().getSolde()), 20, 120);
        }
        int xPos = 300;
        if (this.controler.getPOSConf().getScreenWidth() < 1280) {
            xPos = 270;
        }
        int x = xPos;
        int y = 110;
        g.setColor(Color.BLACK);
        if (this.controler.isClientDefined()) {
            g.setFont(g.getFont().deriveFont(46.0f));
            y += 10;
        } else {
            g.setFont(g.getFont().deriveFont(66.0f));
        }
        int total = this.controler.getTotal();
        String euros = String.valueOf(CaisseControler.getEuros(total)) + ".";
        String cents = CaisseControler.getCents(total);
        Rectangle2D r = g.getFontMetrics().getStringBounds(euros, g);
        g.drawString(euros, x -= (int)r.getWidth(), y);
        g.setFont(g.getFont().deriveFont(40.0f));
        g.drawString(cents, x + (int)r.getWidth(), y);
        y += 40;
        x = xPos;
        int paye = this.controler.getPaidTotal();
        euros = String.valueOf(CaisseControler.getEuros(paye)) + ".";
        cents = CaisseControler.getCents(paye);
        g.setFont(g.getFont().deriveFont(18.0f));
        Rectangle2D r2 = g.getFontMetrics().getStringBounds("Pay\u00e9", g);
        if (paye >= total) {
            g.setColor(Color.DARK_GRAY);
        } else {
            g.setColor(Color.ORANGE);
        }
        g.setFont(g.getFont().deriveFont(32.0f));
        r = g.getFontMetrics().getStringBounds(euros, g);
        g.drawString(euros, x - (int)r.getWidth(), y);
        g.setFont(g.getFont().deriveFont(24.0f));
        g.drawString(cents, x, y);
        g.setFont(g.getFont().deriveFont(18.0f));
        g.setColor(Color.GRAY);
        g.drawString("Pay\u00e9", x - (int)r2.getWidth() - (int)r.getWidth() - 10, y);
        boolean bl = minimalHeight = this.getHeight() < 750;
        if (!minimalHeight) {
            y += 40;
            x = xPos;
        } else {
            x = 140;
        }
        int aRendre = paye - total;
        if (aRendre != 0) {
            String label;
            if (aRendre > 0) {
                label = "Rendu";
            } else {
                label = !minimalHeight ? "Reste \u00e0 payer" : "Doit";
                aRendre = -aRendre;
            }
            euros = String.valueOf(CaisseControler.getEuros(aRendre)) + ".";
            cents = CaisseControler.getCents(aRendre);
            g.setFont(g.getFont().deriveFont(18.0f));
            Rectangle2D r3 = g.getFontMetrics().getStringBounds(label, g);
            g.setColor(Color.DARK_GRAY);
            g.setFont(g.getFont().deriveFont(32.0f));
            r = g.getFontMetrics().getStringBounds(euros, g);
            g.drawString(euros, x - (int)r.getWidth(), y);
            g.setFont(g.getFont().deriveFont(24.0f));
            g.drawString(cents, x, y);
            g.setFont(g.getFont().deriveFont(18.0f));
            g.setColor(Color.GRAY);
            g.drawString(label, x - (int)r3.getWidth() - (int)r.getWidth() - 10, y);
        }
    }

    @Override
    public void caisseStateChanged() {
        this.repaint();
    }

    public void switchListMode() {
        GridBagConstraints c = ((GridBagLayout)this.getLayout()).getConstraints(this.selector);
        this.remove(this.selector);
        this.selector = this.selector == this.articleSearchPanel ? this.articleSelectorPanel : this.articleSearchPanel;
        System.err.println("CaissePanel.switchListMode()" + this.selector.getMinimumSize() + " " + this.selector.getPreferredSize() + " " + this.selector.getMaximumSize());
        this.add((Component)this.selector, c);
        this.validate();
        this.repaint();
    }

    public boolean isModeSearch() {
        return this.selector == this.articleSearchPanel;
    }

    public CaisseControler getControler() {
        return this.controler;
    }

    public void validateTicket(CaisseFrame caisseFrame) {
        Ticket savedReceipt;
        try {
            savedReceipt = this.controler.saveAndClearTicket(caisseFrame.getFiles(), caisseFrame.getConf().getDirectory());
        }
        catch (RegisterFiles.DifferentDayException ex) {
            JOptionPane.showMessageDialog(this, "Impossible de laisser la caisse ouverte plusieurs jours. Veuillez la cl\u00c3\u00b4turer pour pouvoir faire de nouveaux tickets.", "Erreur", 0);
            return;
        }
        catch (Throwable ex) {
            ExceptionHandler.handle(this, "Erreur de sauvegarde des informations du ticket", ex);
            return;
        }
        if (savedReceipt != null) {
            this.controler.setLCD("Impression de", "votre ticket...", 0);
            try {
                caisseFrame.getPOSConf().print((Printable)savedReceipt, savedReceipt.isAdditionnalCopyRequested() ? 1 : 0);
            }
            catch (UnsatisfiedLinkError ex) {
                JOptionPane.showMessageDialog(this, "Erreur de configuration de la liaison \u00e0 l'imprimante");
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "Erreur d'impression du ticket");
            }
            this.controler.setLCDDefaultDisplay(2);
        } else {
            System.err.println("CaissePanel.validateTicket() ticket non sauv\u00e9");
        }
    }
}

