/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.common.element.StyleSQLElement;
import org.openconcerto.erp.core.humanresources.payroll.report.GroupePayeSimplifiee;
import org.openconcerto.erp.core.humanresources.payroll.report.LignePayeSimplifiee;
import org.openconcerto.erp.core.humanresources.payroll.report.StructurePayeSimplifiee;
import org.openconcerto.erp.generationDoc.AbstractSheetXMLWithDate;
import org.openconcerto.erp.preferences.PayeGlobalPreferencePanel;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.utils.cc.ITransformer;

public class FichePayeSheetXML
extends AbstractSheetXMLWithDate {
    public static final String TEMPLATE_ID = "FichePayeSimplifiee";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationFichePaye";
    final Map<Integer, String> cotisationSimplifieeLink = new HashMap<Integer, String>();
    private StyleSQLElement eltStyle = Configuration.getInstance().getDirectory().getElement(StyleSQLElement.class);

    public FichePayeSheetXML(SQLRow row) {
        this(row, !new SQLPreferences(row.getTable().getDBRoot()).getBoolean(PayeGlobalPreferencePanel.NOT_PAYE_SIMPL, Boolean.FALSE));
    }

    public FichePayeSheetXML(SQLRow row, boolean simplifie) {
        super(row);
        this.printer = PrinterNXProps.getInstance().getStringProperty("FichePayePrinter");
        this.elt = Configuration.getInstance().getDirectory().getElement("FICHE_PAYE");
        if (simplifie) {
            SQLSelect sel = new SQLSelect();
            sel.addSelect(row.getTable().getDBRoot().findTable("RUBRIQUE_COTISATION").getField("LIGNE_PAYE_SIMPLIFIEE"));
            sel.addSelect(row.getTable().getDBRoot().findTable("RUBRIQUE_COTISATION").getKey());
            List<SQLRow> rubCotis = SQLRowListRSH.execute(sel);
            for (SQLRow sqlRow : rubCotis) {
                this.cotisationSimplifieeLink.put(sqlRow.getID(), sqlRow.getString("LIGNE_PAYE_SIMPLIFIEE"));
            }
            String codeStatu = row.getForeign("ID_SALARIE").getForeign("ID_INFOS_SALARIE_PAYE").getForeign("ID_CONTRAT_SALARIE").getForeign("ID_CODE_STATUT_CATEGORIEL").getString("CODE");
            final boolean cadre = codeStatu.equals("01") || codeStatu.equals("02");
            final HashSet<Integer> ignoredRubriqueComm = new HashSet<Integer>();
            ignoredRubriqueComm.add(2);
            ignoredRubriqueComm.add(7);
            ignoredRubriqueComm.add(4);
            ignoredRubriqueComm.add(5);
            this.setPostProcess(new ITransformer<List<SQLRowAccessor>, List<SQLRowAccessor>>(){

                @Override
                public List<SQLRowAccessor> transformChecked(List<SQLRowAccessor> input) {
                    ArrayList<SQLRowAccessor> result = new ArrayList<SQLRowAccessor>(input.size());
                    ArrayList resultCom = new ArrayList(input.size());
                    ArrayList<SQLRowAccessor> resultNet = new ArrayList<SQLRowAccessor>(input.size());
                    ArrayList resultCotis = new ArrayList(input.size());
                    Map mapLigneSimplifiee = FichePayeSheetXML.this.initCotisations(cadre, resultCotis);
                    for (SQLRowAccessor sqlRowAccessor : input) {
                        SQLRowValues rowValsToAdd;
                        SQLRowValues rowValsTitle;
                        if (!sqlRowAccessor.getBoolean("IN_PERIODE").booleanValue()) continue;
                        if (sqlRowAccessor.getString("SOURCE").equals("RUBRIQUE_BRUT")) {
                            if (result.size() == 0) {
                                rowValsTitle = new SQLRowValues(sqlRowAccessor.getTable());
                                rowValsTitle.put("ID_STYLE", FichePayeSheetXML.this.eltStyle.getAllStyleByName().get("Titre 1"));
                                rowValsTitle.put("NOM", "Rubrique de brut");
                                rowValsTitle.put("IMPRESSION", Boolean.TRUE);
                                rowValsTitle.put("IN_PERIODE", Boolean.TRUE);
                                result.add(rowValsTitle);
                            }
                            rowValsToAdd = sqlRowAccessor.asRowValues();
                            rowValsToAdd.put("ID_STYLE", 2);
                            result.add(rowValsToAdd);
                        }
                        if (sqlRowAccessor.getString("SOURCE").equals("RUBRIQUE_NET") && sqlRowAccessor.getBoolean("IMPRESSION").booleanValue() && sqlRowAccessor.getBoolean("IN_PERIODE").booleanValue()) {
                            if (resultNet.size() == 0) {
                                rowValsTitle = new SQLRowValues(sqlRowAccessor.getTable());
                                rowValsTitle.put("ID_STYLE", FichePayeSheetXML.this.eltStyle.getAllStyleByName().get("Titre 1"));
                                rowValsTitle.put("NOM", "Rubrique de net");
                                rowValsTitle.put("IMPRESSION", Boolean.TRUE);
                                rowValsTitle.put("IN_PERIODE", Boolean.TRUE);
                                resultNet.add(rowValsTitle);
                            }
                            rowValsToAdd = sqlRowAccessor.asRowValues();
                            rowValsToAdd.put("ID_STYLE", 2);
                            resultNet.add(rowValsToAdd);
                        }
                        if (sqlRowAccessor.getString("SOURCE").equals("RUBRIQUE_COMM") && !ignoredRubriqueComm.contains(sqlRowAccessor.getInt("IDSOURCE"))) {
                            if (resultNet.size() == 0) {
                                result.add(sqlRowAccessor);
                            } else {
                                resultNet.add(sqlRowAccessor);
                            }
                        }
                        if (!sqlRowAccessor.getString("SOURCE").equals("RUBRIQUE_COTISATION")) continue;
                        FichePayeSheetXML.this.cumuls(sqlRowAccessor, mapLigneSimplifiee, cadre);
                    }
                    result.addAll(resultNet);
                    result.addAll(resultCom);
                    result.addAll(resultCotis);
                    return result;
                }
            });
        }
    }

    private void cumuls(final SQLRowAccessor sqlRowAccessor, Map<String, SQLRowValues> mapLigneSimplifiee, final boolean cadre) {
        String idLigneSimplifiee = this.cotisationSimplifieeLink.get(sqlRowAccessor.getInt("IDSOURCE"));
        if (idLigneSimplifiee == null || idLigneSimplifiee.trim().length() == 0) {
            final SQLRow rowRub = sqlRowAccessor.getTable().getDBRoot().findTable("RUBRIQUE_COTISATION").getRow(sqlRowAccessor.getInt("IDSOURCE"));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "Aucune liaison d\u00e9finie vers une ligne de bulletin simplifi\u00e9 pour la cotisation " + rowRub.getString("CODE") + " - " + rowRub.getString("NOM") + ".\n La liaison sera faite sur autres contributions dues par l'employeur!");
                }
            });
            idLigneSimplifiee = LignePayeSimplifiee.AUTRES_CONTRIBUTIONS.getId();
        }
        if (!idLigneSimplifiee.equals(LignePayeSimplifiee.IGNORE.getId())) {
            SQLRowValues ligneSimplifiee = mapLigneSimplifiee.get(idLigneSimplifiee);
            if (ligneSimplifiee == null) {
                final LignePayeSimplifiee fromID = LignePayeSimplifiee.fromID(idLigneSimplifiee);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Aucune ligne simplifi\u00e9e " + (Object)((Object)fromID) + " dans le bulletin " + (cadre ? "cadre!" : "non cadre!") + "\n La ligne " + sqlRowAccessor.getString("NOM") + " a \u00e9t\u00e9 ignor\u00e9!");
                    }
                });
            } else {
                BigDecimal montantPatBulletinSimpl = BigDecimal.ZERO;
                BigDecimal montantSalBulletinSimpl = BigDecimal.ZERO;
                if (ligneSimplifiee.getBigDecimal("MONTANT_SAL_DED") != null) {
                    montantSalBulletinSimpl = ligneSimplifiee.getBigDecimal("MONTANT_SAL_DED");
                }
                if (ligneSimplifiee.getBigDecimal("MONTANT_PAT") != null) {
                    montantPatBulletinSimpl = ligneSimplifiee.getBigDecimal("MONTANT_PAT");
                }
                BigDecimal montantPatLigne = BigDecimal.ZERO;
                BigDecimal montantSalLigne = BigDecimal.ZERO;
                if (sqlRowAccessor.getBigDecimal("MONTANT_SAL_DED") != null) {
                    montantSalLigne = sqlRowAccessor.getBigDecimal("MONTANT_SAL_DED");
                }
                if (sqlRowAccessor.getBigDecimal("MONTANT_PAT") != null) {
                    montantPatLigne = sqlRowAccessor.getBigDecimal("MONTANT_PAT");
                }
                if (montantPatLigne.add(montantSalLigne).signum() != 0) {
                    ligneSimplifiee.put("NB_BASE", sqlRowAccessor.getBigDecimal("NB_BASE"));
                    ligneSimplifiee.put("MONTANT_SAL_DED", montantSalBulletinSimpl.add(montantSalLigne));
                    ligneSimplifiee.put("MONTANT_PAT", montantPatBulletinSimpl.add(montantPatLigne));
                }
                BigDecimal tauxPatBulletinSimpl = BigDecimal.ZERO;
                BigDecimal tauxSalBulletinSimpl = BigDecimal.ZERO;
                if (ligneSimplifiee.getBigDecimal("TAUX_SAL") != null) {
                    tauxSalBulletinSimpl = ligneSimplifiee.getBigDecimal("TAUX_SAL");
                }
                if (ligneSimplifiee.getBigDecimal("TAUX_PAT") != null) {
                    tauxPatBulletinSimpl = ligneSimplifiee.getBigDecimal("TAUX_PAT");
                }
                BigDecimal tauxPatLigne = BigDecimal.ZERO;
                BigDecimal tauxSalLigne = BigDecimal.ZERO;
                if (sqlRowAccessor.getBigDecimal("TAUX_SAL") != null) {
                    tauxSalLigne = sqlRowAccessor.getBigDecimal("TAUX_SAL");
                }
                if (sqlRowAccessor.getBigDecimal("TAUX_PAT") != null) {
                    tauxPatLigne = sqlRowAccessor.getBigDecimal("TAUX_PAT");
                }
                if (tauxSalLigne.signum() > 0 && montantSalLigne.signum() != 0) {
                    ligneSimplifiee.put("TAUX_SAL", tauxSalBulletinSimpl.add(tauxSalLigne));
                }
                if (tauxPatLigne.signum() > 0 && montantPatLigne.signum() != 0) {
                    ligneSimplifiee.put("TAUX_PAT", tauxPatBulletinSimpl.add(tauxPatLigne));
                }
            }
        }
    }

    private Map<String, SQLRowValues> initCotisations(boolean cadre, List<SQLRowAccessor> resultCotis) {
        SQLTable tableFichePayeElt = this.row.getTable().getDBRoot().findTable("FICHE_PAYE_ELEMENT");
        SQLRowValues rowValsCotis = new SQLRowValues(tableFichePayeElt);
        rowValsCotis.put("ID_STYLE", this.eltStyle.getAllStyleByName().get("Titre 2"));
        rowValsCotis.put("NOM", "Cotisations et contributions sociales");
        rowValsCotis.put("IMPRESSION", Boolean.TRUE);
        rowValsCotis.put("IN_PERIODE", Boolean.TRUE);
        resultCotis.add(rowValsCotis);
        HashMap<String, SQLRowValues> mapPayeSimplifiee = new HashMap<String, SQLRowValues>();
        List<GroupePayeSimplifiee> listGroupe = cadre ? StructurePayeSimplifiee.getStructureCadre() : StructurePayeSimplifiee.getStructureNonCadre();
        for (GroupePayeSimplifiee groupe : listGroupe) {
            SQLRowValues rowValsFichePaye = new SQLRowValues(tableFichePayeElt);
            rowValsFichePaye.put("NOM", groupe.getTranslation());
            rowValsFichePaye.put("IMPRESSION", Boolean.TRUE);
            rowValsFichePaye.put("IN_PERIODE", Boolean.TRUE);
            rowValsFichePaye.put("ID_STYLE", this.eltStyle.getAllStyleByName().get("Normal"));
            resultCotis.add(rowValsFichePaye);
            mapPayeSimplifiee.put(groupe.getId(), rowValsFichePaye);
            for (LignePayeSimplifiee lignePayeSimplifiee : groupe.getChildren()) {
                if (groupe.isShowChildren()) {
                    SQLRowValues rowValsLPaye = new SQLRowValues(tableFichePayeElt);
                    rowValsLPaye.put("NOM", lignePayeSimplifiee.getTranslation());
                    rowValsLPaye.put("IMPRESSION", Boolean.TRUE);
                    rowValsLPaye.put("IN_PERIODE", Boolean.TRUE);
                    rowValsLPaye.put("ID_STYLE", this.eltStyle.getAllStyleByName().get("Normal"));
                    mapPayeSimplifiee.put(lignePayeSimplifiee.getId(), rowValsLPaye);
                    resultCotis.add(rowValsLPaye);
                    continue;
                }
                mapPayeSimplifiee.put(lignePayeSimplifiee.getId(), rowValsFichePaye);
            }
        }
        return mapPayeSimplifiee;
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    public String getName() {
        SQLPreferences prefs = new SQLPreferences(this.elt.getTable().getDBRoot());
        boolean prefNomSal = prefs.getBoolean(PayeGlobalPreferencePanel.SALARIE_NOM_FICHIER, Boolean.FALSE);
        SQLRow rowSal = this.row.getForeign("ID_SALARIE");
        SQLRow rowMois = this.row.getForeign("ID_MOIS");
        Calendar du = this.row.getDate("DU");
        String suffix = "";
        if (prefNomSal) {
            suffix = "_" + rowSal.getString("NOM");
        }
        if (du != null && du.get(5) != 1) {
            suffix = "_" + du.get(5);
        }
        return "FichePaye_" + rowSal.getString("CODE") + suffix + "_" + rowMois.getString("NOM") + "_" + this.row.getString("ANNEE");
    }
}

