/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.LightUIElement;

public class LightUIButton
extends LightUIElement {
    protected transient List<ActionListener> clickListeners = new ArrayList<ActionListener>();

    public LightUIButton() {
    }

    public LightUIButton(JSONObject json) {
        super(json);
    }

    public LightUIButton(String id) {
        super(id);
        this.init(20);
    }

    public LightUIButton(String id, String text) {
        super(id);
        this.init(20);
        this.setLabel(text);
    }

    protected LightUIButton(String id, int buttonType) {
        super(id);
        this.init(buttonType);
    }

    protected LightUIButton(String id, int buttonType, String text) {
        super(id);
        this.init(buttonType);
        this.setLabel(text);
    }

    public void setText(String text) {
        this.setLabel(text);
    }

    private void init(int buttonType) {
        this.setType(buttonType);
    }

    public LightUIButton(LightUIButton button) {
        super(button);
    }

    public void addClickListener(ActionListener listener) {
        if (!this.clickListeners.contains(listener)) {
            this.clickListeners.add(listener);
        }
    }

    public void removeClickListener(ActionListener listener) {
        this.clickListeners.remove(listener);
    }

    public List<ActionListener> getClickListeners() {
        return Collections.unmodifiableList(this.clickListeners);
    }

    public void fireClick() {
        ArrayList<ActionListener> listeners = new ArrayList<ActionListener>(this.clickListeners.size());
        listeners.addAll(this.clickListeners);
        for (ActionListener listener : listeners) {
            listener.actionPerformed(new ActionEvent(this, 1, "click"));
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.clickListeners = null;
    }
}

