/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.Order;
import org.openconcerto.sql.model.SQLDataListener;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowMode;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableListenerData;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.Tuple2;

public class SQLRow
extends SQLRowAccessor {
    public static final int UNDEFINED_ID = 1;
    public static final int MIN_VALID_ID = 0;
    public static final int NONEXISTANT_ID = -1;
    public static final boolean printSTForMissingField = false;
    private final int ID;
    private final Number idNumber;
    private Map<String, Object> values;
    private boolean fetched = false;
    private static final SQLTable.VirtualFields ALL_VALUES_FIELDS = SQLTable.VirtualFields.ALL.difference(SQLTable.VirtualFields.KEYS, SQLTable.VirtualFields.ARCHIVE, SQLTable.VirtualFields.ORDER);

    public static final SQLRow createFromRS(SQLTable table, ResultSet rs, boolean onlyTable) throws SQLException {
        return SQLRow.createFromRS(table, rs, rs.getMetaData(), onlyTable);
    }

    public static final SQLRow createFromRS(SQLTable table, ResultSet rs, ResultSetMetaData rsmd, boolean onlyTable) throws SQLException {
        return SQLRow.createFromRS(table, rs, SQLRow.getFieldNames(table, rsmd, onlyTable));
    }

    private static final List<String> getFieldNames(SQLTable table, ResultSetMetaData rsmd, boolean tableOnly) throws SQLException {
        int colCount = rsmd.getColumnCount();
        ArrayList<String> names = new ArrayList<String>(colCount);
        int i = 1;
        while (i <= colCount) {
            if (tableOnly || rsmd.getTableName(i).equals(table.getName())) {
                names.add(rsmd.getColumnName(i));
            } else {
                names.add(null);
            }
            ++i;
        }
        return names;
    }

    static final SQLRow createFromRS(SQLTable table, ResultSet rs, List<String> names) throws SQLException {
        int indexCount = names.size();
        HashMap<String, Object> m = new HashMap<String, Object>(indexCount);
        int i = 0;
        while (i < indexCount) {
            String colName = names.get(i);
            if (colName != null) {
                m.put(colName, rs.getObject(i + 1));
            }
            ++i;
        }
        Number id = SQLRow.getID(m, table, true);
        if (id == null) {
            return null;
        }
        return new SQLRow(table, id, m);
    }

    public static final List<SQLRow> createListFromRS(SQLTable table, ResultSet rs, boolean tableOnly) throws SQLException {
        return SQLRow.createListFromRS(table, rs, SQLRow.getFieldNames(table, rs.getMetaData(), tableOnly));
    }

    static final List<SQLRow> createListFromRS(SQLTable table, ResultSet rs, List<String> names) throws SQLException {
        ArrayList<SQLRow> res = new ArrayList<SQLRow>();
        while (rs.next()) {
            SQLRow row = SQLRow.createFromRS(table, rs, names);
            if (row == null) continue;
            res.add(row);
        }
        return res;
    }

    static final SQLRow createFromSelect(SQLTable t, SQLTable.VirtualFields vfs, int id, SQLSelect.LockStrength l) {
        SQLSelect sel = new SQLSelect(true).addAllSelect(t.getFields(vfs));
        sel.setLockStrength(l);
        sel.setWhere(new Where((FieldRef)t.getKey(), "=", id));
        Map map = (Map)t.getDBSystemRoot().getDataSource().execute(sel.asString(), new IResultSetHandler(SQLDataSource.MAP_HANDLER, l.equals((Object)SQLSelect.LockStrength.NONE)));
        return new SQLRow(t, id, map);
    }

    static final SQLRow createEmpty(SQLTable t, int id) {
        return new SQLRow(t, id, Collections.emptyMap());
    }

    private SQLRow(SQLTable table, Number id) {
        super(table);
        this.ID = id.intValue();
        this.idNumber = id;
        this.checkTable();
    }

    public SQLRow(SQLTable table, int ID) {
        this(table, table.getKey().getType().getJavaType() == Integer.class ? (Number)ID : (Number)Long.valueOf(ID));
    }

    private void checkTable() {
        if (!this.getTable().isRowable()) {
            throw new IllegalArgumentException(this.getTable() + " is not rowable");
        }
    }

    public SQLRow(SQLTable table, Map<String, ?> values) {
        this(table, null, values);
    }

    private SQLRow(SQLTable table, Number id, Map<String, ?> values) {
        this(table, id == null ? (Number)SQLRow.getID(values, table, false) : (Number)id);
        this.setValues(values == null ? null : new HashMap(values));
    }

    private static Number getID(Map<String, ?> values, SQLTable table, boolean nullAllowed) {
        String keyName = table.getKey().getName();
        if (!values.containsKey(keyName)) {
            throw new IllegalArgumentException(values + " does not contain the key of " + table);
        }
        Object keyValue = values.get(keyName);
        if (keyValue instanceof Number) {
            return (Number)keyValue;
        }
        if (nullAllowed && keyValue == null) {
            return null;
        }
        String valS = keyValue == null ? "' is null" : "' isn't a Number : " + keyValue.getClass() + " " + keyValue;
        throw new IllegalArgumentException("The value of '" + keyName + valS);
    }

    public final boolean isFilled() {
        return this.fetched;
    }

    @Override
    protected void initValues() {
        if (!this.isFilled()) {
            this.fetchValues();
        }
    }

    private Map<String, Object> getValues() {
        this.initValues();
        return this.values;
    }

    public final void fetchValues() {
        this.fetchValues(true);
    }

    public final SQLRow fetchValues(boolean useCache) {
        return this.fetchValues(useCache, useCache);
    }

    public final SQLRow fetchNew(boolean useCache) {
        return new SQLRow(this.getTable(), this.getIDNumber()).fetchValues(useCache);
    }

    SQLRow fetchValues(boolean readCache, boolean writeCache) {
        IResultSetHandler handler = new IResultSetHandler(SQLDataSource.MAP_HANDLER, readCache, writeCache){

            public Set<SQLRow> getCacheModifiers() {
                return Collections.singleton(SQLRow.this);
            }
        };
        this.setValues((Map)this.getTable().getBase().getDataSource().execute(this.getQuery(), (ResultSetHandler)handler, false));
        return this;
    }

    private final void setValues(Map<String, Object> values) {
        this.values = values;
        if (!this.fetched) {
            this.fetched = true;
        }
    }

    @Override
    public Set<String> getFields() {
        return this.fetched ? Collections.unmodifiableSet(this.getValues().keySet()) : Collections.emptySet();
    }

    @Override
    public boolean contains(String fieldName) {
        return this.fetched ? this.getValues().containsKey(fieldName) : false;
    }

    private String getQuery() {
        return "SELECT * FROM " + this.getTable().getSQLName().quote() + " WHERE " + this.getWhere().getClause();
    }

    public Where getWhere() {
        return new Where((FieldRef)this.getTable().getKey(), "=", this.getID());
    }

    public boolean exists() {
        return this.getValues() != null;
    }

    public boolean isValid() {
        return this.exists() && this.getID() >= 0 && !this.isArchived();
    }

    public boolean isData() {
        return this.isValid() && !this.isUndefined();
    }

    @Override
    public final Object getObject(String field) {
        if (!this.exists()) {
            throw new IllegalStateException("The row " + this + "does not exist.");
        }
        if (!this.getTable().contains(field)) {
            throw new IllegalArgumentException("The table of the row " + this + " doesn't contain the field '" + field + "'.");
        }
        if (!this.getValues().containsKey(field)) {
            this.fetchValues();
            String msg = "The row " + this.simpleToString() + " doesn't contain the field '" + field + "' ; refetching.";
            Log.get().warning(msg);
        }
        assert (this.getValues().containsKey(field));
        return this.getValues().get(field);
    }

    public final Tuple2.List2<SQLRow> fetchThisAndSequentialRow(boolean after) throws IllegalStateException {
        if (this.isUndefined()) {
            throw new IllegalStateException("Cannot order against the undefined");
        }
        SQLTable t = this.getTable();
        int diff = !after ? -1 : 1;
        SQLSelect selOrder = new SQLSelect();
        selOrder.setArchivedPolicy(SQLSelect.BOTH);
        selOrder.addSelect(t.getOrderField());
        selOrder.setWhere(this.getWhere());
        selOrder.setLockStrength(SQLSelect.LockStrength.UPDATE);
        SQLSelect sel = new SQLSelect();
        sel.setExcludeUndefined(false);
        sel.setArchivedPolicy(SQLSelect.BOTH);
        sel.addSelect(t.getKey());
        sel.addSelect(t.getOrderField());
        if (t.isArchivable()) {
            sel.addSelect(t.getArchiveField());
        }
        Where orderWhere = Where.createRaw(String.valueOf(t.getOrderField().getFieldRef()) + (diff < 0 ? "<=" : ">=") + "(" + selOrder + ")", t.getOrderField());
        sel.setWhere(orderWhere.or(this.getWhere()));
        sel.addFieldOrder(t.getOrderField(), diff < 0 ? Order.desc() : Order.asc());
        sel.setLimit(2);
        sel.setLockStrength(SQLSelect.LockStrength.UPDATE);
        List<SQLRow> rows = SQLRowListRSH.execute(sel);
        assert (rows.size() <= 2);
        if (rows.isEmpty()) {
            return null;
        }
        assert (rows.get(0).equals(this));
        return new Tuple2.List2<Object>(rows.get(0), (rows.size() == 1 ? null : rows.get(1)));
    }

    @Override
    public SQLRow getForeign(String fieldName) {
        return this.getForeignRow(fieldName);
    }

    public SQLRow getForeignRow(String field) {
        return this.getForeignRow(field, SQLRowMode.EXIST);
    }

    public SQLRow getForeignRow(String field, SQLRowMode mode) {
        SQLField f = this.getTable().getField(field);
        Link foreignLink = this.getTable().getDBSystemRoot().getGraph().getForeignLink(f);
        if (foreignLink == null) {
            throw new IllegalArgumentException(String.valueOf(field) + " is not a foreign key of " + this.getTable());
        }
        return this.getUncheckedForeignRow(foreignLink, mode);
    }

    public SQLRow getForeignRow(Link foreignLink, SQLRowMode mode) {
        if (!((SQLTable)foreignLink.getSource()).equals(this.getTable())) {
            throw new IllegalArgumentException(foreignLink + " is not a foreign key of " + this.getTable());
        }
        return this.getUncheckedForeignRow(foreignLink, mode);
    }

    private SQLRow getUncheckedForeignRow(Link foreignLink, SQLRowMode mode) {
        SQLField field = foreignLink.getLabel();
        SQLTable foreignTable = (SQLTable)foreignLink.getTarget();
        if (this.getObject(field.getName()) == null) {
            return null;
        }
        int foreignID = this.getInt(field.getName());
        SQLRow foreignRow = new SQLRow(foreignTable, foreignID);
        return mode.filter(foreignRow);
    }

    public Set<SQLRow> getLinkedRows(String destTable) {
        return this.getDistantRows(Collections.singletonList(destTable));
    }

    public Set<SQLRow> getForeignRows(String destTable) {
        return this.getForeignRows(destTable, SQLRowMode.DATA);
    }

    public Set<SQLRow> getForeignRows(String destTable, SQLRowMode mode) {
        return new HashSet<SQLRow>(this.getForeignRowsMap(destTable, mode).values());
    }

    public Set<SQLRow> getForeignRows() {
        return this.getForeignRows(SQLRowMode.DATA);
    }

    public Set<SQLRow> getForeignRows(SQLRowMode mode) {
        return new HashSet<SQLRow>(this.getForeignRowsMap(mode).values());
    }

    public Map<SQLField, SQLRow> getForeignRowsMap(String destTable) {
        return this.getForeignRowsMap(destTable, SQLRowMode.DATA);
    }

    public Map<SQLField, SQLRow> getForeignRowsMap(String destTable, SQLRowMode mode) {
        Set<Link> links = this.getTable().getDBSystemRoot().getGraph().getForeignLinks(this.getTable(), this.getTable().getTable(destTable));
        return this.foreignLinksToMap(links, mode);
    }

    public Map<SQLField, SQLRow> getForeignRowsMap() {
        return this.getForeignRowsMap(SQLRowMode.DATA);
    }

    public Map<SQLField, SQLRow> getForeignRowsMap(SQLRowMode mode) {
        return this.foreignLinksToMap(this.getTable().getForeignLinks(), mode);
    }

    private Map<SQLField, SQLRow> foreignLinksToMap(Collection<Link> links, SQLRowMode mode) {
        HashMap<SQLField, SQLRow> res = new HashMap<SQLField, SQLRow>();
        for (Link l : links) {
            SQLRow fr = this.getUncheckedForeignRow(l, mode);
            if (fr == null) continue;
            res.put(l.getLabel(), fr);
        }
        return res;
    }

    public SQLRow getDistantRow(List<String> path) {
        return this.getDistantRow((Path)Path.get(this.getTable()).addTables((List)path));
    }

    public SQLRow getDistantRow(Path path) {
        Set<SQLRow> rows = this.getDistantRows(path);
        if (rows.size() != 1) {
            throw new IllegalStateException("the path " + path + " does not lead to a unique row (" + rows.size() + ")");
        }
        return rows.iterator().next();
    }

    public Set<SQLRow> getDistantRows(List<String> path) {
        return this.getDistantRows((Path)Path.get(this.getTable()).addTables((List)path));
    }

    public Set<SQLRow> getDistantRows(Path path) {
        return this.getDistantRows(path, SQLSelect.ArchiveMode.UNARCHIVED);
    }

    public Set<SQLRow> getDistantRows(Path path, SQLSelect.ArchiveMode archiveMode) {
        return this.getDistantRows(path, archiveMode, true);
    }

    public Set<SQLRow> getDistantRows(Path path, SQLSelect.ArchiveMode archiveMode, boolean orderLast) {
        return (Set)this.getDistantRows(path, archiveMode, orderLast, false);
    }

    public List<SQLRow> getDistantRowsList(Path path, SQLSelect.ArchiveMode archiveMode) {
        return this.getDistantRowsList(path, archiveMode, false);
    }

    public List<SQLRow> getDistantRowsList(Path path, SQLSelect.ArchiveMode archiveMode, boolean orderLast) {
        return (List)this.getDistantRows(path, archiveMode, orderLast, true);
    }

    private Collection<SQLRow> getDistantRows(Path path, SQLSelect.ArchiveMode archiveMode, boolean orderLast, boolean list) {
        AbstractCollection res;
        if (path.length() == 0) {
            if (SQLRowMode.check(archiveMode, this)) {
                return list ? Collections.singletonList(this) : Collections.singleton(this);
            }
            return list ? Collections.emptyList() : Collections.emptySet();
        }
        ArrayList fields = new ArrayList(Collections.nCopies(path.length() - 1, Collections.emptyList()));
        fields.add(null);
        List<List<SQLRow>> s = this.getRowsOnPath(path, fields, archiveMode, orderLast);
        ArrayList resList = list ? new ArrayList(s.size()) : null;
        LinkedHashSet resSet = list ? null : new LinkedHashSet(s.size());
        AbstractCollection abstractCollection = res = list ? resList : resSet;
        assert (res != null);
        for (List<SQLRow> l : s) {
            assert (l.size() == 1) : "Too many rows were created : " + l;
            res.add(l.get(0));
        }
        return list ? Collections.unmodifiableList(resList) : Collections.unmodifiableSet(resSet);
    }

    public List<List<SQLRow>> getRowsOnPath(List<String> path, List<? extends Collection<String>> fields) {
        return this.getRowsOnPath((Path)Path.get(this.getTable()).addTables((List)path), fields);
    }

    public List<List<SQLRow>> getRowsOnPath(Path p, List<? extends Collection<String>> fields) {
        return this.getRowsOnPath(p, fields, SQLSelect.ArchiveMode.UNARCHIVED);
    }

    public List<List<SQLRow>> getRowsOnPath(Path p, List<? extends Collection<String>> fields, SQLSelect.ArchiveMode archiveMode) {
        return this.getRowsOnPath(p, fields, archiveMode, true);
    }

    public List<List<SQLRow>> getRowsOnPath(final Path p, List<? extends Collection<String>> fields, SQLSelect.ArchiveMode archiveMode, boolean orderLast) {
        final int pathSize = p.length();
        if (pathSize == 0) {
            throw new IllegalArgumentException("path is empty");
        }
        if (pathSize != fields.size()) {
            throw new IllegalArgumentException("path and fields size mismatch : " + pathSize + " != " + fields.size());
        }
        if (p.getFirst() != this.getTable()) {
            throw new IllegalArgumentException("path doesn't start with us : " + p.getFirst() + " != " + this.getTable());
        }
        final ArrayList<List<SQLRow>> res = new ArrayList<List<SQLRow>>();
        DBSystemRoot sysRoot = this.getTable().getDBSystemRoot();
        Where where = sysRoot.getGraph().getJointure(p);
        where = where.and(this.getWhere());
        SQLSelect select = new SQLSelect();
        select.setArchivedPolicy(archiveMode);
        final ArrayList<Collection<String>> fieldsCols = new ArrayList<Collection<String>>(pathSize);
        int i = 0;
        while (i < pathSize) {
            Collection<String> tableFields = fields.get(i);
            SQLTable t = p.getTable(i + 1);
            Collection<String> fieldsCol = tableFields == null ? t.getFieldsName() : tableFields;
            fieldsCols.add(fieldsCol);
            if (fieldsCol.size() > 0) {
                select.addSelect(t.getKey());
                select.addAllSelect(t, fieldsCol);
            }
            if (!orderLast) {
                select.addOrder(t);
            }
            ++i;
        }
        SQLTable lastTable = p.getLast();
        select.addSelect(lastTable.getKey());
        select.setWhere(where);
        if (orderLast) {
            select.addOrderSilent(lastTable.getName());
            select.addFieldOrder(lastTable.getKey());
        }
        sysRoot.getDataSource().execute(select.asString(), new ResultSetHandler(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                ResultSetMetaData rsmd = rs.getMetaData();
                while (rs.next()) {
                    ArrayList<SQLRow> rows = new ArrayList<SQLRow>(pathSize);
                    int i = 0;
                    while (i < pathSize) {
                        if (((Collection)fieldsCols.get(i)).size() > 0) {
                            SQLTable t = p.getTable(i + 1);
                            rows.add(SQLRow.createFromRS(t, rs, rsmd, pathSize == 1));
                        }
                        ++i;
                    }
                    res.add(rows);
                }
                return null;
            }
        });
        return res;
    }

    public final List<SQLRow> getReferentRows() {
        return this.getReferentRows((Set<SQLTable>)null);
    }

    public final List<SQLRow> getReferentRows(SQLTable refTable) {
        return this.getReferentRows(Collections.singleton(refTable));
    }

    public final List<SQLRow> getReferentRows(Set<SQLTable> tables) {
        return this.getReferentRows(tables, SQLSelect.UNARCHIVED);
    }

    private final SetMap<SQLTable, Link> getReferentLinks(Set<SQLTable> tables) {
        Set<Link> links = this.getTable().getBase().getGraph().getReferentLinks(this.getTable());
        SetMap<SQLTable, Link> byTable = new SetMap<SQLTable, Link>();
        for (Link l : links) {
            SQLTable src = (SQLTable)l.getSource();
            if (tables != null && (tables == null || !tables.contains(src))) continue;
            byTable.add(src, l);
        }
        return byTable;
    }

    public final List<SQLRow> getReferentRows(Set<SQLTable> tables, SQLSelect.ArchiveMode archived) {
        SetMap<SQLTable, Link> byTable = this.getReferentLinks(tables);
        LinkedHashSet<SQLRow> res = new LinkedHashSet<SQLRow>();
        for (Map.Entry e : byTable.entrySet()) {
            res.addAll(this.getReferentRows((Set)e.getValue(), archived, null));
        }
        return new ArrayList<SQLRow>(res);
    }

    public final ListMap<Link, SQLRow> getReferentRowsByLink() {
        return this.getReferentRowsByLink(null);
    }

    public final ListMap<Link, SQLRow> getReferentRowsByLink(Set<SQLTable> tables) {
        return this.getReferentRowsByLink(tables, SQLSelect.UNARCHIVED);
    }

    public final ListMap<Link, SQLRow> getReferentRowsByLink(Set<SQLTable> tables, SQLSelect.ArchiveMode archived) {
        ListMap<Link, SQLRow> res = new ListMap<Link, SQLRow>();
        SetMap<SQLTable, Link> byTable = this.getReferentLinks(tables);
        for (Map.Entry e : byTable.entrySet()) {
            Set links = (Set)e.getValue();
            List<SQLRow> rows = this.getReferentRows(links, archived, null);
            for (Link l : links) {
                res.put(l, Collections.emptyList());
                for (SQLRow r : rows) {
                    if (r.getForeignID(l.getLabel().getName()) != this.getID()) continue;
                    res.add(l, r);
                }
            }
        }
        return res;
    }

    public List<SQLRow> getReferentRows(SQLField refField) {
        return this.getReferentRows(refField, SQLSelect.UNARCHIVED);
    }

    public List<SQLRow> getReferentRows(SQLField refField, SQLSelect.ArchiveMode archived) {
        return this.getReferentRows(refField, archived, null);
    }

    public List<SQLRow> getReferentRows(SQLField refField, SQLSelect.ArchiveMode archived, Collection<String> fields) {
        return this.getReferentRows(Collections.singleton(refField.getTable().getDBSystemRoot().getGraph().getForeignLink(refField)), archived, fields);
    }

    private List<SQLRow> getReferentRows(Set<Link> links, SQLSelect.ArchiveMode archived, Collection<String> fields) {
        if (links.isEmpty()) {
            return Collections.emptyList();
        }
        SQLTable src = null;
        Where w = null;
        for (Link l : links) {
            if (src == null) {
                src = (SQLTable)l.getSource();
            } else if (!((SQLTable)l.getSource()).equals(src)) {
                throw new IllegalArgumentException(l + " doesn't come from " + src);
            }
            if (!((SQLTable)l.getTarget()).equals(this.getTable())) {
                throw new IllegalArgumentException(l + " doesn't point to " + this.getTable());
            }
            w = new Where((FieldRef)l.getLabel(), "=", this.getID()).or(w);
        }
        SQLSelect sel = new SQLSelect();
        if (fields == null) {
            sel.addSelectStar(src);
        } else {
            sel.addSelect(src.getKey());
            for (String f : fields) {
                sel.addSelect(src.getField(f));
            }
        }
        sel.setWhere(w);
        sel.setArchivedPolicy(archived);
        sel.addOrderSilent(src.getName());
        return SQLRowListRSH.execute(sel);
    }

    private Set<SQLRow> getConnectedRows() {
        HashSet<SQLRow> res = new HashSet<SQLRow>();
        res.addAll(this.getReferentRows((Set<SQLTable>)null, SQLSelect.BOTH));
        res.addAll(this.getForeignRows(SQLRowMode.EXIST));
        return res;
    }

    public Collection<SQLRow> followLink(Link l, Link.Direction direction) {
        boolean backwards = ((Path)Path.get(this.getTable()).add(l, direction)).isBackwards(0);
        if (backwards) {
            return this.getReferentRows(l.getSingleField());
        }
        return Collections.singletonList(this.getForeign(l.getSingleField().getName()));
    }

    public Set<SQLRow> findDistantArchived(int maxLength) {
        return this.findDistantArchived(maxLength, new HashSet<SQLRow>(), 0);
    }

    private Set<SQLRow> findDistantArchived(int maxLength, Set<SQLRow> been, int length) {
        HashSet<SQLRow> res = new HashSet<SQLRow>();
        if (maxLength == length) {
            return res;
        }
        been.add(this);
        ++length;
        HashSet<SQLRow> rec = new HashSet<SQLRow>();
        for (SQLRow row : this.getConnectedRows()) {
            if (been.contains(row)) continue;
            if (row.isArchived()) {
                res.add(row);
                continue;
            }
            rec.add(row);
        }
        for (SQLRow row : rec) {
            res.addAll(row.findDistantArchived(maxLength, been, length));
        }
        return res;
    }

    public String toString() {
        return this.fullToString(false);
    }

    public String fullToString(boolean allowDBAccess) {
        Boolean exists;
        String res = this.simpleToString();
        Boolean bl = exists = allowDBAccess || this.isFilled() ? Boolean.valueOf(this.exists()) : null;
        if (exists == null) {
            res = "?" + res + "?";
        } else if (!exists.booleanValue()) {
            res = "-" + res + "-";
        } else {
            Boolean archived;
            block9: {
                archived = null;
                try {
                    archived = this.isArchived(allowDBAccess);
                }
                catch (Exception e) {
                    Log.get().log(Level.FINER, "Couldn't determine archive status", e);
                    if ($assertionsDisabled || archived == null) break block9;
                    throw new AssertionError();
                }
            }
            if (archived == null) {
                res = "?" + res + "?";
            } else if (archived.booleanValue()) {
                res = "(" + res + ")";
            }
        }
        return res;
    }

    public String simpleToString() {
        return String.valueOf(this.getTable().getName()) + "[" + this.ID + "]";
    }

    @Override
    public String mapToString() {
        String result = String.valueOf(this.fullToString(false)) + " : ";
        return String.valueOf(result) + (this.values != null ? this.values : (this.isFilled() ? "not in DB" : "not filled"));
    }

    @Override
    public Map<String, Object> getAbsolutelyAll() {
        return Collections.unmodifiableMap(this.getValues());
    }

    public Map<String, Object> getAllValues() {
        return this.getValues(ALL_VALUES_FIELDS);
    }

    public SQLRowValues createUpdateRow() {
        return new SQLRowValues(this.getTable(), this.getValues());
    }

    @Override
    public int getID() {
        return this.ID;
    }

    @Override
    public Number getIDNumber() {
        return this.idNumber;
    }

    @Override
    public SQLRow asRow() {
        return this;
    }

    @Override
    public final SQLRowValues asRowValues() {
        return this.createUpdateRow();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SQLRow)) {
            return false;
        }
        SQLRow o = (SQLRow)other;
        return this.equalsAsRow(o);
    }

    public int hashCode() {
        return this.hashCodeAsRow();
    }

    public static List<String> toList(String path) {
        return Arrays.asList(SQLRow.toArray(path));
    }

    private static String[] toArray(String path) {
        if (path.length() == 0) {
            return new String[0];
        }
        return path.split(",");
    }

    @Override
    public SQLTableModifiedListener createTableListener(SQLDataListener l) {
        return new SQLTableListenerData<SQLRow>(this, l);
    }
}

