/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.awt.Dialog;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.ShowAs;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.element.SQLElementNamesFromXML;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldMapper;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLFilter;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.utils.BaseDirs;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.LogUtils;
import org.openconcerto.utils.MultipleOutputStream;
import org.openconcerto.utils.NetUtils;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.ReflectUtils;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Value;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.i18n.TranslationManager;

@ThreadSafe
public class PropsConfiguration
extends Configuration {
    public static final String JDBC_CONNECTION = "jdbc.connection.";
    public static final String LOG = "log.level.";
    public static final String REDIRECT_TO_FILE = "redirectToFile";
    public static final String STD_STREAMS_DESTINATION = "stdStreamsDest";
    public static final String EMPTY_PROP_VALUE;
    private static final DateFormat DATE_FORMAT;
    public static final Properties DEFAULTS;
    private final Properties props;
    @GuardedBy(value="treeLock")
    private SQLServer server;
    @GuardedBy(value="treeLock")
    private DBSystemRoot sysRoot;
    @GuardedBy(value="treeLock")
    private DBRoot root;
    @GuardedBy(value="treeLock")
    private UserManager uMngr;
    @GuardedBy(value="treeLock")
    private UserRightsManager urMngr;
    @GuardedBy(value="restLock")
    private ProductInfo productInfo;
    @GuardedBy(value="restLock")
    private SQLFilter filter;
    private final Addable<SQLElementDirectory> directory;
    @GuardedBy(value="restLock")
    private File wd;
    @GuardedBy(value="restLock")
    private BaseDirs baseDirs;
    @GuardedBy(value="restLock")
    private File logDir;
    @GuardedBy(value="restLock")
    private Locale locale = Locale.getDefault();
    private final boolean inIDE;
    private final Object treeLock = new String("treeLock");
    private final Object restLock = new String("everythingElseLock");
    @GuardedBy(value="treeLock")
    private Session conn;
    @GuardedBy(value="treeLock")
    private int tunnelLocalPort = -1;
    @GuardedBy(value="treeLock")
    private Thread sslThread;
    private FieldMapper fieldMapper;
    @GuardedBy(value="treeLock")
    private boolean destroyed;

    static {
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM/dd_EEEE");
        DEFAULTS = new Properties();
        File wd = new File(System.getProperty("user.dir"));
        DEFAULTS.setProperty("wd", wd.getPath());
        DEFAULTS.setProperty("customer", "test");
        DEFAULTS.setProperty("server.ip", "127.0.0.1");
        DEFAULTS.setProperty("server.login", "root");
        EMPTY_PROP_VALUE = "";
        assert (EMPTY_PROP_VALUE != null);
    }

    public static String getHostname() {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "local";
        }
        return addr.getHostName();
    }

    protected static Properties create(InputStream f, Properties defaults) throws IOException {
        Properties props = new Properties(defaults);
        if (f != null) {
            props.load(f);
            f.close();
        }
        return props;
    }

    public PropsConfiguration() throws IOException {
        this(new File("fwk_SQL.properties"), DEFAULTS);
    }

    public PropsConfiguration(File f, Properties defaults) throws IOException {
        this(new FileInputStream(f), defaults);
    }

    public PropsConfiguration(InputStream f, Properties defaults) throws IOException {
        this(PropsConfiguration.create(f, defaults));
    }

    public PropsConfiguration(Properties props) {
        this.props = props;
        this.directory = new Addable<SQLElementDirectory>(this){

            @Override
            protected SQLElementDirectory create() {
                SQLElementDirectory res = this.createDirectory();
                res.setTranslator(this.createTranslator(res));
                return res;
            }

            @Override
            protected void add(SQLElementDirectory obj, Configuration conf) {
                obj.putAll(conf.getDirectory());
            }

            @Override
            protected void destroy(Future<SQLElementDirectory> future) {
                super.destroy(future);
                try {
                    future.get().destroy();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Couldn't destroy the directory", e);
                }
            }
        };
        this.inIDE = Boolean.getBoolean("inIDE");
        this.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            if (this.server != null) {
                this.server.destroy();
            }
            this.closeSSLConnection();
            if (this.uMngr != null) {
                UserManager.getSingletonManager().clearInstanceIfSame(this.uMngr);
                this.uMngr.destroy();
            }
            if (this.urMngr != null) {
                UserRightsManager.getSingletonManager().clearInstanceIfSame(this.urMngr);
                this.urMngr.destroy();
            }
        }
        this.directory.destroy();
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDestroyed() {
        Object object = this.treeLock;
        synchronized (object) {
            return this.destroyed;
        }
    }

    private final void checkDestroyed() {
        PropsConfiguration.checkDestroyed(this.isDestroyed());
    }

    private static final void checkDestroyed(boolean d) {
        if (d) {
            throw new IllegalStateException("Destroyed");
        }
    }

    public final boolean isInIDE() {
        return this.inIDE;
    }

    public final String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public final String getProperty(String name, String def) {
        return this.props.getProperty(name, def);
    }

    protected final void setProperty(String name, String val) {
        if (val == null) {
            this.props.remove(name);
        } else {
            this.props.setProperty(name, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setProductInfo(ProductInfo productInfo) {
        Object object = this.restLock;
        synchronized (object) {
            this.productInfo = productInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUp() {
        Object object = this.treeLock;
        synchronized (object) {
            this.destroyed = false;
            this.server = null;
            this.sysRoot = null;
            this.root = null;
        }
        object = this.restLock;
        synchronized (object) {
            this.setProductInfo(ProductInfo.getInstance());
            this.setFilter(null);
        }
    }

    public final SQLSystem getSystem() {
        return SQLSystem.get(this.getProperty("server.driver"));
    }

    protected String getLogin() {
        return this.getProperty("server.login");
    }

    protected String getPassword() {
        return this.getProperty("server.password");
    }

    public String getDefaultBase() {
        boolean rootIsBase = this.getSystem().getDBRootLevel().equals((Object)HierarchyLevel.SQLBASE);
        return rootIsBase ? this.getRootName() : this.getSystemRootName();
    }

    private final String toClassName(String rsrcName) {
        if (rsrcName.charAt(0) == '/') {
            return rsrcName.substring(1).replace('/', '.');
        }
        return String.valueOf(this.getResourceWD().getPackage().getName()) + '.' + rsrcName.replace('/', '.');
    }

    public final InputStream getStream(String name) {
        File f = this.getFile(name);
        if (this.mustUseClassloader(f)) {
            return this.getResourceWD().getResourceAsStream(name);
        }
        try {
            return new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    protected Class<? extends PropsConfiguration> getResourceWD() {
        return this.getClass();
    }

    private File getFile(String name) {
        return new File(name.startsWith("/") ? name.substring(1) : name);
    }

    private boolean mustUseClassloader(File f) {
        return this.getFileMode() == FileMode.IN_JAR || !f.exists();
    }

    public final String getResource(String name) {
        File f = this.getFile(name);
        if (this.mustUseClassloader(f)) {
            return this.getResourceWD().getResource(name).toExternalForm();
        }
        return f.getAbsolutePath();
    }

    protected FileMode getFileMode() {
        return FileMode.IN_JAR;
    }

    protected final DBRoot createRoot() {
        Value<String> rootName = this.getRootNameValue();
        if (rootName.hasValue()) {
            return this.getSystemRoot().getRoot(rootName.getValue());
        }
        throw new NullPointerException("no rootname");
    }

    protected UserRightsManager createUserRightsManager(DBRoot root) {
        return UserRightsManager.getSingletonManager().setInstanceIfNone(root);
    }

    public String getRootName() {
        return this.getProperty("base.root", EMPTY_PROP_VALUE);
    }

    public final Value<String> getRootNameValue() {
        String res = this.getRootName();
        return res == null || EMPTY_PROP_VALUE.equals(res) ? Value.getNone() : Value.getSome(res);
    }

    protected SQLFilter createFilter() {
        return SQLFilter.create(this.getSystemRoot(), this.getDirectory());
    }

    public String getWanHostAndPort() {
        String wanAddr = this.getProperty("server.wan.addr");
        String wanPort = this.getProperty("server.wan.port", "22");
        return String.valueOf(wanAddr) + ":" + wanPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isUsingSSH() {
        Object object = this.treeLock;
        synchronized (object) {
            return this.sslThread != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getTunnelLocalPort() {
        Object object = this.treeLock;
        synchronized (object) {
            return this.tunnelLocalPort;
        }
    }

    public final boolean hasWANProperties() {
        String wanAddr = this.getProperty("server.wan.addr");
        String wanPort = this.getProperty("server.wan.port");
        return this.hasWANProperties(wanAddr, wanPort);
    }

    private final boolean hasWANProperties(String wanAddr, String wanPort) {
        return wanAddr != null && wanPort != null;
    }

    protected SQLServer createServer() {
        SQLServer serverThruSSL;
        RuntimeException origExn;
        Logger log;
        String serverID;
        Tuple2<String, Integer> serverAndPort;
        String wanPort;
        String wanAddr;
        block7: {
            wanAddr = this.getProperty("server.wan.addr");
            if (!this.hasWANProperties(wanAddr, wanPort = this.getProperty("server.wan.port"))) {
                return this.doCreateServer();
            }
            serverAndPort = this.parseServerAddressAndPort();
            String serverAndPortString = String.valueOf(serverAndPort.get0()) + ":" + serverAndPort.get1();
            serverID = "tunnel to " + wanAddr + ":" + wanPort + " then " + serverAndPortString;
            log = Log.get();
            origExn = null;
            if (!"true".equals(this.getProperty("server.wan.only"))) {
                try {
                    SQLServer defaultServer = this.doCreateServer(serverAndPortString, null, serverID);
                    defaultServer.getSystemRoot(this.getSystemRootName());
                    log.config("using " + defaultServer);
                    return defaultServer;
                }
                catch (RuntimeException e) {
                    origExn = e;
                    log.config(e.getLocalizedMessage());
                    if ($assertionsDisabled || origExn != null) break block7;
                    throw new AssertionError();
                }
            }
        }
        try {
            log.info("Connecting with SSL to " + wanAddr + ":" + wanPort);
            this.openSSLConnection(wanAddr, Integer.valueOf(wanPort), serverAndPort.get0(), serverAndPort.get1());
            serverThruSSL = this.doCreateServer("localhost:" + this.tunnelLocalPort, null, serverID);
            serverThruSSL.getSystemRoot(this.getSystemRootName());
        }
        catch (Exception e) {
            this.closeSSLConnection();
            this.tunnelLocalPort = -1;
            IllegalStateException exn = new IllegalStateException("Couldn't connect to the DB through SSL", e);
            if (origExn != null) {
                exn.addSuppressed(origExn);
            }
            throw exn;
        }
        return serverThruSSL;
    }

    public final Tuple2<String, Integer> parseServerAddressAndPort() {
        String serverPropVal = this.getProperty("server.ip");
        List<String> serverAndPort = Arrays.asList(serverPropVal.split(":"));
        if (serverAndPort.size() != 2) {
            throw new IllegalStateException("Not in 'host:port' format : " + serverPropVal);
        }
        return Tuple2.create(serverAndPort.get(0), Integer.valueOf(serverAndPort.get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void reconnectSSL() throws Exception {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.conn == null || this.conn.isConnected()) {
                return;
            }
            Log.get().log(Level.WARNING, "SSL disconnected, trying to reconnect");
            String wanAddr = this.getProperty("server.wan.addr");
            String wanPort = this.getProperty("server.wan.port");
            Tuple2<String, Integer> serverAndPort = this.parseServerAddressAndPort();
            try {
                this.openSSLConnection(wanAddr, Integer.valueOf(wanPort), serverAndPort.get0(), serverAndPort.get1());
                Log.get().log(Level.WARNING, "SSL successfully reconnected to " + this.conn.getHost() + ":" + this.conn.getPort());
            }
            catch (Exception e) {
                this.conn.disconnect();
                throw e;
            }
        }
    }

    private SQLServer doCreateServer() {
        return this.doCreateServer(null);
    }

    private SQLServer doCreateServer(String id) {
        return this.doCreateServer(this.getProperty("server.ip"), null, id);
    }

    private SQLServer doCreateServer(String host, String port, String id) {
        SQLServer res = new SQLServer(this.getSystem(), host, port, this.getLogin(), this.getPassword(), (IClosure<? super DBSystemRoot>)new IClosure<DBSystemRoot>(){

            @Override
            public void executeChecked(DBSystemRoot input) {
                input.setRootsToMap(PropsConfiguration.this.getRootsToMap());
                PropsConfiguration.this.initSystemRoot(input);
            }
        }, (IClosure<? super SQLDataSource>)new IClosure<SQLDataSource>(){

            @Override
            public void executeChecked(SQLDataSource input) {
                PropsConfiguration.this.initDS(input);
            }
        });
        if (id != null) {
            res.setID(id);
        }
        return res;
    }

    private void openSSLConnection(String addr, int port, String tunnelRemoteHost, int tunnelRemotePort) {
        this.checkDestroyed();
        String username = this.getSSLUserName();
        String pass = this.getSSLPassword();
        boolean reconnect = this.tunnelLocalPort > 0;
        boolean isAuthenticated = false;
        JSch jsch = new JSch();
        try {
            if (pass == null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(700);
                String name = String.valueOf(username) + "_dsa";
                InputStream in = this.getClass().getResourceAsStream(name);
                if (in == null) {
                    throw new IllegalStateException("Missing private key " + this.getClass().getCanonicalName() + "/" + name);
                }
                StreamUtils.copy(in, out);
                in.close();
                jsch.addIdentity(username, out.toByteArray(), null, null);
            }
            this.conn = jsch.getSession(username, addr, port);
            if (pass != null) {
                this.conn.setPassword(pass);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            config.put("compression.s2c", "zlib@openssh.com,zlib,none");
            config.put("compression.c2s", "zlib@openssh.com,zlib,none");
            this.conn.setConfig(config);
            this.conn.setTimeout(6000);
            this.conn.setServerAliveInterval(6000);
            this.conn.setServerAliveCountMax(1);
            this.conn.connect();
            this.afterSSLConnect(this.conn);
            isAuthenticated = true;
            int localPort = reconnect ? this.tunnelLocalPort : NetUtils.findFreePort(5436);
            try {
                Log.get().info("Creating SSL tunnel from local port " + localPort + " to remote " + tunnelRemoteHost + ":" + tunnelRemotePort);
                this.conn.setPortForwardingL(localPort, tunnelRemoteHost, tunnelRemotePort);
            }
            catch (Exception e1) {
                throw new IllegalStateException("Impossible de cr\u00e9er le tunnel s\u00e9curis\u00e9", e1);
            }
            assert (reconnect == (this.sslThread != null));
            if (!reconnect) {
                this.tunnelLocalPort = localPort;
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (true) {
                                Thread.sleep(2000L);
                                try {
                                    PropsConfiguration.this.reconnectSSL();
                                }
                                catch (Exception e) {
                                    Log.get().log(Level.WARNING, "Error while checking SSL connection", e);
                                }
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                });
                t.setDaemon(true);
                t.setName("SSL connection watcher");
                t.start();
                this.sslThread = t;
            }
            assert (this.sslThread != null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Connection failed", e);
        }
        if (!isAuthenticated) {
            throw new IllegalStateException("Authentication failed.");
        }
    }

    protected void afterSSLConnect(Session conn) {
    }

    public String getSSLUserName() {
        return this.getProperty("server.wan.user");
    }

    protected String getSSLPassword() {
        return this.getProperty("server.wan.password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSSLConnection() {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.sslThread != null) {
                this.sslThread.interrupt();
                this.sslThread = null;
            }
            if (this.conn != null) {
                this.conn.disconnect();
                this.conn = null;
            }
        }
    }

    protected Collection<String> getRootsToMap() {
        String rootsToMap = this.getProperty("systemRoot.rootsToMap");
        if ("*".equals(rootsToMap)) {
            return null;
        }
        HashSet<String> res = new HashSet<String>();
        Value<String> rootName = this.getRootNameValue();
        if (rootName.hasValue()) {
            res.add(rootName.getValue());
        }
        if (rootsToMap != null) {
            res.addAll(SQLRow.toList(rootsToMap));
        }
        return res;
    }

    protected List<String> getRootPath() {
        return new ArrayList<String>(SQLRow.toList(this.getProperty("systemRoot.rootPath", "")));
    }

    public String getSystemRootName() {
        return this.getProperty("systemRoot");
    }

    protected DBSystemRoot createSystemRoot() {
        DBSystemRoot res = this.getServer(false).getSystemRoot(this.getSystemRootName());
        this.setupSystemRoot(res, true);
        return res;
    }

    protected final void setupSystemRoot(DBSystemRoot res) {
        this.setupSystemRoot(res, false);
    }

    private void setupSystemRoot(DBSystemRoot res, boolean brandNew) {
        if (!brandNew) {
            res.unsetRootPath();
        }
        if (res.getChildrenNames().contains(this.getRootName())) {
            res.setDefaultRoot(this.getRootName());
        }
        for (String root : this.getRootPath()) {
            if (!res.getChildrenNames().contains(root)) continue;
            res.appendToRootPath(root);
        }
    }

    protected void initSystemRoot(DBSystemRoot input) {
    }

    protected void initDS(final SQLDataSource ds) {
        ds.setCacheEnabled(true);
        String appID = this.getAppID();
        if (appID != null) {
            ds.addConnectionProperty("ApplicationName", appID);
        }
        this.propIterate(new IClosure<String>(){

            @Override
            public void executeChecked(String propName) {
                String jdbcName = propName.substring(PropsConfiguration.JDBC_CONNECTION.length());
                ds.addConnectionProperty(jdbcName, PropsConfiguration.this.getProperty(propName));
            }
        }, JDBC_CONNECTION);
    }

    public final void propIterate(IClosure<String> cl, final String startsWith) {
        this.propIterate(cl, (IPredicate<? super String>)new IPredicate<String>(){

            @Override
            public boolean evaluateChecked(String propName) {
                return propName.startsWith(startsWith);
            }
        });
    }

    public final void propIterate(IClosure<String> cl, IPredicate<? super String> filter) {
        for (String propName : this.props.stringPropertyNames()) {
            if (!filter.evaluateChecked(propName)) continue;
            cl.executeChecked(propName);
        }
    }

    public final Set<String> getPropertyNames() {
        return this.props.stringPropertyNames();
    }

    public final void setLoggersLevel() {
        this.propIterate(new IClosure<String>(){

            @Override
            public void executeChecked(String propName) {
                String logName = propName.substring(PropsConfiguration.LOG.length());
                LogUtils.getLogger(logName).setLevel(Level.parse(PropsConfiguration.this.getProperty(propName)));
            }
        }, LOG);
    }

    public void setupLogging() {
        this.setupLogging("logs");
    }

    public final void setupLogging(String dirName) {
        this.setupLogging(dirName, this.getStandardStreamsDestination());
    }

    protected final StandardStreamsDest getStandardStreamsDestination() {
        String propVal = System.getProperty(STD_STREAMS_DESTINATION);
        if (propVal == null) {
            propVal = this.getProperty(STD_STREAMS_DESTINATION);
        }
        StandardStreamsDest res = propVal != null ? StandardStreamsDest.valueOf(propVal) : this.getStandardStreamsDestinationDefault();
        return res;
    }

    protected StandardStreamsDest getStandardStreamsDestinationDefault() {
        return Boolean.getBoolean(REDIRECT_TO_FILE) ? StandardStreamsDest.ALSO_TO_FILE : StandardStreamsDest.DEFAULT;
    }

    protected DateFormat getLogDateFormat() {
        return DATE_FORMAT;
    }

    private final File getValidLogDir(String dirName) {
        File logDir;
        try {
            File softLogDir = new File(this.getWD() + "/" + dirName + "/" + PropsConfiguration.getHostname() + "-" + System.getProperty("user.name"));
            softLogDir.mkdirs();
            if (softLogDir.canWrite()) {
                logDir = softLogDir;
            } else {
                File homeLogDir = new File(String.valueOf(System.getProperty("user.home")) + "/." + this.getAppName() + "/" + dirName);
                FileUtils.mkdir_p(homeLogDir);
                if (homeLogDir.canWrite()) {
                    logDir = homeLogDir;
                } else {
                    throw new IOException("Home log directory not writeable : " + homeLogDir);
                }
            }
            assert (logDir.exists() && logDir.canWrite());
            System.out.println("Log directory: " + logDir.getAbsolutePath());
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to create log dir", e);
        }
        return logDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setupLogging(String dirName, StandardStreamsDest stdRedirect) {
        File logFile;
        File logDir;
        Object object = this.restLock;
        synchronized (object) {
            if (this.logDir != null) {
                throw new IllegalStateException("Already set to " + this.logDir);
            }
            this.logDir = logDir = this.getValidLogDir(dirName);
        }
        String logNameBase = String.valueOf(this.getAppName()) + "_" + this.getLogDateFormat().format(new Date());
        if (stdRedirect != StandardStreamsDest.DEFAULT) {
            logFile = new File(logDir, String.valueOf(logNameBase) + ".txt");
            try {
                OutputStream err;
                OutputStream out;
                FileUtils.mkdir_p(logFile.getParentFile());
                System.out.println("Standard output and error file: " + logFile.getAbsolutePath());
                FileOutputStream fileOut = new FileOutputStream(logFile, true);
                if (this.isInIDE() || stdRedirect != StandardStreamsDest.ONLY_TO_FILE) {
                    System.out.println("Redirecting standard output to file and console");
                    out = new MultipleOutputStream(fileOut, System.out);
                    System.out.println("Redirecting error output to file and console");
                    err = new MultipleOutputStream(fileOut, System.err);
                } else {
                    System.out.println("Redirecting standard output to file");
                    out = fileOut;
                    System.out.println("Redirecting error output to file");
                    err = fileOut;
                }
                System.setErr(new PrintStream(new BufferedOutputStream(err, 128), true));
                System.setOut(new PrintStream(new BufferedOutputStream(out, 128), true));
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileUtils.ln(logFile, new File(logDir, "last.log"));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
            }
            catch (Exception e) {
                throw new IllegalStateException("Redirection des sorties standards impossible", e);
            }
        } else {
            System.out.println("Standard streams not redirected to file");
        }
        LogUtils.rmRootHandlers();
        LogUtils.setUpConsoleHandler();
        try {
            logFile = new File(logDir, String.valueOf(this.getAppName()) + "-%u-age%g.log");
            FileUtils.mkdir_p(logFile.getParentFile());
            System.out.println("Logger logs: " + logFile.getAbsolutePath());
            FileHandler fh = new FileHandler(logFile.getPath(), 0x500000, 2, true);
            fh.setFormatter(new SimpleFormatter());
            Logger.getLogger("").addHandler(fh);
        }
        catch (Exception e) {
            throw new IllegalStateException("Enregistrement du Logger d\u00e9sactiv\u00e9", e);
        }
        this.setLoggersLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final File getLogDir() {
        Object object = this.restLock;
        synchronized (object) {
            return this.logDir;
        }
    }

    public void tearDownLogging() {
        this.tearDownLogging(Boolean.getBoolean(REDIRECT_TO_FILE));
    }

    public void tearDownLogging(boolean redirectToFile) {
        LogUtils.rmRootHandlers();
        if (redirectToFile) {
            System.out.close();
            System.err.close();
        }
    }

    protected SQLElementDirectory createDirectory() {
        return new SQLElementDirectory();
    }

    protected List<String> getMappings() {
        return Arrays.asList("mapping", "mapping-" + this.getProperty("customer"));
    }

    protected SQLFieldTranslator createTranslator(SQLElementDirectory dir) {
        List<String> mappings = this.getMappings();
        if (mappings.size() == 0) {
            throw new IllegalStateException("empty mappings");
        }
        SQLFieldTranslator trns = new SQLFieldTranslator(this.getRoot(), dir);
        return this.loadTranslations(trns, this.getRoot(), mappings);
    }

    protected final SQLFieldTranslator loadTranslations(SQLFieldTranslator trns, DBRoot root, List<String> mappings) {
        Locale locale = this.getLocale();
        ResourceBundle.Control cntrl = TranslationManager.getControl();
        boolean found = false;
        String fakeBaseName = "";
        Locale targetLocale = locale;
        while (targetLocale != null && !found) {
            List<Locale> langs = cntrl.getCandidateLocales("", targetLocale);
            ListIterator<Locale> listIterator = CollectionUtils.getListIterator(langs, true);
            while (listIterator.hasNext()) {
                Locale lang = listIterator.next();
                SQLElementNamesFromXML elemNames = new SQLElementNamesFromXML(lang);
                found |= this.loadTranslations(trns, PropsConfiguration.class.getResourceAsStream(String.valueOf(cntrl.toBundleName("mapping", lang)) + ".xml"), root, elemNames);
                for (String m : mappings) {
                    String bundleName = cntrl.toBundleName(m, lang);
                    found |= this.loadTranslations(trns, this.getStream(String.valueOf(bundleName) + ".xml"), root, elemNames);
                    Class<TranslatorFiller> loadedClass = ReflectUtils.getSubclass(this.toClassName(bundleName), TranslatorFiller.class);
                    if (loadedClass == null) continue;
                    try {
                        ReflectUtils.createInstance(loadedClass, this).fill(trns);
                    }
                    catch (Exception e) {
                        Log.get().log(Level.WARNING, "Couldn't use " + loadedClass, e);
                    }
                }
            }
            targetLocale = cntrl.getFallbackLocale("", targetLocale);
        }
        return trns;
    }

    private final boolean loadTranslations(SQLFieldTranslator trns, InputStream in, DBRoot root, SQLElementNamesFromXML elemNames) {
        boolean res;
        boolean bl = res = in != null;
        if (res) {
            trns.load(root, in, elemNames);
        }
        return res;
    }

    protected File createWD() {
        return new File(this.getProperty("wd"));
    }

    protected BaseDirs createBaseDirs() {
        return BaseDirs.create(this.getProductInfo(), this.getAppVariant());
    }

    @Override
    public final Configuration add(Configuration conf) {
        this.directory.add(conf);
        return this;
    }

    @Override
    public final ShowAs getShowAs() {
        return this.getDirectory().getShowAs();
    }

    @Override
    public final SQLBase getBase() {
        return this.getNode(SQLBase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DBRoot getRoot() {
        Object object = this.treeLock;
        synchronized (object) {
            this.checkDestroyed();
            if (this.root == null) {
                this.setRoot(this.createRoot());
            }
            return this.root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final UserManager getUserManager() {
        Object object = this.treeLock;
        synchronized (object) {
            this.getRoot();
            return this.uMngr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final UserRightsManager getUserRightsManager() {
        Object object = this.treeLock;
        synchronized (object) {
            this.getRoot();
            return this.urMngr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DBSystemRoot getSystemRoot() {
        Object object = this.treeLock;
        synchronized (object) {
            this.checkDestroyed();
            if (this.sysRoot == null) {
                this.sysRoot = this.createSystemRoot();
            }
            return this.sysRoot;
        }
    }

    public final Thread createDBCheckThread(JFrame mainFrame, final Runnable quitRunnable) {
        final DBSystemRoot sysRoot = this.getSystemRoot();
        String quit = "Quitter le logiciel";
        final JOptionPane optionPane = new JOptionPane("Impossible de contacter la base. Cette fen\u00eatre se fermera d\u00e8s le r\u00e9tablissement de la connexion. Sinon vous pouvez quitter le logiciel.", -1, 0, null, new Object[]{"Quitter le logiciel"}, null);
        final JDialog dialog = optionPane.createDialog(mainFrame, "Erreur de connexion");
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setDefaultCloseOperation(0);
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (optionPane.getValue().equals("Quitter le logiciel")) {
                    quitRunnable.run();
                } else {
                    dialog.setVisible(true);
                }
            }
        });
        dialog.pack();
        Thread dbConn = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean pb = false;
                while (true) {
                    try {
                        Thread.sleep((pb ? 4 : 20) * 1000);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    try {
                        sysRoot.getDataSource().validateDBConnectivity();
                        if (!pb) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                dialog.dispose();
                            }
                        });
                        pb = false;
                        continue;
                    }
                    catch (Exception e) {
                        if (pb) continue;
                        pb = true;
                        e.printStackTrace();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                dialog.setLocationRelativeTo(dialog.getOwner());
                                dialog.setVisible(true);
                            }
                        });
                        continue;
                    }
                    break;
                }
            }
        }, "databaseConnectivity");
        dbConn.setDaemon(true);
        return dbConn;
    }

    public final <T extends DBStructureItem<?>> T getNode(Class<T> clazz) {
        SQLSystem sys = this.getServer().getSQLSystem();
        HierarchyLevel l = sys.getLevel(clazz);
        if (l == HierarchyLevel.SQLSERVER) {
            return this.getServer().getAnc(clazz);
        }
        if (l == sys.getLevel(DBSystemRoot.class)) {
            return this.getSystemRoot().getAnc(clazz);
        }
        if (l == sys.getLevel(DBRoot.class)) {
            return this.getRoot().getAnc(clazz);
        }
        throw new IllegalArgumentException("doesn't know an item of " + clazz);
    }

    public final SQLServer getServer() {
        return this.getServer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SQLServer getServer(boolean initSysRoot) {
        Object object = this.treeLock;
        synchronized (object) {
            this.checkDestroyed();
            if (this.server == null) {
                this.setServer(this.createServer());
                if (initSysRoot && this.server.getSQLSystem().getLevel(DBSystemRoot.class) == HierarchyLevel.SQLSERVER) {
                    this.getSystemRoot();
                }
            }
            return this.server;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SQLFilter getFilter() {
        Object object = this.restLock;
        synchronized (object) {
            if (this.filter == null) {
                this.setFilter(this.createFilter());
            }
            return this.filter;
        }
    }

    @Override
    public final SQLElementDirectory getDirectory() {
        return this.directory.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ProductInfo getProductInfo() {
        Object object = this.restLock;
        synchronized (object) {
            return this.productInfo;
        }
    }

    @Override
    public final String getAppName() {
        ProductInfo productInfo = this.getProductInfo();
        if (productInfo != null) {
            return productInfo.getName();
        }
        return this.getProperty("app.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final File getWD() {
        Object object = this.restLock;
        synchronized (object) {
            if (this.wd == null) {
                this.setWD(this.createWD());
            }
            return this.wd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseDirs getBaseDirs() {
        Object object = this.restLock;
        synchronized (object) {
            if (this.baseDirs == null) {
                this.baseDirs = this.createBaseDirs();
            }
            return this.baseDirs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Locale getLocale() {
        Object object = this.restLock;
        synchronized (object) {
            return this.locale;
        }
    }

    private final void setFilter(SQLFilter filter) {
        this.filter = filter;
    }

    private void setServer(SQLServer server) {
        this.server = server;
    }

    private final void setRoot(DBRoot root) {
        this.root = root;
        this.checkDestroyed();
        this.urMngr = this.createUserRightsManager(root);
        this.uMngr = UserManager.getSingletonManager().setInstanceIfNone(root);
    }

    private final void setWD(File dir) {
        this.wd = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        boolean localeChangedAndDirExists;
        Objects.requireNonNull(locale);
        Object object = this.restLock;
        synchronized (object) {
            if (locale.equals(this.locale)) {
                localeChangedAndDirExists = false;
            } else {
                this.locale = locale;
                localeChangedAndDirExists = this.directory.isComputeStarted();
            }
        }
        if (localeChangedAndDirExists) {
            SQLElementDirectory dir = this.getDirectory();
            dir.setTranslator(this.createTranslator(dir));
        }
    }

    @Override
    public FieldMapper getFieldMapper() {
        return this.fieldMapper;
    }

    public void setFieldMapper(FieldMapper fieldMapper) {
        this.fieldMapper = fieldMapper;
    }

    public static abstract class AbstractTranslatorFiller
    implements TranslatorFiller {
        private final PropsConfiguration conf;

        public AbstractTranslatorFiller(PropsConfiguration conf) {
            this.conf = conf;
        }

        protected final PropsConfiguration getConf() {
            return this.conf;
        }
    }

    private abstract class Addable<T> {
        @GuardedBy(value="this")
        private boolean destroyed;
        @GuardedBy(value="this")
        private final List<Configuration> toAdd;
        @GuardedBy(value="this")
        private Future<T> f;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Addable() {
            Addable addable = this;
            synchronized (addable) {
                this.toAdd = new ArrayList<Configuration>();
                this.f = null;
                this.destroyed = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void add(Configuration conf) {
            boolean computeStarted;
            Addable addable = this;
            synchronized (addable) {
                computeStarted = this.isComputeStarted();
                if (!computeStarted) {
                    this.toAdd.add(conf);
                }
            }
            if (computeStarted) {
                this.add(this.get(), conf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final boolean isComputeStarted() {
            Addable addable = this;
            synchronized (addable) {
                return this.f != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final T get() {
            Future<T> future;
            FutureTask<T> futureTask;
            Addable addable = this;
            synchronized (addable) {
                PropsConfiguration.checkDestroyed(this.destroyed);
                if (this.f == null) {
                    final ArrayList<Configuration> l = new ArrayList<Configuration>(this.toAdd);
                    this.toAdd.clear();
                    futureTask = new FutureTask<T>(new Callable<T>(){

                        @Override
                        public T call() throws Exception {
                            Object res = Addable.this.create();
                            if (!$assertionsDisabled && Thread.holdsLock(Addable.this)) {
                                throw new AssertionError();
                            }
                            for (Configuration s : l) {
                                Addable.this.add(res, s);
                            }
                            return res;
                        }
                    });
                    this.f = futureTask;
                    future = futureTask;
                } else {
                    futureTask = null;
                    future = this.f;
                }
            }
            if (futureTask != null) {
                futureTask.run();
            }
            try {
                return future.get();
            }
            catch (InterruptedException e) {
                throw new RTInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }

        protected abstract T create();

        protected abstract void add(T var1, Configuration var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void destroy() {
            Future<T> future;
            Addable addable = this;
            synchronized (addable) {
                this.destroyed = true;
                future = this.f;
            }
            if (future != null) {
                this.destroy(future);
            }
        }

        protected void destroy(Future<T> future) {
        }
    }

    protected static enum FileMode {
        IN_JAR,
        NORMAL_FILE;

    }

    public static enum StandardStreamsDest {
        DEFAULT(true),
        ONLY_TO_FILE(false),
        ALSO_TO_FILE(true);

        private final boolean hasDefaultStreams;

        private StandardStreamsDest(boolean hasDefaultStreams) {
            this.hasDefaultStreams = hasDefaultStreams;
        }

        public final boolean hasDefaultStreams() {
            return this.hasDefaultStreams;
        }
    }

    @FunctionalInterface
    public static interface TranslatorFiller {
        public void fill(SQLFieldTranslator var1);
    }
}

