/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.preferences;

import javax.swing.table.AbstractTableModel;
import org.openconcerto.erp.generationDoc.TemplateManager;
import org.openconcerto.erp.generationDoc.TemplateProvider;

public class TemplateTableModel
extends AbstractTableModel {
    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Mod\u00e8le";
        }
        return "Synchronis\u00e9";
    }

    @Override
    public int getRowCount() {
        return TemplateManager.getInstance().getKnownTemplateIds().size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String templateId = this.getTemplateId(rowIndex);
        if (columnIndex == 0) {
            return templateId;
        }
        TemplateProvider p = TemplateManager.getInstance().getProvider(templateId);
        if (p.isSynced(templateId, null, null)) {
            return "oui";
        }
        return "non";
    }

    public TemplateProvider getTemplateProvider(int rowIndex) {
        String templateId = this.getTemplateId(rowIndex);
        return TemplateManager.getInstance().getProvider(templateId);
    }

    public boolean isSynced(int rowIndex) {
        return this.getTemplateProvider(rowIndex).isSynced(this.getTemplateId(rowIndex), null, null);
    }

    public void sync(int rowIndex) {
        this.getTemplateProvider(rowIndex).sync(this.getTemplateId(rowIndex), null, null);
        this.fireTableDataChanged();
    }

    public void unsync(int rowIndex) {
        this.getTemplateProvider(rowIndex).unSync(this.getTemplateId(rowIndex), null, null);
        this.fireTableDataChanged();
    }

    public void restore(int rowIndex) {
        this.getTemplateProvider(rowIndex).restore(this.getTemplateId(rowIndex), null, null);
        this.fireTableDataChanged();
    }

    public String getTemplateId(int rowIndex) {
        return TemplateManager.getInstance().getKnownTemplateIds().get(rowIndex);
    }
}

