/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.RegisterState;
import org.openconcerto.erp.core.sales.pos.model.TicketItem;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.ui.touch.ScrollableList;

public class TicketPanel
extends JPanel
implements CaisseListener {
    private final DateFormat df = new SimpleDateFormat("' le' d MMMM \u00e0 H:mm");
    private final Image bg;
    private final ListModel<TicketItem> dataModel;
    private final List<ListDataListener> listeners = new ArrayList<ListDataListener>();
    private final JLabel lTotal = new JLabel("", 4);
    private final JLabel lNumero = new JLabel("", 2);
    private final CaisseControler controler;
    private final ScrollableList list;
    private int xOffset = 0;

    TicketPanel(final CaisseControler controler) {
        this.controler = controler;
        this.controler.addCaisseListener(this);
        if (this.controler.getPOSConf().getScreenWidth() < 1280) {
            this.xOffset = -24;
        }
        this.setOpaque(false);
        this.bg = new ImageIcon(TicketPanel.class.getResource("ticket.png")).getImage();
        this.setLayout(null);
        this.dataModel = new ListModel<TicketItem>(){

            @Override
            public void addListDataListener(ListDataListener l) {
                TicketPanel.this.listeners.add(l);
            }

            @Override
            public TicketItem getElementAt(int index) {
                return controler.getItems().get(index);
            }

            @Override
            public int getSize() {
                return controler.getItems().size();
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
                TicketPanel.this.listeners.remove(l);
            }
        };
        this.list = new ScrollableList(this.dataModel){
            private final TicketCellRenderer renderer;
            {
                this.renderer = new TicketCellRenderer();
            }

            @Override
            public void paintCell(Graphics g, Object value, int index, boolean isSelected, int posY) {
                g.translate(0, posY);
                this.renderer.paint(g, TicketPanel.this.list, (TicketItem)value, index, isSelected);
                g.translate(0, -posY);
            }
        };
        this.list.setOpaque(false);
        this.list.setSize(315, 450);
        this.list.setFixedCellHeight(40);
        this.list.setLocation(30 + this.xOffset, 18);
        this.add(this.list);
        this.lTotal.setSize(266, 32);
        this.lTotal.setLocation(68 + this.xOffset, 468);
        this.lTotal.setFont(new Font("Arial", 1, 18));
        this.add(this.lTotal);
        this.lNumero.setSize(266, 32);
        this.lNumero.setLocation(68 + this.xOffset, 500);
        this.lNumero.setForeground(Color.DARK_GRAY);
        this.lNumero.setFont(new Font("Arial", 1, 12));
        this.add(this.lNumero);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object selectedValue;
                if (!e.getValueIsAdjusting() && (selectedValue = TicketPanel.this.list.getSelectedValue()) != null) {
                    TicketItem item = (TicketItem)selectedValue;
                    controler.setTicketItemSelected(item);
                    controler.setTicketItemSelected(item);
                }
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.drawImage(this.bg, this.xOffset, 0, null);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        try {
            RegisterState registerState = this.controler.getCaisseFrame().getFiles().getLastLog().getRegisterState();
            String infoCaisseVendeur = "Caisse " + this.controler.getPOSConf().getPosID() + "  Vendeur " + this.controler.getPOSConf().getUserID();
            String infoCaisse = String.valueOf(registerState.getStatus() == RegisterState.Status.OPEN ? "Ouverte" : "Ferm\u00e9e") + registerState.formatDate(this.df);
            g.setColor(new Color(230, 230, 230));
            if (this.controler.getPOSConf().getScreenWidth() < 1280) {
                g.setFont(this.getFont().deriveFont(16.0f));
            } else {
                g.setFont(this.getFont().deriveFont(14.0f));
            }
            int w1 = g.getFontMetrics().stringWidth(infoCaisseVendeur);
            int w2 = g.getFontMetrics().stringWidth(infoCaisse);
            int x = 330 - Math.max(w1, w2) + this.xOffset;
            g.drawString(infoCaisseVendeur, x, this.getHeight() - 40);
            g.setColor(Color.LIGHT_GRAY);
            g.drawString(infoCaisse, x, this.getHeight() - 25);
        }
        catch (Exception e) {
            POSConfiguration.getLogger().log(Level.WARNING, "Couldn't find register state", e);
        }
        super.paintComponent(g);
    }

    int getMinWidth() {
        if (this.controler.getPOSConf().getScreenWidth() < 1280) {
            return 330;
        }
        return 480;
    }

    int getMaxHeight() {
        if (this.controler.getPOSConf().getScreenHeight() < 1000) {
            return 550;
        }
        return 707;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.getMinWidth(), 550);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getMinWidth(), this.getMaxHeight());
    }

    public void fire() {
        for (ListDataListener l : this.listeners) {
            l.contentsChanged(new ListDataEvent(this, 0, 0, this.listeners.size()));
        }
    }

    @Override
    public void caisseStateChanged() {
        Article articleSelected = this.controler.getArticleSelected();
        for (ListDataListener l : this.listeners) {
            l.contentsChanged(new ListDataEvent(this, 0, 0, this.listeners.size()));
        }
        this.lTotal.setText("TOTAL:  " + TicketCellRenderer.centsToString(this.controler.getTotal()) + " \u20ac");
        this.lNumero.setText("Ticket " + this.controler.getTicketNumber());
        if (articleSelected == null) {
            this.list.clearSelection();
            return;
        }
        try {
            if (this.list.getSelectedValue() != null && articleSelected.equals(((TicketItem)this.list.getSelectedValue()).getArticle())) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < this.dataModel.getSize()) {
            TicketItem item = this.dataModel.getElementAt(i);
            if (item.getArticle().equals(articleSelected)) {
                this.list.setSelectedValue(item, true);
                break;
            }
            ++i;
        }
    }
}

