/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.ui;

import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class GestionChequesRenderer
extends DefaultTableCellRenderer {
    private static final Color CHEQUE_VALIDE_COLOR = new Color(255, 128, 64);
    private final DateFormat dateFormat = DateFormat.getDateInstance(2);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component res = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Color fgColor = value != null && !isSelected && System.currentTimeMillis() > ((Date)value).getTime() ? CHEQUE_VALIDE_COLOR : table.getForeground();
        res.setForeground(fgColor);
        return res;
    }

    @Override
    protected void setValue(Object value) {
        if (value == null) {
            super.setValue(null);
        } else {
            super.setValue(this.dateFormat.format((Date)value));
        }
    }
}

