/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.translation.menu;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.translation.LocaleSelector;
import org.openconcerto.modules.extensionbuilder.translation.menu.MenuTranslation;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.group.LayoutHints;

public class MenuTranslationItemEditor
extends JPanel {
    final Extension extension;
    private JTextField textId;
    private JTextField textTranslation1;
    private JTextField textTranslation2;
    final LocaleSelector comboLang1;
    final LocaleSelector comboLang2;

    public MenuTranslationItemEditor(final Item item, final Extension extension) {
        this.extension = extension;
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Identifiant", 4), c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 3;
        this.textId = new JTextField();
        this.add((Component)this.textId, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        this.add((Component)new JLabel("Langue et pays", 4), c);
        String[] isoLanguages = Locale.getISOLanguages();
        System.out.println(isoLanguages.length);
        this.comboLang1 = new LocaleSelector();
        c.weightx = 1.0;
        ++c.gridx;
        c.fill = 0;
        this.add((Component)this.comboLang1, c);
        c.weightx = 0.0;
        ++c.gridx;
        c.gridheight = 2;
        c.fill = 1;
        JSeparator sep = new JSeparator(1);
        this.add((Component)sep, c);
        c.gridheight = 1;
        c.weightx = 1.0;
        ++c.gridx;
        c.fill = 0;
        this.comboLang2 = new LocaleSelector();
        this.comboLang2.setLocale(Locale.ENGLISH);
        this.add((Component)this.comboLang2, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Traduction", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.textTranslation1 = new JTextField(20);
        this.add((Component)this.textTranslation1, c);
        c.gridx += 2;
        c.fill = 2;
        c.weightx = 1.0;
        this.textTranslation2 = new JTextField(20);
        this.add((Component)this.textTranslation2, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.add((Component)new JPanel(), c);
        this.initUIFrom(item);
        this.textTranslation1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                extension.setMenuTranslation(item.getId(), MenuTranslationItemEditor.this.textTranslation1.getText(), MenuTranslationItemEditor.this.comboLang1.getLocale());
                extension.setChanged();
            }
        });
        this.textTranslation2.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                extension.setMenuTranslation(item.getId(), MenuTranslationItemEditor.this.textTranslation2.getText(), MenuTranslationItemEditor.this.comboLang2.getLocale());
                extension.setChanged();
            }
        });
        this.comboLang1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuTranslation t = extension.getMenuTranslation(MenuTranslationItemEditor.this.textId.getText(), MenuTranslationItemEditor.this.comboLang1.getLocale().toString());
                if (t != null) {
                    MenuTranslationItemEditor.this.textTranslation1.setText(t.getLabel());
                } else {
                    MenuTranslationItemEditor.this.textTranslation1.setText("");
                }
            }
        });
        this.comboLang2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuTranslation t = extension.getMenuTranslation(MenuTranslationItemEditor.this.textId.getText(), MenuTranslationItemEditor.this.comboLang2.getLocale().toString());
                if (t != null) {
                    MenuTranslationItemEditor.this.textTranslation2.setText(t.getLabel());
                } else {
                    MenuTranslationItemEditor.this.textTranslation2.setText("");
                }
            }
        });
    }

    private void initUIFrom(Item item) {
        MenuTranslation t;
        LayoutHints localHint = item.getLocalHint();
        System.out.println("ItemEditor.initUIFrom:" + item + " " + localHint);
        this.textId.setEnabled(false);
        if (this.textId != null) {
            this.textId.setText(item.getId());
        }
        if ((t = this.extension.getMenuTranslation(this.textId.getText(), this.comboLang1.getLocale().toString())) != null) {
            this.textTranslation1.setText(t.getLabel());
        } else {
            this.textTranslation1.setText("");
        }
        t = this.extension.getMenuTranslation(this.textId.getText(), this.comboLang2.getLocale().toString());
        if (t != null) {
            this.textTranslation2.setText(t.getLabel());
        } else {
            this.textTranslation2.setText("");
        }
    }
}

