/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.translation.field;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.translation.LocaleSelector;
import org.openconcerto.modules.extensionbuilder.translation.field.SimpleDocumentListener;
import org.openconcerto.modules.extensionbuilder.translation.field.TableTranslation;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;

public class TableTranslationEditorPanel
extends JPanel {
    private final List<JComponent> hideableComponents = new ArrayList<JComponent>();
    final JTextField textSingular1 = new JTextField();
    final JTextField textSingular2 = new JTextField();
    final JTextField textPlural1 = new JTextField();
    final JTextField textPlural2 = new JTextField();
    private Map<String, JTextField> map1 = new HashMap<String, JTextField>();
    private Map<String, JTextField> map2 = new HashMap<String, JTextField>();
    private Map<JTextField, String> fieldsMap = new HashMap<JTextField, String>();

    TableTranslationEditorPanel(final Extension extension, final String tableName) {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 2;
        c.fill = 0;
        this.add((Component)new JLabelBold("Table " + tableName), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Langue et pays", 4), c);
        String[] isoLanguages = Locale.getISOLanguages();
        System.out.println(isoLanguages.length);
        final LocaleSelector comboLang1 = new LocaleSelector();
        c.weightx = 1.0;
        ++c.gridx;
        c.fill = 0;
        this.add((Component)comboLang1, c);
        c.weightx = 0.0;
        ++c.gridx;
        c.gridheight = 3;
        c.fill = 1;
        JSeparator sep = new JSeparator(1);
        this.add((Component)sep, c);
        this.hideableComponents.add(sep);
        c.gridheight = 1;
        c.weightx = 1.0;
        ++c.gridx;
        c.fill = 0;
        final LocaleSelector comboLang2 = new LocaleSelector();
        this.hideableComponents.add(comboLang2);
        comboLang2.setLocale(Locale.ENGLISH);
        this.add((Component)comboLang2, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Singulier", 4), c);
        ++c.gridx;
        this.add((Component)this.textSingular1, c);
        c.gridx += 2;
        this.hideableComponents.add(this.textSingular2);
        this.add((Component)this.textSingular2, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Pluriel", 4), c);
        ++c.gridx;
        this.add((Component)this.textPlural1, c);
        c.gridx += 2;
        this.hideableComponents.add(this.textPlural2);
        this.add((Component)this.textPlural2, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.fill = 0;
        this.add((Component)new JLabelBold("Champs de la table"), c);
        c.gridwidth = 1;
        List<String> fieldsName = this.getFieldsName(extension, tableName);
        ++c.gridy;
        c.gridheight = fieldsName.size();
        c.gridx = 2;
        c.fill = 1;
        JSeparator sep2 = new JSeparator(1);
        this.hideableComponents.add(sep2);
        this.add((Component)sep2, c);
        c.fill = 2;
        c.gridheight = 1;
        for (String fName : fieldsName) {
            c.gridx = 0;
            c.weightx = 0.0;
            this.add((Component)new JLabel(fName, 4), c);
            ++c.gridx;
            JTextField t1 = new JTextField();
            this.map1.put(fName, t1);
            this.fieldsMap.put(t1, fName);
            this.add((Component)t1, c);
            c.gridx += 2;
            JTextField t2 = new JTextField();
            this.hideableComponents.add(t2);
            this.fieldsMap.put(t2, fName);
            this.map2.put(fName, t2);
            this.add((Component)t2, c);
            ++c.gridy;
        }
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 0.0;
        this.add((Component)new JPanel(), c);
        this.updateUIFrom(extension, tableName, comboLang1.getLocale(), comboLang2.getLocale());
        comboLang1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableTranslationEditorPanel.this.updateUIFrom(extension, tableName, comboLang1.getLocale(), null);
            }
        });
        comboLang2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableTranslationEditorPanel.this.updateUIFrom(extension, tableName, null, comboLang2.getLocale());
            }
        });
        this.textSingular1.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e, String text) {
                extension.setTableSingularTranslation(tableName, comboLang1.getLocale(), text);
            }
        });
        this.textSingular2.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e, String text) {
                extension.setTableSingularTranslation(tableName, comboLang2.getLocale(), text);
            }
        });
        this.textPlural1.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e, String text) {
                extension.setTablePluralTranslation(tableName, comboLang1.getLocale(), text);
            }
        });
        this.textPlural2.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e, String text) {
                extension.setTablePluralTranslation(tableName, comboLang2.getLocale(), text);
            }
        });
        for (final JTextField textField : this.map1.values()) {
            textField.getDocument().addDocumentListener(new SimpleDocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e, String text) {
                    extension.setFieldTranslation(tableName, (String)TableTranslationEditorPanel.this.fieldsMap.get(textField), comboLang1.getLocale(), text);
                }
            });
        }
        for (final JTextField textField : this.map2.values()) {
            textField.getDocument().addDocumentListener(new SimpleDocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e, String text) {
                    extension.setFieldTranslation(tableName, (String)TableTranslationEditorPanel.this.fieldsMap.get(textField), comboLang2.getLocale(), text);
                }
            });
        }
    }

    private void updateUIFrom(Extension extension, String tableName, Object l1, Object l2) {
        String lang;
        if (l1 != null) {
            lang = l1.toString();
            this.updateUI(extension, tableName, lang, this.textSingular1, this.textPlural1, this.map1);
        }
        if (l2 != null) {
            lang = l2.toString();
            this.updateUI(extension, tableName, lang, this.textSingular2, this.textPlural2, this.map2);
        }
    }

    private void updateUI(Extension extension, String tableName, String lang, JTextField textSingular, JTextField textPlural, Map<String, JTextField> map) {
        TableTranslation tTrans = extension.getTableTranslation(lang, tableName);
        if (tTrans != null && tTrans.getSingular() != null) {
            textSingular.setText(tTrans.getSingular());
        } else {
            textSingular.setText("");
        }
        if (tTrans != null && tTrans.getPlural() != null) {
            textPlural.setText(tTrans.getPlural());
        } else {
            textPlural.setText("");
        }
        for (String fName : map.keySet()) {
            String t = extension.getFieldTranslation(lang, tableName, fName);
            if (t != null) {
                map.get(fName).setText(t);
                continue;
            }
            map.get(fName).setText("");
        }
    }

    private List<String> getFieldsName(Extension extension, String tableName) {
        HashSet<String> l = new HashSet<String>();
        l.addAll(extension.getAllKnownFieldName(tableName));
        List<String> lT = extension.getTranslatedFieldOfTable(tableName);
        l.addAll(lT);
        l.remove("ARCHIVE");
        l.remove("ORDRE");
        l.remove("ID_USER_COMMON_CREATE");
        l.remove("ID_USER_COMMON_MODIFY");
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(l);
        Collections.sort(result);
        return result;
    }
}

