/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.translation;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LocaleSelector
extends JPanel {
    private String lang;
    private String country;
    private JComboBox comboLang;
    private JComboBox comboCountry;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private boolean interactive = true;

    public LocaleSelector() {
        this.setLayout(new FlowLayout(0));
        Vector<String> langs = new Vector<String>();
        Locale[] l = Locale.getAvailableLocales();
        int i = 0;
        while (i < l.length) {
            String language = l[i].getLanguage();
            if (!langs.contains(language)) {
                langs.add(language);
            }
            ++i;
        }
        Collections.sort(langs);
        this.comboLang = new JComboBox(langs);
        this.add(this.comboLang);
        this.comboCountry = new JComboBox();
        this.add(this.comboCountry);
        try {
            this.setLocale(Locale.getDefault());
        }
        catch (Exception e) {
            System.err.println("LocaleSelector warning: unable to set current language");
        }
        this.comboLang.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LocaleSelector.this.interactive) {
                    LocaleSelector.this.lang = LocaleSelector.this.comboLang.getSelectedItem().toString();
                    LocaleSelector.this.updateCountryFromLang();
                    LocaleSelector.this.country = LocaleSelector.this.comboCountry.getSelectedItem().toString();
                    LocaleSelector.this.fireActionPerformed();
                }
            }
        });
        this.comboCountry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LocaleSelector.this.interactive) {
                    LocaleSelector.this.country = LocaleSelector.this.comboCountry.getSelectedItem().toString();
                    LocaleSelector.this.fireActionPerformed();
                }
            }
        });
        int minWidth = this.comboLang.getPreferredSize().width * 2;
        int minHeight = this.comboLang.getPreferredSize().height;
        this.comboLang.setMinimumSize(new Dimension(minWidth, minHeight));
        this.comboLang.setPreferredSize(new Dimension(minWidth, minHeight));
        this.comboCountry.setMinimumSize(new Dimension(minWidth, minHeight));
        this.comboCountry.setPreferredSize(new Dimension(minWidth, minHeight));
    }

    private void updateCountryFromLang() {
        Vector<String> countries = new Vector<String>();
        Locale[] l = Locale.getAvailableLocales();
        int i = 0;
        while (i < l.length) {
            Locale lo = l[i];
            if (lo.getLanguage().equals(this.lang)) {
                countries.add(lo.getCountry());
            }
            ++i;
        }
        Collections.sort(countries);
        if (countries.isEmpty()) {
            countries.add("");
        }
        this.comboCountry.setModel(new DefaultComboBoxModel(countries));
    }

    @Override
    public Locale getLocale() {
        Locale lo;
        int i;
        Locale[] l = Locale.getAvailableLocales();
        if (this.country != null) {
            i = 0;
            while (i < l.length) {
                lo = l[i];
                if (lo.getLanguage().equals(this.lang) && lo.getCountry().equals(this.country)) {
                    return lo;
                }
                ++i;
            }
        }
        i = 0;
        while (i < l.length) {
            lo = l[i];
            if (lo.getLanguage().equals(this.lang)) {
                return lo;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setLocale(Locale l) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must be called in EDT");
        }
        if (l.getLanguage().equals(this.lang) && l.getCountry().equals(this.country)) {
            return;
        }
        this.interactive = false;
        this.lang = l.getLanguage();
        this.country = l.getCountry();
        System.err.println("LocaleSelector.setLocale() " + this.lang + " " + this.country);
        this.comboLang.setSelectedItem(this.lang);
        this.updateCountryFromLang();
        this.comboCountry.setSelectedItem(this.country);
        this.interactive = true;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void fireActionPerformed() {
        System.err.println("LocaleSelector.fireActionPerformed():" + this.lang + " " + this.country);
        System.err.println("LocaleSelector.fireActionPerformed(); locale: " + this.getLocale());
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(new ActionEvent(this, this.hashCode(), ""));
        }
    }
}

