/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.table.AllTableListModel;
import org.openconcerto.modules.extensionbuilder.table.ModifiedTableListModel;
import org.openconcerto.modules.extensionbuilder.table.SQLTableListCellRenderer;
import org.openconcerto.modules.extensionbuilder.table.TableDescritor;
import org.openconcerto.modules.extensionbuilder.table.TableModifyMainPanel;
import org.openconcerto.modules.extensionbuilder.table.TableModifyPanel;
import org.openconcerto.sql.model.SQLTable;

public class TableModifyLeftPanel
extends JPanel {
    private final TableModifyMainPanel tableModifyMainPanel;
    private final Extension extension;
    private JList listTableModified;
    private JList listTableAll;

    TableModifyLeftPanel(Extension extension, TableModifyMainPanel tableModifyMainPanel) {
        this.extension = extension;
        this.tableModifyMainPanel = tableModifyMainPanel;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 0);
        this.add((Component)new JLabel("Tables modifi\u00e9es"), c);
        c.weighty = 1.0;
        c.fill = 1;
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.createModifiedTableList(extension), c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 0);
        this.add((Component)new JLabel("Toutes les tables"), c);
        c.weighty = 2.0;
        c.fill = 1;
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.createAllTableList(extension), c);
    }

    private JComponent createModifiedTableList(final Extension extension) {
        ModifiedTableListModel dataModel = new ModifiedTableListModel(extension);
        this.listTableModified = new JList(dataModel);
        this.listTableModified.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TableDescritor tableDesc;
                if (!e.getValueIsAdjusting() && (tableDesc = (TableDescritor)TableModifyLeftPanel.this.listTableModified.getSelectedValue()) != null) {
                    System.out.println("TableModifyLeftPanel.createModifiedTableList.valueChanged():" + tableDesc);
                    TableModifyPanel p = new TableModifyPanel(extension.getSQLTable(tableDesc), tableDesc, extension, TableModifyLeftPanel.this);
                    TableModifyLeftPanel.this.tableModifyMainPanel.setRightPanel(p);
                    TableModifyLeftPanel.this.listTableAll.clearSelection();
                }
            }
        });
        JScrollPane comp2 = new JScrollPane(this.listTableModified);
        comp2.setMinimumSize(new Dimension(250, 150));
        comp2.setPreferredSize(new Dimension(250, 150));
        return comp2;
    }

    private JComponent createAllTableList(final Extension extension) {
        AllTableListModel dataModel = new AllTableListModel(extension);
        this.listTableAll = new JList(dataModel);
        this.listTableAll.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SQLTable table;
                if (!e.getValueIsAdjusting() && (table = (SQLTable)TableModifyLeftPanel.this.listTableAll.getSelectedValue()) != null) {
                    System.out.println("TableModifyLeftPanel.createAllTableList.valueChanged():" + table);
                    TableModifyPanel p = new TableModifyPanel(table, extension.getOrCreateTableDescritor(table.getName()), extension, TableModifyLeftPanel.this);
                    TableModifyLeftPanel.this.tableModifyMainPanel.setRightPanel(p);
                    TableModifyLeftPanel.this.listTableModified.clearSelection();
                }
            }
        });
        this.listTableAll.setCellRenderer(new SQLTableListCellRenderer());
        JScrollPane comp2 = new JScrollPane(this.listTableAll);
        comp2.setMinimumSize(new Dimension(150, 150));
        comp2.setPreferredSize(new Dimension(150, 150));
        return comp2;
    }

    public void selectTable(String tableName) {
        System.out.println("TableModifyLeftPanel.selectTable():" + tableName);
        if (tableName != null) {
            TableDescritor tableDesc = this.extension.getOrCreateTableDescritor(tableName);
            TableModifyPanel p = new TableModifyPanel(this.extension.getSQLTable(tableDesc), tableDesc, this.extension, this);
            this.tableModifyMainPanel.setRightPanel(p);
            this.listTableAll.clearSelection();
            this.listTableModified.clearSelection();
        }
    }
}

