/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.modules.extensionbuilder.ClickableLabel;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.table.FieldDescriptor;
import org.openconcerto.modules.extensionbuilder.table.FieldDescriptorEditor;
import org.openconcerto.modules.extensionbuilder.table.TableDescritor;
import org.openconcerto.modules.extensionbuilder.table.TableModifyLeftPanel;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.DefaultListModel;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.Tuple2;

public class TableModifyInfoPanel
extends JPanel
implements Scrollable {
    private Extension extension;

    public TableModifyInfoPanel(Extension extension, SQLTable t, TableDescritor desc, final TableModifyLeftPanel leftPanel) {
        this.extension = extension;
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        Set fields = t.getFields();
        ArrayList<SQLField> allFields = new ArrayList<SQLField>();
        for (SQLField sqlField : fields) {
            String fName = sqlField.getName();
            if (fName.equalsIgnoreCase("ARCHIVE") || fName.equalsIgnoreCase("ORDRE")) continue;
            allFields.add(sqlField);
        }
        Collections.sort(allFields, new Comparator<SQLField>(){

            @Override
            public int compare(SQLField o1, SQLField o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList lt = new ArrayList(t.getDBSystemRoot().getGraph().getReferentTables(t));
        Collections.sort(lt, new Comparator<SQLTable>(){

            @Override
            public int compare(SQLTable o1, SQLTable o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (lt.size() > 0) {
            this.add((Component)new JLabel(String.valueOf(lt.size()) + " champs des tables suivantes r\u00e9f\u00e9rencent la table " + t.getName() + " :"), c);
            ++c.gridy;
            c.weightx = 0.0;
            for (final SQLTable sqlTable : lt) {
                this.add((Component)new ClickableLabel(sqlTable.getName(), new Runnable(){

                    @Override
                    public void run() {
                        leftPanel.selectTable(sqlTable.getName());
                    }
                }), c);
                ++c.gridy;
            }
            ++c.gridy;
            c.weightx = 1.0;
            this.add((Component)new JLabel(" "), c);
            ++c.gridy;
        }
        this.add((Component)new JLabel("Cette table contient " + allFields.size() + " champs :"), c);
        ++c.gridy;
        for (SQLField sqlField : allFields) {
            String type;
            String str = "";
            JPanel line = new JPanel();
            line.add((Component)new JLabelBold(sqlField.getName()));
            line.setOpaque(false);
            line.setLayout(new FlowLayout(3, 0, 0));
            try {
                String label = ComptaPropsConfiguration.getTranslator((SQLTable)t).getLabelFor(sqlField);
                if (label != null) {
                    str = String.valueOf(str) + " (" + label + ")";
                }
            }
            catch (Exception label) {
                // empty catch block
            }
            if ((type = sqlField.getTypeDecl().toLowerCase()).contains("double") || type.contains("real") || type.contains("float")) {
                type = "nombre d\u00e9cimal";
            } else if (type.contains("int")) {
                type = "nombre entier";
            } else if (type.contains("text") || type.contains("varchar")) {
                type = "texte";
            } else if (type.contains("boolean")) {
                type = "bool\u00e9en";
            } else if (type.contains("timestamp")) {
                type = "date et heure";
            }
            if (sqlField.isKey() && sqlField.getForeignTable() != null) {
                final SQLTable foreignTable = sqlField.getForeignTable();
                str = String.valueOf(str) + " r\u00e9f\u00e9rence vers la table ";
                line.add(new JLabel(str));
                if (foreignTable.getDBRoot().equals(t.getDBRoot())) {
                    line.add(new ClickableLabel(foreignTable.getName(), new Runnable(){

                        @Override
                        public void run() {
                            leftPanel.selectTable(foreignTable.getName());
                        }
                    }));
                } else {
                    line.add(new JLabel(foreignTable.getName()));
                }
                SQLElement e = ComptaPropsConfiguration.getInstanceCompta().getDirectory().getElement(foreignTable);
                if (e != null) {
                    line.add(new JLabel(" (cad " + e.getSingularName() + ")"));
                }
            } else if (sqlField.isPrimaryKey()) {
                str = String.valueOf(str) + " clef primaire";
                line.add(new JLabel(str));
            } else {
                str = String.valueOf(str) + " de type " + type;
                line.add(new JLabel(str));
            }
            this.add((Component)line, c);
            ++c.gridy;
        }
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        c.weighty = 1.0;
        ++c.gridy;
        this.add((Component)spacer, c);
    }

    Tuple2<JPanel, GridBagConstraints> createEditorList(TableDescritor desc) {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        List<FieldDescriptor> fields = desc.getFields();
        for (FieldDescriptor field : fields) {
            this.addField(desc, p, (GridBagConstraints)c, field);
        }
        Tuple2 result = Tuple2.create((Object)p, (Object)c);
        return result;
    }

    private void addField(final TableDescritor desc, final JPanel p, GridBagConstraints c, final FieldDescriptor field) {
        c.weightx = 1.0;
        c.gridx = 0;
        final FieldDescriptorEditor editor = new FieldDescriptorEditor(this.extension, field);
        p.add((Component)editor, c);
        ++c.gridx;
        c.weightx = 0.0;
        final JButton close = new JButton(new ImageIcon(DefaultListModel.class.getResource("close_popup.png")));
        p.add((Component)close, c);
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                desc.remove(field);
                p.remove(editor);
                p.remove(close);
                p.revalidate();
            }
        });
        ++c.gridy;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height / 10;
            }
            case 0: {
                return visibleRect.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height;
            }
            case 0: {
                return visibleRect.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }
}

