/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Log;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.ExtensionGroupSQLComponent;
import org.openconcerto.modules.extensionbuilder.component.ComponentDescritor;
import org.openconcerto.modules.extensionbuilder.list.ColumnDescriptor;
import org.openconcerto.modules.extensionbuilder.list.ListDescriptor;
import org.openconcerto.modules.extensionbuilder.table.FieldDescriptor;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;

public class TableDescritor {
    private String name;
    private List<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();

    public TableDescritor(String string) {
        this.name = string;
    }

    public void createElement(final Extension ext) {
        ComptaPropsConfiguration conf = ComptaPropsConfiguration.getInstanceCompta();
        DBRoot root = conf.getRootSociete();
        if (conf.getDirectory().getElement(this.name) == null) {
            final SQLTable table = root.getTable(this.name);
            SQLElement e = new SQLElement("ext." + this.name, "ext." + this.name, table){

                protected List<String> getListFields() {
                    return new ArrayList<String>(0);
                }

                protected List<String> getComboFields() {
                    ArrayList<String> l = new ArrayList<String>();
                    int matchCodeNom = 0;
                    for (SQLField field : this.getTable().getContentFields()) {
                        l.add(field.getName());
                        if (!field.getName().equalsIgnoreCase("CODE") && !field.getName().equalsIgnoreCase("NOM")) continue;
                        ++matchCodeNom;
                    }
                    if (matchCodeNom == 2) {
                        l.add("CODE");
                        l.add("NOM");
                    } else {
                        ListDescriptor listDesc = null;
                        l.clear();
                        for (ListDescriptor listDescriptor : ext.getCreateListList()) {
                            if (!listDescriptor.getMainTable().equals(this.getTable().getName())) continue;
                            listDesc = listDescriptor;
                            break;
                        }
                        if (listDesc != null) {
                            for (ColumnDescriptor string : listDesc.getColumns()) {
                                if (string.getFieldsPaths().contains(".")) continue;
                                l.add(string.getFieldsPaths());
                                break;
                            }
                        }
                        if (l.isEmpty() && !this.getTable().getContentFields().isEmpty()) {
                            l.add(((SQLField)new ArrayList(this.getTable().getContentFields()).get(0)).getName());
                        }
                    }
                    return l;
                }

                protected SQLTableModelSourceOnline instantiateTableSourceOnline(ListSQLRequest req) {
                    ListDescriptor listDesc = null;
                    for (ListDescriptor listDescriptor : ext.getCreateListList()) {
                        if (!listDescriptor.getMainTable().equals(this.getTable().getName())) continue;
                        listDesc = listDescriptor;
                        break;
                    }
                    if (listDesc != null) {
                        return ext.createSource(this, req, listDesc);
                    }
                    return super.instantiateTableSourceOnline(req);
                }

                protected SQLComponent createComponent() {
                    for (ComponentDescritor cDescriptor : ext.getCreateComponentList()) {
                        if (!cDescriptor.getTable().equals(table.getTable().getName())) continue;
                        return new ExtensionGroupSQLComponent(this, cDescriptor.getGroup());
                    }
                    JOptionPane.showMessageDialog(new JFrame(), "Unable to create default creation component for table " + TableDescritor.this.name);
                    return null;
                }
            };
            conf.getDirectory().addSQLElement(e);
            Log.get().info("Autocreate element for table: " + table.getName());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<FieldDescriptor> getFields() {
        return this.fields;
    }

    public void add(FieldDescriptor f) {
        this.fields.add(f);
    }

    public void remove(FieldDescriptor field) {
        this.fields.remove(field);
    }

    public String toString() {
        return this.name;
    }

    public void sortFields() {
        Collections.sort(this.fields, new Comparator<FieldDescriptor>(){

            @Override
            public int compare(FieldDescriptor o1, FieldDescriptor o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
    }
}

