/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.table.FieldDescriptor;
import org.openconcerto.modules.extensionbuilder.table.FieldDescriptorEditor;
import org.openconcerto.modules.extensionbuilder.table.TableDescritor;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.DefaultListModel;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.Tuple2;

public class TableCreatePanel
extends JPanel {
    private final Extension extension;

    public TableCreatePanel(final TableDescritor desc, final Extension extension) {
        this.extension = extension;
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.add((Component)new JLabelBold("Table " + desc.getName()), c);
        c.weightx = 1.0;
        ++c.gridy;
        final Tuple2<JPanel, GridBagConstraints> l = this.createEditorList(desc);
        this.add((Component)l.get0(), c);
        ++c.gridy;
        c.fill = 0;
        c.anchor = 17;
        JButton buttonAdd = new JButton("Ajouter un champs");
        this.add((Component)buttonAdd, c);
        ++c.gridy;
        JPanel spacer = new JPanel();
        c.weighty = 1.0;
        this.add((Component)spacer, c);
        buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldDescriptor f = new FieldDescriptor(desc.getName(), "field" + (((JPanel)l.get0()).getComponentCount() / 2 + 1), "string", "", "200", "");
                GridBagConstraints c1 = (GridBagConstraints)l.get1();
                desc.add(f);
                TableCreatePanel.this.addField(desc, (JPanel)l.get0(), c1, f);
                ((JPanel)l.get0()).revalidate();
                extension.setChanged();
            }
        });
    }

    Tuple2<JPanel, GridBagConstraints> createEditorList(TableDescritor desc) {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        List<FieldDescriptor> fields = desc.getFields();
        for (FieldDescriptor field : fields) {
            this.addField(desc, p, (GridBagConstraints)c, field);
        }
        Tuple2 result = Tuple2.create((Object)p, (Object)c);
        return result;
    }

    private void addField(final TableDescritor desc, final JPanel p, GridBagConstraints c, final FieldDescriptor field) {
        c.weightx = 1.0;
        c.gridx = 0;
        final FieldDescriptorEditor editor = new FieldDescriptorEditor(this.extension, field);
        p.add((Component)editor, c);
        ++c.gridx;
        c.weightx = 0.0;
        final JButton close = new JButton(new ImageIcon(DefaultListModel.class.getResource("close_popup.png")));
        p.add((Component)close, c);
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                desc.remove(field);
                p.remove(editor);
                p.remove(close);
                p.revalidate();
                TableCreatePanel.this.extension.setChanged();
            }
        });
        ++c.gridy;
    }
}

