/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.table.FieldDescriptor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class FieldDescriptorEditor
extends JPanel
implements ActionListener {
    final JComboBox comboType;
    private JTextField fieldName;
    private JLabel labelOption;
    private JTextField textOption;
    private String[] types = new String[]{"Texte", "Nombre entier", "Nombre d\u00e9cimal", "Bool\u00e9en", "Date", "Heure", "Date et heure", "R\u00e9f\u00e9rence"};
    private String[] xmltypes = new String[]{"string", "integer", "decimal", "boolean", "date", "time", "dateAndTime", "ref"};
    private JComboBox comboOption;
    private static final String[] vBoolean = new String[]{"oui", "non"};
    private static final String[] vDate = new String[]{"vide", "jour actuel"};
    private static final String[] vTime = new String[]{"vide", "heure actuelle"};
    private static final String[] vDateTime = new String[]{"vide", "date actuelle"};
    private static final int TYPE_STRING = 0;
    private static final int TYPE_INTEGER = 1;
    private static final int TYPE_DECIMAL = 2;
    private static final int TYPE_BOOLEAN = 3;
    private static final int TYPE_DATE = 4;
    private static final int TYPE_TIME = 5;
    private static final int TYPE_DATE_TIME = 6;
    private static final int TYPE_REF = 7;
    FieldDescriptor fd;
    private Extension extension;

    FieldDescriptorEditor(Extension extension, FieldDescriptor fd) {
        this.extension = extension;
        this.fd = fd;
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.add((Component)new JLabel("Type"), c);
        ++c.gridx;
        this.comboType = new JComboBox<String>(this.types);
        this.comboType.setOpaque(false);
        this.add((Component)this.comboType, c);
        ++c.gridx;
        this.add((Component)new JLabel("Nom"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.fieldName = new JTextField(10);
        this.add((Component)this.fieldName, c);
        c.weightx = 0.0;
        ++c.gridx;
        this.labelOption = new JLabel("Longeur max");
        this.add((Component)this.labelOption, c);
        ++c.gridx;
        this.textOption = new JTextField(6);
        ++c.gridx;
        this.add((Component)this.textOption, c);
        this.comboOption = new JComboBox();
        this.add((Component)this.comboOption, c);
        this.updateFrom(fd);
        this.comboType.addActionListener(this);
        this.fieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                FieldDescriptorEditor.this.fieldNameModified();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FieldDescriptorEditor.this.fieldNameModified();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FieldDescriptorEditor.this.fieldNameModified();
            }
        });
        this.comboOption.addActionListener(this);
        this.textOption.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                FieldDescriptorEditor.this.fieldOptionModified();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FieldDescriptorEditor.this.fieldOptionModified();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FieldDescriptorEditor.this.fieldOptionModified();
            }
        });
    }

    protected void fieldNameModified() {
        String text = this.fieldName.getText();
        if (text.trim().length() > 0) {
            this.fd.setName(text);
        }
        this.extension.setChanged();
    }

    protected void fieldOptionModified() {
        String text = this.textOption.getText();
        if (text.trim().length() > 0) {
            switch (this.comboType.getSelectedIndex()) {
                case 0: {
                    this.fd.setLength(text);
                    this.fd.setDefaultValue(null);
                    this.fd.setForeignTable(null);
                    this.fd.setLink(null);
                    break;
                }
                case 1: {
                    this.fd.setLength(null);
                    try {
                        int i = Integer.parseInt(text);
                        this.fd.setDefaultValue(text);
                    }
                    catch (Exception e) {
                        this.fd.setDefaultValue("0");
                    }
                    this.fd.setForeignTable(null);
                    this.fd.setLink(null);
                }
                case 2: {
                    this.fd.setLength(null);
                    try {
                        text = text.replace(',', '.');
                        float i = Float.parseFloat(text);
                        this.fd.setDefaultValue(text);
                    }
                    catch (Exception e) {
                        this.fd.setDefaultValue("0");
                    }
                    this.fd.setForeignTable(null);
                    this.fd.setLink(null);
                }
            }
            this.extension.setChanged();
        }
    }

    protected void comboOptionModified() {
        int index = this.comboOption.getSelectedIndex();
        switch (this.comboType.getSelectedIndex()) {
            case 3: {
                this.fd.setLength(null);
                if (index == 0) {
                    this.fd.setDefaultValue("true");
                } else {
                    this.fd.setDefaultValue("false");
                }
                this.fd.setForeignTable(null);
                this.fd.setLink(null);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.fd.setLength(null);
                if (index == 0) {
                    this.fd.setDefaultValue(null);
                } else {
                    this.fd.setDefaultValue("now");
                }
                this.fd.setForeignTable(null);
                this.fd.setLink(null);
                break;
            }
            case 7: {
                this.fd.setLength(null);
                this.fd.setDefaultValue(null);
                this.fd.setForeignTable(this.comboOption.getSelectedItem().toString());
                this.fd.setLink(null);
            }
        }
        this.extension.setChanged();
    }

    private void updateFrom(FieldDescriptor fd) {
        if (fd.getType().equals("string")) {
            this.comboType.setSelectedIndex(0);
            this.labelOption.setText("Longueur max");
            this.textOption.setVisible(true);
            this.textOption.setText(fd.getLength());
            this.comboOption.setVisible(false);
        } else if (fd.getType().equals("integer")) {
            this.comboType.setSelectedIndex(1);
            this.labelOption.setText("Valeur par d\u00e9faut");
            this.textOption.setVisible(true);
            this.textOption.setText(fd.getDefaultValue());
            this.comboOption.setVisible(false);
        } else if (fd.getType().equals("decimal")) {
            this.comboType.setSelectedIndex(2);
            this.labelOption.setText("Valeur par d\u00e9faut");
            this.textOption.setVisible(true);
            this.textOption.setText(fd.getDefaultValue());
            this.comboOption.setVisible(false);
        } else if (fd.getType().equals("boolean")) {
            this.comboType.setSelectedIndex(3);
            this.labelOption.setText("Valeur par d\u00e9faut");
            this.textOption.setVisible(false);
            this.comboOption.setVisible(true);
            this.comboOption.setModel(new DefaultComboBoxModel<String>(vBoolean));
            if (fd.getDefaultValue().equals("true")) {
                this.comboOption.setSelectedIndex(0);
            } else {
                this.comboOption.setSelectedIndex(1);
            }
        } else if (fd.getType().equals("date")) {
            this.comboType.setSelectedIndex(4);
            this.labelOption.setText("Valeur par d\u00e9faut");
            this.textOption.setVisible(false);
            this.comboOption.setVisible(true);
            this.comboOption.setModel(new DefaultComboBoxModel<String>(vDate));
            if (fd.getDefaultValue() == null || !fd.getDefaultValue().equals("now")) {
                this.comboOption.setSelectedIndex(0);
            } else {
                this.comboOption.setSelectedIndex(1);
            }
        } else if (fd.getType().equals("time")) {
            this.comboType.setSelectedIndex(5);
            this.labelOption.setText("Valeur par d\u00e9faut");
            this.textOption.setVisible(false);
            this.comboOption.setVisible(true);
            this.comboOption.setModel(new DefaultComboBoxModel<String>(vTime));
            if (fd.getDefaultValue() == null || !fd.getDefaultValue().equals("now")) {
                this.comboOption.setSelectedIndex(0);
            } else {
                this.comboOption.setSelectedIndex(1);
            }
        } else if (fd.getType().equals("dateAndTime")) {
            this.comboType.setSelectedIndex(6);
            this.labelOption.setText("Valeur par d\u00e9faut");
            this.textOption.setVisible(false);
            this.comboOption.setVisible(true);
            this.comboOption.setModel(new DefaultComboBoxModel<String>(vDateTime));
            if (fd.getDefaultValue() == null || !fd.getDefaultValue().equals("now")) {
                this.comboOption.setSelectedIndex(0);
            } else {
                this.comboOption.setSelectedIndex(1);
            }
        } else if (fd.getType().equals("ref")) {
            this.comboType.setSelectedIndex(7);
            this.labelOption.setText("Table");
            this.textOption.setVisible(false);
            this.comboOption.setVisible(true);
            final Vector<String> tables = new Vector<String>();
            tables.addAll(Arrays.asList(this.getTables()));
            String tableName = fd.getForeignTable();
            if (!tables.contains(tableName)) {
                tables.add(tableName);
            }
            this.comboOption.setModel(new DefaultComboBoxModel(tables));
            this.comboOption.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (value.toString().trim().isEmpty()) {
                        value = "!! non renseign\u00e9e !!";
                    }
                    DefaultListCellRenderer r = (DefaultListCellRenderer)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (!tables.contains(value)) {
                        r.setForeground(Color.RED);
                    }
                    return r;
                }
            });
            this.comboOption.setSelectedItem(tableName);
        } else {
            throw new IllegalArgumentException("Unknow type " + fd.getType());
        }
        this.fieldName.setText(fd.getName().trim());
    }

    private String[] getTables() {
        ComptaPropsConfiguration instanceCompta = ComptaPropsConfiguration.getInstanceCompta();
        Set t = instanceCompta.getRootSociete().getTables();
        ArrayList<String> names = new ArrayList<String>(t.size());
        for (SQLTable table : t) {
            names.add(table.getName());
        }
        Collections.sort(names);
        return names.toArray(new String[names.size()]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.comboType) {
            String type = this.xmltypes[this.comboType.getSelectedIndex()];
            if (!type.equals(this.fd.getType())) {
                this.fd.setType(type);
                this.updateFrom(this.fd);
            }
        } else if (e.getSource() == this.comboOption) {
            this.comboOptionModified();
        }
    }
}

