/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.meu.actions;

import java.awt.Component;
import java.awt.Window;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.list.EditableListPanel;
import org.openconcerto.modules.extensionbuilder.meu.actions.ActionDescriptor;
import org.openconcerto.modules.extensionbuilder.meu.actions.ActionItemEditor;
import org.openconcerto.modules.extensionbuilder.meu.actions.ActionMainPanel;
import org.openconcerto.modules.extensionbuilder.meu.actions.AllKnownActionsListModel;

public class ActionListPanel
extends EditableListPanel {
    private ActionMainPanel actionPanel;
    private Extension extension;

    public ActionListPanel(Extension extension, ActionMainPanel actionPanel) {
        super((ListModel)((Object)new AllKnownActionsListModel(extension)), "Actions", "Ajouter une action", true, true);
        this.extension = extension;
        this.actionPanel = actionPanel;
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                value = ((ActionDescriptor)value).getId();
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
    }

    @Override
    public void addNewItem() {
        ((AllKnownActionsListModel)((Object)this.dataModel)).addAction();
    }

    @Override
    public void removeItem(Object item) {
        ((AllKnownActionsListModel)((Object)this.dataModel)).removeElement(item);
        this.extension.removeCreateAction((ActionDescriptor)item);
    }

    @Override
    public void renameItem(Object item) {
        ActionDescriptor e = (ActionDescriptor)item;
        Window w = SwingUtilities.windowForComponent(this);
        String s = (String)JOptionPane.showInputDialog(w, "Nouveau nom", "Renommer la liste", -1, null, null, e.getId());
        if (s != null && s.length() > 0) {
            e.setId(s);
            this.reload();
        }
    }

    @Override
    public void itemSelected(Object item) {
        if (item != null) {
            this.actionPanel.setRightPanel(new JScrollPane(new ActionItemEditor((ActionDescriptor)item, this.extension)));
        } else {
            this.actionPanel.setRightPanel(new JPanel());
        }
    }
}

