/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.extensionbuilder.meu.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.modules.extensionbuilder.Extension;
import org.openconcerto.modules.extensionbuilder.component.ComponentDescritor;
import org.openconcerto.modules.extensionbuilder.meu.actions.ActionDescriptor;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class ActionItemEditor
extends JPanel {
    final Extension extension;
    private JTextField textId;
    private JComboBox comboComponent;
    private JTextField textTable;
    private JComboBox comboLocation;

    public ActionItemEditor(final ActionDescriptor actionDescriptor, Extension extension) {
        this.extension = extension;
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Identifiant", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.textId = new JTextField();
        this.add((Component)this.textId, c);
        List<ComponentDescritor> l = extension.getCreateComponentList();
        Vector<ComponentDescritor> v = new Vector<ComponentDescritor>(l);
        Collections.sort(v, new Comparator<ComponentDescritor>(){

            @Override
            public int compare(ComponentDescritor o1, ComponentDescritor o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Composant", 4), c);
        ++c.gridx;
        this.comboComponent = new JComboBox<ComponentDescritor>(v);
        this.comboComponent.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value != null) {
                    value = ((ComponentDescritor)value).getId();
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        c.fill = 0;
        this.add((Component)this.comboComponent, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Table", 4), c);
        ++c.gridx;
        c.fill = 0;
        this.textTable = new JTextField(30);
        this.textTable.setEnabled(false);
        this.add((Component)this.textTable, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Emplacement", 4), c);
        ++c.gridx;
        c.fill = 0;
        this.comboLocation = new JComboBox<String>(new String[]{"Bouton et clic droit", "clic droit uniquement", "bouton uniquement"});
        this.add((Component)this.comboLocation, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.add((Component)new JPanel(), c);
        this.initUIFrom(actionDescriptor);
        this.comboComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentDescritor componentDescritor = ActionItemEditor.this.getComponentDescritor(ActionItemEditor.this.comboComponent.getSelectedItem().toString());
                if (componentDescritor != null) {
                    ActionItemEditor.this.textTable.setText(componentDescritor.getTable());
                    actionDescriptor.setComponentId(componentDescritor.getId());
                    actionDescriptor.setTable(componentDescritor.getTable());
                } else {
                    ActionItemEditor.this.textTable.setText("");
                }
            }
        });
        this.comboLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ActionItemEditor.this.comboLocation.getSelectedIndex();
                if (index == 0) {
                    actionDescriptor.setLocation("header,popup");
                } else if (index == 1) {
                    actionDescriptor.setLocation("popup");
                } else {
                    actionDescriptor.setLocation("header");
                }
            }
        });
        this.textId.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                actionDescriptor.setId(ActionItemEditor.this.textId.getText());
            }
        });
    }

    private void initUIFrom(ActionDescriptor item) {
        this.textId.setText(item.getId());
        ComponentDescritor componentDescritor = this.getComponentDescritor(item.getComponentId());
        if (componentDescritor != null) {
            this.comboComponent.setSelectedItem(componentDescritor);
        }
        this.textTable.setText(item.getTable());
        String loc = item.getLocation();
        if (loc.equals("header,popup")) {
            this.comboLocation.setSelectedIndex(0);
        } else if (loc.equals("header")) {
            this.comboLocation.setSelectedIndex(2);
        } else {
            this.comboLocation.setSelectedIndex(1);
        }
    }

    private ComponentDescritor getComponentDescritor(String componentId) {
        List<ComponentDescritor> l = this.extension.getCreateComponentList();
        for (ComponentDescritor componentDescritor : l) {
            if (!componentDescritor.getId().equals(componentId)) continue;
            return componentDescritor;
        }
        return null;
    }
}

